/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mcp.mobius.opis.api.IMessageHandler;
import mcp.mobius.opis.api.ITabPanel;
import mcp.mobius.opis.data.holders.basetypes.SerialInt;
import mcp.mobius.opis.events.OpisClientTickHandler;
import mcp.mobius.opis.modOpis;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.PacketManager;
import mcp.mobius.opis.network.enums.AccessLevel;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.network.packets.client.PacketReqData;
import mcp.mobius.opis.swing.SelectedTab;
import mcp.mobius.opis.swing.widgets.JButtonAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;

public class SwingUI
extends JFrame
implements WindowListener,
ChangeListener,
IMessageHandler {
    public static HashSet<JButtonAccess> registeredButtons = new HashSet();
    private static SwingUI _instance = new SwingUI();
    private JPanel contentPane;
    private JTabbedPane tabbedPane;

    public static SwingUI instance() {
        return _instance;
    }

    public void showUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingUI.instance().setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private SwingUI() {
        this.setTitle("Opis Control Panel");
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 893, 455);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addChangeListener(this);
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.addWindowListener(this);
        ToolTipManager.sharedInstance().setInitialDelay(500);
        ToolTipManager.sharedInstance().setDismissDelay(60000);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        modOpis.swingOpen = false;
        PacketManager.sendToServer(new PacketReqData(Message.COMMAND_UNREGISTER_SWING));
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case STATUS_ACCESS_LEVEL: {
                SwingUtilities.invokeLater(() -> {
                    AccessLevel level = AccessLevel.values()[((SerialInt)rawdata.value).value];
                    for (JButtonAccess button : registeredButtons) {
                        if (level.ordinal() < button.getAccessLevel().ordinal()) {
                            button.setEnabled(false);
                            continue;
                        }
                        button.setEnabled(true);
                    }
                });
                break;
            }
            case CLIENT_SHOW_SWING: {
                modOpis.swingOpen = true;
                this.showUI();
                OpisClientTickHandler.INSTANCE.scheduleOnClientThread(() -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiChat()));
                PacketManager.sendToServer(new PacketReqData(Message.SWING_TAB_CHANGED, new SerialInt(SelectedTab.SUMMARY.ordinal())));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component source = ((JTabbedPane)e.getSource()).getSelectedComponent();
        if (source instanceof ITabPanel) {
            ITabPanel panel = (ITabPanel)((Object)source);
            PacketManager.sendToServer(new PacketReqData(Message.SWING_TAB_CHANGED, new SerialInt(panel.getSelectedTab().ordinal())));
        }
        if (source instanceof JTabbedPane) {
            JTabbedPane pane = (JTabbedPane)source;
            ITabPanel panel = (ITabPanel)((Object)pane.getSelectedComponent());
            PacketManager.sendToServer(new PacketReqData(Message.SWING_TAB_CHANGED, new SerialInt(panel.getSelectedTab().ordinal())));
        }
    }
}

