/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.mobiuscore.profiler;

import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import mcp.mobius.mobiuscore.profiler.DummyProfiler;
import mcp.mobius.mobiuscore.profiler.IProfilerBase;

public enum ProfilerSection implements IProfilerBase
{
    DIMENSION_TICK(RunType.REALTIME, Side.SERVER),
    DIMENSION_BLOCKTICK(RunType.ONREQUEST, Side.SERVER),
    ENTITY_UPDATETIME(RunType.ONREQUEST, Side.SERVER),
    TICK(RunType.REALTIME, Side.SERVER),
    TILEENT_UPDATETIME(RunType.ONREQUEST, Side.SERVER),
    PACKET_INBOUND(RunType.REALTIME, Side.SERVER),
    PACKET_OUTBOUND(RunType.REALTIME, Side.SERVER),
    NETWORK_TICK(RunType.ONREQUEST, Side.SERVER),
    EVENT_INVOKE(RunType.ONREQUEST, EnumSet.of(Side.CLIENT, Side.SERVER)),
    RENDER_TILEENTITY(RunType.ONREQUEST, Side.CLIENT),
    RENDER_ENTITY(RunType.ONREQUEST, Side.CLIENT),
    RENDER_BLOCK(RunType.ONREQUEST, Side.CLIENT);

    private EnumSet<Side> sides;
    private RunType runType;
    private IProfilerBase profiler = new DummyProfiler();
    private IProfilerBase profilerSuspended = new DummyProfiler();
    public static long timeStampLastRun;

    private ProfilerSection(RunType runType, Side side) {
        this.runType = runType;
        this.profiler = new DummyProfiler();
        this.sides = EnumSet.of(side);
    }

    private ProfilerSection(RunType runType, EnumSet<Side> sides) {
        this.runType = runType;
        this.profiler = new DummyProfiler();
        this.sides = sides;
    }

    public RunType getRunType() {
        return this.runType;
    }

    public EnumSet<Side> getSide() {
        return this.sides;
    }

    public IProfilerBase getProfiler() {
        return this.profilerSuspended;
    }

    public void setProfiler(IProfilerBase profiler) {
        this.profilerSuspended = profiler;
        if (this.runType == RunType.REALTIME) {
            this.profiler = profiler;
        }
    }

    public void activate() {
        this.profiler = this.profilerSuspended;
        timeStampLastRun = System.currentTimeMillis();
    }

    public void desactivate() {
        if (this.runType == RunType.ONREQUEST) {
            this.profiler = new DummyProfiler();
        }
    }

    public static void activateAll(Side trgside) {
        for (ProfilerSection section : ProfilerSection.values()) {
            if (!section.sides.contains(trgside)) continue;
            section.activate();
        }
    }

    public static void desactivateAll(Side trgside) {
        for (ProfilerSection section : ProfilerSection.values()) {
            if (!section.sides.contains(trgside)) continue;
            section.desactivate();
        }
    }

    public static void resetAll(Side trgside) {
        for (ProfilerSection section : ProfilerSection.values()) {
            if (!section.sides.contains(trgside)) continue;
            section.reset();
        }
    }

    public static String getClassName() {
        return ProfilerSection.class.getCanonicalName().replace(".", "/");
    }

    public static String getTypeName() {
        return "L" + ProfilerSection.getClassName() + ";";
    }

    @Override
    public void reset() {
        this.profiler.reset();
        this.profilerSuspended.reset();
    }

    @Override
    public void start() {
        this.profiler.start();
    }

    @Override
    public void stop() {
        this.profiler.stop();
    }

    @Override
    public void start(Object key) {
        this.profiler.start(key);
    }

    @Override
    public void stop(Object key) {
        this.profiler.stop(key);
    }

    @Override
    public void start(Object key1, Object key2) {
        this.profiler.start(key1, key2);
    }

    @Override
    public void stop(Object key1, Object key2) {
        this.profiler.stop(key1, key2);
    }

    @Override
    public void start(Object key1, Object key2, Object key3) {
        this.profiler.start(key1, key2, key3);
    }

    @Override
    public void stop(Object key1, Object key2, Object key3) {
        this.profiler.stop(key1, key2, key3);
    }

    @Override
    public void start(Object key1, Object key2, Object key3, Object key4) {
        this.profiler.start(key1, key2, key3, key4);
    }

    @Override
    public void stop(Object key1, Object key2, Object key3, Object key4) {
        this.profiler.stop(key1, key2, key3, key4);
    }

    public static enum RunType {
        REALTIME,
        ONREQUEST;

    }
}

