/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.rpc.targets;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import openmods.network.rpc.IRpcTarget;
import openmods.network.rpc.IRpcTargetProvider;
import openmods.network.rpc.targets.EntityRpcTarget;
import openmods.network.rpc.targets.TileEntityRpcTarget;
import openmods.sync.ISyncMapProvider;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.utils.ByteUtils;

public abstract class SyncRpcTarget
implements IRpcTarget {
    private final IRpcTarget syncProvider;
    private ISyncableObject object;
    private int objectId;

    protected SyncRpcTarget(IRpcTarget syncProvider) {
        this.syncProvider = syncProvider;
    }

    protected SyncRpcTarget(IRpcTarget syncProvider, SyncMap<?> map, ISyncableObject object) {
        this(syncProvider);
        this.object = object;
        this.objectId = map.getId(object);
    }

    protected <P extends ISyncMapProvider & IRpcTargetProvider> SyncRpcTarget(P provider, ISyncableObject object) {
        this(((IRpcTargetProvider)provider).createRpcTarget(), provider.getSyncMap(), object);
    }

    @Override
    public Object getTarget() {
        return this.object;
    }

    @Override
    public void writeToStream(DataOutput output) throws IOException {
        this.syncProvider.writeToStream(output);
        ByteUtils.writeVLI(output, this.objectId);
    }

    private SyncMap<?> getSyncMap() {
        ISyncMapProvider provider = (ISyncMapProvider)this.syncProvider.getTarget();
        return provider.getSyncMap();
    }

    @Override
    public void readFromStreamStream(EntityPlayer player, DataInput input) throws IOException {
        this.syncProvider.readFromStreamStream(player, input);
        SyncMap<?> map = this.getSyncMap();
        this.objectId = ByteUtils.readVLI(input);
        this.object = map.get(this.objectId);
    }

    @Override
    public void afterCall() {
        this.getSyncMap().sync();
    }

    public static class SyncEntityRpcTarget
    extends SyncRpcTarget {
        public SyncEntityRpcTarget() {
            super(new EntityRpcTarget());
        }

        public <P extends Entity & IRpcTargetProvider> SyncEntityRpcTarget(P provider, ISyncableObject object) {
            super((ISyncMapProvider)provider, object);
        }
    }

    public static class SyncTileEntityRpcTarget
    extends SyncRpcTarget {
        public SyncTileEntityRpcTarget() {
            super(new TileEntityRpcTarget());
        }

        public <P extends TileEntity & IRpcTargetProvider> SyncTileEntityRpcTarget(P provider, ISyncableObject object) {
            super((ISyncMapProvider)provider, object);
        }
    }
}

