/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import java.util.List;
import openmods.calc.IExecutable;
import openmods.calc.SymbolCall;
import openmods.calc.Value;
import openmods.calc.parsing.ICompilerState;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.SameStateSymbolTransition;
import openmods.calc.parsing.SymbolCallNode;
import openmods.calc.types.multi.Code;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypedValue;

public class LazyArgsSymbolTransition
extends SameStateSymbolTransition<TypedValue> {
    private final TypeDomain domain;
    private final String symbolName;

    public LazyArgsSymbolTransition(ICompilerState<TypedValue> parentState, TypeDomain domain, String symbolName) {
        super(parentState);
        this.domain = domain;
        this.symbolName = symbolName;
    }

    @Override
    public IExprNode<TypedValue> createRootNode(List<IExprNode<TypedValue>> children) {
        return new LazyArgsSymbolNode(children);
    }

    private class LazyArgsSymbolNode
    extends SymbolCallNode<TypedValue> {
        public LazyArgsSymbolNode(List<IExprNode<TypedValue>> args) {
            super(LazyArgsSymbolTransition.this.symbolName, args);
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            int count = 0;
            for (IExprNode<TypedValue> iExprNode : this.getChildren()) {
                output.add(Value.create(Code.flattenAndWrap(LazyArgsSymbolTransition.this.domain, iExprNode)));
                ++count;
            }
            output.add(new SymbolCall(LazyArgsSymbolTransition.this.symbolName, count, 1));
        }
    }
}

