/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.logic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import openmods.gui.logic.IValueUpdateAction;

public class ValueUpdateDispatcher {
    private Multimap<Object, IValueUpdateAction> actions = HashMultimap.create();

    public void addAction(IValueUpdateAction listener) {
        for (Object trigger : listener.getTriggers()) {
            this.actions.put(trigger, (Object)listener);
        }
    }

    public void trigger(Iterable<?> triggers) {
        Set actionsToTrigger = Sets.newIdentityHashSet();
        for (Object trigger : triggers) {
            actionsToTrigger.addAll(this.actions.get(trigger));
        }
        for (IValueUpdateAction action : actionsToTrigger) {
            action.execute();
        }
    }

    public void triggerAll() {
        Set uniques = Sets.newIdentityHashSet();
        uniques.addAll(this.actions.values());
        for (IValueUpdateAction action : uniques) {
            action.execute();
        }
    }
}

