/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import openmods.utils.ITester;

public class ObjectTester<T>
implements ITester<T> {
    private List<ITester<T>> testers = Lists.newArrayList();

    public static <T> ITester<T> createClassTester(Class<? extends T> cls) {
        return new ClassTester<T>(cls);
    }

    public static <T> ObjectTester<T> create() {
        return new ObjectTester<T>();
    }

    public ObjectTester<T> addTester(ITester<T> tester) {
        this.testers.add(tester);
        return this;
    }

    @Override
    public ITester.Result test(T o) {
        for (ITester<T> tester : this.testers) {
            ITester.Result r = tester.test(o);
            if (r == ITester.Result.CONTINUE) continue;
            return r;
        }
        return ITester.Result.CONTINUE;
    }

    public boolean check(T o) {
        return this.test(o) == ITester.Result.ACCEPT;
    }

    public static class ClassNameTester<T>
    implements ITester<T> {
        private final Set<String> names = Sets.newHashSet();
        private final ITester.Result onMatch;

        public ClassNameTester(ITester.Result onMatch) {
            this.onMatch = onMatch;
        }

        public ClassNameTester() {
            this(ITester.Result.ACCEPT);
        }

        public ClassNameTester<T> addClasses(String ... names) {
            for (String name : names) {
                this.names.add(name);
            }
            return this;
        }

        public ClassNameTester<T> addClasses(Class<? extends T> ... classes) {
            for (Class<T> clazz : classes) {
                this.names.add(clazz.getName());
            }
            return this;
        }

        @Override
        public ITester.Result test(T o) {
            return this.names.contains(o.getClass().getName()) ? this.onMatch : ITester.Result.CONTINUE;
        }
    }

    public static class ClassTester<T>
    implements ITester<T> {
        private final Class<? extends T> cls;
        private final ITester.Result onMatch;

        public ClassTester(Class<? extends T> cls, ITester.Result onMatch) {
            this.cls = cls;
            this.onMatch = onMatch;
        }

        public ClassTester(Class<? extends T> cls) {
            this(cls, ITester.Result.ACCEPT);
        }

        @Override
        public ITester.Result test(T o) {
            return this.cls.isAssignableFrom(o.getClass()) ? this.onMatch : ITester.Result.CONTINUE;
        }
    }
}

