/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import openmods.gui.component.GuiComponentResizableComposite;
import openmods.gui.misc.BoxRenderer;
import openmods.gui.misc.ISlotBackgroundRenderer;
import org.lwjgl.opengl.GL11;

public class GuiComponentPanel
extends GuiComponentResizableComposite {
    private static final BoxRenderer BOX_RENDERER = new BoxRenderer(0, 5);
    public static final ISlotBackgroundRenderer normalSlot = new ISlotBackgroundRenderer(){

        @Override
        public void render(Gui gui, Slot slot) {
            gui.func_73729_b(slot.field_75223_e - 1, slot.field_75221_f - 1, 0, 20, 18, 18);
        }
    };
    public static final ISlotBackgroundRenderer bigSlot = new ISlotBackgroundRenderer(){

        @Override
        public void render(Gui gui, Slot slot) {
            gui.func_73729_b(slot.field_75223_e - 5, slot.field_75221_f - 5, 29, 20, 26, 26);
        }
    };
    public static final ISlotBackgroundRenderer noRenderSlot = new ISlotBackgroundRenderer(){

        @Override
        public void render(Gui gui, Slot slot) {
        }
    };
    private final Map<Integer, ISlotBackgroundRenderer> slotRenderers = Maps.newHashMap();
    private final Container container;

    public static ISlotBackgroundRenderer coloredSlot(final int color) {
        return new ISlotBackgroundRenderer(){

            @Override
            public void render(Gui gui, Slot slot) {
                GL11.glColor3ub((byte)((byte)(color >> 16)), (byte)((byte)(color >> 8)), (byte)((byte)(color >> 0)));
                gui.func_73729_b(slot.field_75223_e - 1, slot.field_75221_f - 1, 0, 20, 18, 18);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        };
    }

    public GuiComponentPanel(int x, int y, int width, int height, Container container) {
        super(x, y, width, height);
        this.container = container;
    }

    public void setSlotRenderer(int slotId, ISlotBackgroundRenderer renderer) {
        this.slotRenderers.put(slotId, renderer);
    }

    @Override
    protected void renderComponentBackground(Minecraft minecraft, int x, int y, int mouseX, int mouseY) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GuiComponentPanel.bindComponentsSheet();
        BOX_RENDERER.render(this, this.x + x, this.y + y, this.width, this.height, -1);
    }

    @Override
    protected void renderComponentForeground(Minecraft minecraft, int x, int y, int mouseX, int mouseY) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GuiComponentPanel.bindComponentsSheet();
        if (this.container != null) {
            for (Slot slot : this.container.field_75151_b) {
                ((ISlotBackgroundRenderer)Objects.firstNonNull((Object)this.slotRenderers.get(slot.field_75222_d), (Object)normalSlot)).render(this, slot);
            }
        }
    }
}

