/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import openmods.calc.Environment;
import openmods.calc.FixedCallable;
import openmods.calc.Frame;
import openmods.calc.FrameFactory;
import openmods.calc.IExecutable;
import openmods.calc.SymbolCall;
import openmods.calc.SymbolMap;
import openmods.calc.Value;
import openmods.calc.parsing.ICompilerState;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.ISymbolCallStateTransition;
import openmods.calc.parsing.SameStateSymbolTransition;
import openmods.calc.parsing.SymbolCallNode;
import openmods.calc.types.multi.CallableValue;
import openmods.calc.types.multi.Code;
import openmods.calc.types.multi.MetaObjectUtils;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypedValue;
import openmods.utils.OptionalInt;
import openmods.utils.Stack;

public class PromiseExpressionFactory {
    private final TypeDomain domain;

    public PromiseExpressionFactory(TypeDomain domain) {
        this.domain = domain;
    }

    public ISymbolCallStateTransition<TypedValue> createStateTransition(ICompilerState<TypedValue> compilerState) {
        return new DelayStateTransition(compilerState);
    }

    public void registerSymbols(Environment<TypedValue> env) {
        env.setGlobalSymbol("delay", (TypedValue)((Object)new DelaySymbol()));
        env.setGlobalSymbol("force", (TypedValue)((Object)new ForceSymbol()));
    }

    private static class ForceSymbol
    extends FixedCallable<TypedValue> {
        public ForceSymbol() {
            super(1, 1);
        }

        @Override
        public void call(Frame<TypedValue> frame) {
            Stack<TypedValue> stack = frame.stack();
            TypedValue arg = stack.pop();
            MetaObjectUtils.call(frame, arg, OptionalInt.ZERO, OptionalInt.ONE);
        }
    }

    private static class DelaySymbol
    extends FixedCallable<TypedValue> {
        public DelaySymbol() {
            super(1, 1);
        }

        @Override
        public void call(Frame<TypedValue> frame) {
            Stack<TypedValue> stack = frame.stack();
            TypedValue arg = stack.pop();
            Code code = arg.as(Code.class, "'code' argument");
            stack.push(CallableValue.wrap(arg.domain, new DelayCallable(frame.symbols(), code)));
        }
    }

    private static class DelayCallable
    extends FixedCallable<TypedValue> {
        private Optional<TypedValue> value = Optional.absent();
        private final SymbolMap<TypedValue> scope;
        private final Code code;

        public DelayCallable(SymbolMap<TypedValue> scope, Code code) {
            super(0, 1);
            this.scope = scope;
            this.code = code;
        }

        @Override
        public void call(Frame<TypedValue> frame) {
            if (!this.value.isPresent()) {
                Frame<TypedValue> executionFrame = FrameFactory.newLocalFrame(this.scope);
                this.code.execute(executionFrame);
                TypedValue result = executionFrame.stack().popAndExpectEmptyStack();
                this.value = Optional.of((Object)result);
            }
            frame.stack().push((TypedValue)this.value.get());
        }
    }

    private class DelayStateTransition
    extends SameStateSymbolTransition<TypedValue> {
        public DelayStateTransition(ICompilerState<TypedValue> compilerState) {
            super(compilerState);
        }

        @Override
        public IExprNode<TypedValue> createRootNode(List<IExprNode<TypedValue>> children) {
            return new DelayExprNode(children);
        }
    }

    private class DelayExprNode
    extends SymbolCallNode<TypedValue> {
        public DelayExprNode(List<IExprNode<TypedValue>> children) {
            super("delay", children);
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            ImmutableList args = ImmutableList.copyOf(this.getChildren());
            Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (Object)"'delay' expects single argument");
            output.add(Value.create(Code.flattenAndWrap(PromiseExpressionFactory.this.domain, (IExprNode)args.get(0))));
            output.add(new SymbolCall(this.symbol, 1, 1));
        }
    }
}

