/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import java.math.BigInteger;
import openmods.calc.parsing.IValueParser;
import openmods.calc.parsing.PositionalNotationParser;
import openmods.calc.parsing.Token;
import openmods.calc.parsing.TokenType;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypedValue;
import org.apache.commons.lang3.tuple.Pair;

public class TypedValueParser
implements IValueParser<TypedValue> {
    public static final PositionalNotationParser<BigInteger, Double> NUMBER_PARSER = new PositionalNotationParser<BigInteger, Double>(){

        @Override
        public PositionalNotationParser.Accumulator<BigInteger> createIntegerAccumulator(int radix) {
            final BigInteger bigRadix = BigInteger.valueOf(radix);
            return new PositionalNotationParser.Accumulator<BigInteger>(){
                private BigInteger value = BigInteger.ZERO;

                @Override
                public void add(int digit) {
                    this.value = this.value.multiply(bigRadix).add(BigInteger.valueOf(digit));
                }

                @Override
                public BigInteger get() {
                    return this.value;
                }
            };
        }

        @Override
        protected PositionalNotationParser.Accumulator<Double> createFractionalAccumulator(int radix) {
            final double inverseRadix = 1.0 / (double)radix;
            return new PositionalNotationParser.Accumulator<Double>(){
                private double value = 0.0;
                private double weight = inverseRadix;

                @Override
                public void add(int digit) {
                    this.value += (double)digit * this.weight;
                    this.weight *= inverseRadix;
                }

                @Override
                public Double get() {
                    return this.value;
                }
            };
        }
    };
    private final TypeDomain domain;

    public static TypedValue mergeNumberParts(TypeDomain domain, Pair<BigInteger, Double> result) {
        BigInteger intPart = (BigInteger)result.getLeft();
        Double fractionPart = (Double)result.getRight();
        if (fractionPart == null) {
            return domain.create(BigInteger.class, intPart);
        }
        double total = intPart.doubleValue() + fractionPart;
        return domain.create(Double.class, total);
    }

    public TypedValueParser(TypeDomain domain) {
        this.domain = domain;
    }

    @Override
    public TypedValue parseToken(Token token) {
        if (token.type == TokenType.STRING) {
            return this.domain.create(String.class, token.value);
        }
        Pair<BigInteger, Double> result = NUMBER_PARSER.parseToken(token);
        return TypedValueParser.mergeNumberParts(this.domain, result);
    }
}

