/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface;

import com.bymarcin.openglasses.network.NetworkRegistry;
import com.bymarcin.openglasses.network.packet.TerminalStatusPacket;
import com.bymarcin.openglasses.network.packet.WidgetUpdatePacket;
import com.bymarcin.openglasses.tileentity.OpenGlassesTerminalTileEntity;
import com.bymarcin.openglasses.utils.Location;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class ServerSurface {
    public static ServerSurface instance = new ServerSurface();
    HashMap<EntityPlayer, Location> players = new HashMap();

    public void subscribePlayer(String playerUUID, Location UUID) {
        OpenGlassesTerminalTileEntity terminal;
        EntityPlayerMP player = this.checkUUID(playerUUID);
        if (player != null && (terminal = UUID.getTerminal()) != null && terminal.getTerminalUUID().equals(UUID)) {
            this.players.put((EntityPlayer)player, UUID);
            this.sendSync((EntityPlayer)player, UUID, terminal);
            this.sendPowerInfo(UUID, terminal.isPowered() ? TerminalStatusPacket.TerminalStatus.HavePower : TerminalStatusPacket.TerminalStatus.NoPower);
            terminal.onGlassesPutOn(player.getDisplayName());
        }
    }

    public void unsubscribePlayer(String playerUUID) {
        OpenGlassesTerminalTileEntity terminal;
        EntityPlayerMP p = this.checkUUID(playerUUID);
        Location l = this.players.remove(p);
        if (l != null && (terminal = l.getTerminal()) != null) {
            terminal.onGlassesPutOff(p.getDisplayName());
        }
    }

    public String[] getActivePlayers(Location l) {
        LinkedList<String> players = new LinkedList<String>();
        for (Map.Entry<EntityPlayer, Location> p : this.players.entrySet()) {
            if (!p.getValue().equals(l)) continue;
            players.add(p.getKey().func_146103_bH().getName());
        }
        return players.toArray(new String[0]);
    }

    public void sendSync(EntityPlayer p, Location coords, OpenGlassesTerminalTileEntity t) {
        WidgetUpdatePacket packet = new WidgetUpdatePacket(t.widgetList);
        NetworkRegistry.packetHandler.sendTo((IMessage)packet, (EntityPlayerMP)p);
    }

    public void sendPowerInfo(Location loc, TerminalStatusPacket.TerminalStatus status) {
        TerminalStatusPacket packet = new TerminalStatusPacket(status);
        for (Map.Entry<EntityPlayer, Location> e : this.players.entrySet()) {
            if (!e.getValue().equals(loc)) continue;
            NetworkRegistry.packetHandler.sendTo((IMessage)packet, (EntityPlayerMP)e.getKey());
        }
    }

    public void sendToUUID(WidgetUpdatePacket packet, Location UUID) {
        for (Map.Entry<EntityPlayer, Location> e : this.players.entrySet()) {
            if (!e.getValue().equals(UUID)) continue;
            NetworkRegistry.packetHandler.sendTo((IMessage)packet, (EntityPlayerMP)e.getKey());
        }
    }

    private EntityPlayerMP checkUUID(String uuid) {
        for (Object p : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!((EntityPlayerMP)p).func_146103_bH().getName().equals(uuid)) continue;
            return (EntityPlayerMP)p;
        }
        return null;
    }
}

