/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.tileentity;

import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.lua.LuaReference;
import com.bymarcin.openglasses.network.packet.TerminalStatusPacket;
import com.bymarcin.openglasses.network.packet.WidgetUpdatePacket;
import com.bymarcin.openglasses.surface.ServerSurface;
import com.bymarcin.openglasses.surface.Widget;
import com.bymarcin.openglasses.surface.WidgetType;
import com.bymarcin.openglasses.surface.widgets.component.face.Dot;
import com.bymarcin.openglasses.surface.widgets.component.face.ItemIcon;
import com.bymarcin.openglasses.surface.widgets.component.face.Quad;
import com.bymarcin.openglasses.surface.widgets.component.face.SquareWidget;
import com.bymarcin.openglasses.surface.widgets.component.face.Text;
import com.bymarcin.openglasses.surface.widgets.component.face.TriangleWidget;
import com.bymarcin.openglasses.surface.widgets.component.world.Cube3D;
import com.bymarcin.openglasses.surface.widgets.component.world.Dot3D;
import com.bymarcin.openglasses.surface.widgets.component.world.FloatingText;
import com.bymarcin.openglasses.surface.widgets.component.world.Line3D;
import com.bymarcin.openglasses.surface.widgets.component.world.Quad3D;
import com.bymarcin.openglasses.surface.widgets.component.world.Triangle3D;
import com.bymarcin.openglasses.utils.Location;
import cpw.mods.fml.common.Optional;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import li.cil.oc.api.API;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Connector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.TileEntityEnvironment;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")
public class OpenGlassesTerminalTileEntity
extends TileEntityEnvironment {
    public HashMap<Integer, Widget> widgetList = new HashMap();
    int currID = 0;
    Location loc;
    boolean isPowered;

    public OpenGlassesTerminalTileEntity() {
        this.node = API.network.newNode((Environment)this, Visibility.Network).withComponent(this.getComponentName()).withConnector((double)OpenGlasses.energyBuffer).create();
    }

    public String getComponentName() {
        return "glasses";
    }

    public Location getTerminalUUID() {
        if (this.loc != null) {
            return this.loc;
        }
        this.loc = new Location(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g, UUID.randomUUID().getMostSignificantBits());
        return this.loc;
    }

    public void onGlassesPutOn(String user) {
        if (this.node != null) {
            this.node.sendToReachable("computer.signal", new Object[]{"glasses_on", user});
        }
    }

    public void onGlassesPutOff(String user) {
        if (this.node != null) {
            this.node.sendToReachable("computer.signal", new Object[]{"glasses_off", user});
        }
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getBindPlayers(Context context, Arguments args) {
        return ServerSurface.instance.getActivePlayers(this.getTerminalUUID());
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getObjectCount(Context context, Arguments args) {
        return new Object[]{this.widgetList.size()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] removeObject(Context context, Arguments args) {
        int id = args.checkInteger(0);
        return new Object[]{this.removeWidget(id)};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] removeAll(Context context, Arguments args) {
        this.currID = 0;
        this.widgetList.clear();
        ServerSurface.instance.sendToUUID(new WidgetUpdatePacket(), this.getTerminalUUID());
        return new Object[0];
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] newUniqueKey(Context context, Arguments args) {
        String[] players;
        for (String p : players = ServerSurface.instance.getActivePlayers(this.loc)) {
            ServerSurface.instance.sendToUUID(new WidgetUpdatePacket(), this.loc);
            ServerSurface.instance.unsubscribePlayer(p);
        }
        this.loc.uniqueKey = UUID.randomUUID().getMostSignificantBits();
        return new Object[]{this.loc.uniqueKey};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] addRect(Context context, Arguments args) {
        SquareWidget w = new SquareWidget();
        return this.addWidget(w);
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] addDot(Context context, Arguments args) {
        Dot w = new Dot();
        return this.addWidget(w);
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] addItem(Context context, Arguments args) {
        ItemIcon w = new ItemIcon();
        return this.addWidget(w);
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] addCube3D(Context context, Arguments args) {
        Cube3D w = new Cube3D();
        return this.addWidget(w);
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] addFloatingText(Context context, Arguments args) {
        FloatingText w = new FloatingText();
        return this.addWidget(w);
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] addTriangle(Context context, Arguments args) {
        TriangleWidget w = new TriangleWidget();
        return this.addWidget(w);
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] addDot3D(Context context, Arguments args) {
        Dot3D w = new Dot3D();
        return this.addWidget(w);
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] addTextLabel(Context context, Arguments args) {
        Text w = new Text();
        return this.addWidget(w);
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] addLine3D(Context context, Arguments args) {
        Line3D w = new Line3D();
        return this.addWidget(w);
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] addTriangle3D(Context context, Arguments args) {
        Triangle3D w = new Triangle3D();
        return this.addWidget(w);
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] addQuad3D(Context context, Arguments args) {
        Quad3D w = new Quad3D();
        return this.addWidget(w);
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] addQuad(Context context, Arguments args) {
        Quad w = new Quad();
        return this.addWidget(w);
    }

    public boolean removeWidget(int id) {
        if (this.widgetList.containsKey(id) && this.widgetList.remove(id) != null) {
            ServerSurface.instance.sendToUUID(new WidgetUpdatePacket(id), this.getTerminalUUID());
            return true;
        }
        return false;
    }

    public Object[] addWidget(Widget w) {
        this.widgetList.put(this.currID, w);
        ServerSurface.instance.sendToUUID(new WidgetUpdatePacket(this.currID, w), this.getTerminalUUID());
        int t = this.currID++;
        return w.getLuaObject(new LuaReference(t, this.getTerminalUUID()));
    }

    public void updateWidget(int id) {
        Widget w = this.widgetList.get(id);
        if (w != null) {
            ServerSurface.instance.sendToUUID(new WidgetUpdatePacket(id, w), this.getTerminalUUID());
        }
    }

    public Widget getWidget(int id) {
        return this.widgetList.get(id);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("currID", this.currID);
        NBTTagCompound tag = new NBTTagCompound();
        int size = this.widgetList.size();
        nbt.func_74768_a("listSize", size);
        int i = 0;
        for (Map.Entry<Integer, Widget> e : this.widgetList.entrySet()) {
            NBTTagCompound widget = new NBTTagCompound();
            widget.func_74778_a("widgetType", e.getValue().getType().name());
            widget.func_74768_a("ID", e.getKey().intValue());
            NBTTagCompound wNBT = new NBTTagCompound();
            e.getValue().writeToNBT(wNBT);
            widget.func_74782_a("widget", (NBTBase)wNBT);
            tag.func_74782_a(String.valueOf(i), (NBTBase)widget);
            ++i;
        }
        nbt.func_74782_a("widgetList", (NBTBase)tag);
        NBTTagCompound tagLoc = new NBTTagCompound();
        if (this.loc != null) {
            this.loc.writeToNBT(tagLoc);
            nbt.func_74782_a("uniqueKey", (NBTBase)tagLoc);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.widgetList.clear();
        if (nbt.func_74764_b("currID")) {
            this.currID = nbt.func_74762_e("currID");
        }
        if (nbt.func_74764_b("widgetList") && nbt.func_74764_b("listSize")) {
            NBTTagCompound list = (NBTTagCompound)nbt.func_74781_a("widgetList");
            int size = nbt.func_74762_e("listSize");
            for (int i = 0; i < size; ++i) {
                NBTTagCompound wiget;
                if (!list.func_74764_b(String.valueOf(i)) || !(wiget = (NBTTagCompound)list.func_74781_a(String.valueOf(i))).func_74764_b("widgetType") || !wiget.func_74764_b("widget") || !wiget.func_74764_b("ID")) continue;
                WidgetType type = WidgetType.valueOf(wiget.func_74779_i("widgetType"));
                Widget w = type.getNewInstance();
                w.readFromNBT((NBTTagCompound)wiget.func_74781_a("widget"));
                this.widgetList.put(wiget.func_74762_e("ID"), w);
            }
        }
        if (nbt.func_74764_b("uniqueKey")) {
            this.loc = new Location().readFromNBT((NBTTagCompound)nbt.func_74781_a("uniqueKey"));
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean lastStatus = this.isPowered;
        this.isPowered = this.node() != null && ((Connector)this.node()).tryChangeBuffer((double)((float)(-this.widgetList.size()) / 10.0f) * OpenGlasses.energyMultiplier);
        if (lastStatus != this.isPowered) {
            ServerSurface.instance.sendPowerInfo(this.getTerminalUUID(), this.isPowered ? TerminalStatusPacket.TerminalStatus.HavePower : TerminalStatusPacket.TerminalStatus.NoPower);
        }
    }

    public boolean isPowered() {
        return this.isPowered;
    }
}

