/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.utils;

import com.bymarcin.openglasses.tileentity.OpenGlassesTerminalTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class Location {
    public int x;
    public int y;
    public int z;
    public int dimID;
    public long uniqueKey;

    public Location(int x, int y, int z, int dimID, long uniqueKey) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimID = dimID;
        this.uniqueKey = uniqueKey;
    }

    public Location() {
    }

    public boolean equals(Object arg0) {
        return arg0 instanceof Location && ((Location)arg0).x == this.x && ((Location)arg0).y == this.y && ((Location)arg0).z == this.z && ((Location)arg0).dimID == this.dimID && ((Location)arg0).uniqueKey == this.uniqueKey;
    }

    public String toString() {
        return "X:" + this.x + " Y:" + this.y + " Z:" + this.z + " DIM:" + this.dimID + "\n Key:" + this.uniqueKey;
    }

    public String[] toArrayString() {
        return new String[]{"X:" + this.x + " Y:" + this.y + " Z:" + this.z, "DIM:" + this.dimID, "Key:" + this.uniqueKey};
    }

    public TileEntity getTileEntity() {
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(this.dimID);
        if (world == null) {
            return null;
        }
        return world.func_147438_o(this.x, this.y, this.z);
    }

    public OpenGlassesTerminalTileEntity getTerminal() {
        TileEntity te = this.getTileEntity();
        if (te instanceof OpenGlassesTerminalTileEntity) {
            return (OpenGlassesTerminalTileEntity)te;
        }
        return null;
    }

    public Location readFromNBT(NBTTagCompound nbt) {
        this.x = nbt.func_74762_e("locX");
        this.y = nbt.func_74762_e("locY");
        this.z = nbt.func_74762_e("locZ");
        this.dimID = nbt.func_74762_e("locDim");
        this.uniqueKey = nbt.func_74763_f("uniqueKey");
        return this;
    }

    public Location writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("locX", this.x);
        nbt.func_74768_a("locY", this.y);
        nbt.func_74768_a("locZ", this.z);
        nbt.func_74768_a("locDIM", this.dimID);
        nbt.func_74772_a("uniqueKey", this.uniqueKey);
        return this;
    }
}

