/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface.widgets.component.face;

import com.bymarcin.openglasses.surface.IRenderableWidget;
import com.bymarcin.openglasses.surface.RenderType;
import com.bymarcin.openglasses.surface.WidgetType;
import com.bymarcin.openglasses.surface.widgets.component.face.Dot;
import com.bymarcin.openglasses.surface.widgets.core.attribute.ITextable;
import com.bymarcin.openglasses.utils.OGUtils;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class Text
extends Dot
implements ITextable {
    String text = "";

    @Override
    public void writeData(ByteBuf buff) {
        super.writeData(buff);
        ByteBufUtils.writeUTF8String((ByteBuf)buff, (String)this.text);
    }

    @Override
    public void readData(ByteBuf buff) {
        super.readData(buff);
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buff);
    }

    @Override
    public WidgetType getType() {
        return WidgetType.TEXT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderText();
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    class RenderText
    implements IRenderableWidget {
        int color;
        FontRenderer fontRender;

        RenderText() {
            this.color = OGUtils.getIntFromColor(Text.this.r, Text.this.g, Text.this.b, Text.this.alpha);
            this.fontRender = Minecraft.func_71410_x().field_71466_p;
        }

        @Override
        public void render(EntityPlayer player, double playerX, double playerY, double playerZ) {
            GL11.glPushMatrix();
            GL11.glScaled((double)Text.this.size, (double)Text.this.size, (double)0.0);
            this.fontRender.func_78276_b(Text.this.text, (int)Text.this.x, (int)Text.this.y, this.color);
            GL11.glPopMatrix();
        }

        @Override
        public RenderType getRenderType() {
            return RenderType.GameOverlayLocated;
        }

        @Override
        public boolean shouldWidgetBeRendered() {
            return Text.this.isVisible();
        }
    }
}

