/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface.widgets.core;

import com.bymarcin.openglasses.lua.LuaFunction;
import com.bymarcin.openglasses.lua.LuaReference;
import com.bymarcin.openglasses.surface.widgets.core.attribute.I2DVertex;
import com.bymarcin.openglasses.surface.widgets.core.attribute.I3DPositionable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.I3DVertex;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IAlpha;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IAttribute;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IColorizable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.ILookable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IPositionable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IResizable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IScalable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.ITextable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IThroughVisibility;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IViewDistance;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.GetAlpha;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.GetColor;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.GetID;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.GetLookingAt;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.GetPosition;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.GetPosition3D;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.GetScale;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.GetSize;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.GetText;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.GetVertexCount;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.GetViewDistance;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.IsVisible;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.IsVisibleThroughObjects;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.SetAlpha;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.SetColor;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.SetLookingAt;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.SetPosition;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.SetPosition3D;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.SetScale;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.SetSize;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.SetText;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.SetVertex;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.SetViewDistance;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.SetVisible;
import com.bymarcin.openglasses.surface.widgets.core.luafunction.SetVisibleThroughObjects;
import java.util.HashMap;
import java.util.LinkedList;

public class AttributeRegistry {
    static HashMap<Class<? extends IAttribute>, LinkedList<Class<? extends LuaFunction>>> attributes = new HashMap();

    public static void addAtribute(Class<? extends IAttribute> atribute, Class<? extends LuaFunction> luaFunction) {
        LinkedList<Class<? extends LuaFunction>> a = attributes.get(atribute);
        if (a != null) {
            a.push(luaFunction);
        } else {
            LinkedList<Class<? extends LuaFunction>> f = new LinkedList<Class<? extends LuaFunction>>();
            f.add(luaFunction);
            attributes.put(atribute, f);
        }
    }

    public static HashMap<String, Object> getFunctions(Class<? extends IAttribute> atribute, LuaReference ref) {
        LinkedList<Class<? extends LuaFunction>> functions = attributes.get(atribute);
        HashMap<String, Object> luaObject = new HashMap<String, Object>();
        for (Class clazz : functions) {
            try {
                LuaFunction lf = (LuaFunction)clazz.newInstance();
                lf.setRef(ref);
                luaObject.put(lf.getName(), lf);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return luaObject;
    }

    static {
        AttributeRegistry.addAtribute(IAttribute.class, GetID.class);
        AttributeRegistry.addAtribute(IAttribute.class, IsVisible.class);
        AttributeRegistry.addAtribute(IAttribute.class, SetVisible.class);
        AttributeRegistry.addAtribute(IAlpha.class, GetAlpha.class);
        AttributeRegistry.addAtribute(IAlpha.class, SetAlpha.class);
        AttributeRegistry.addAtribute(IColorizable.class, SetColor.class);
        AttributeRegistry.addAtribute(IColorizable.class, GetColor.class);
        AttributeRegistry.addAtribute(IPositionable.class, SetPosition.class);
        AttributeRegistry.addAtribute(IPositionable.class, GetPosition.class);
        AttributeRegistry.addAtribute(IResizable.class, GetSize.class);
        AttributeRegistry.addAtribute(IResizable.class, SetSize.class);
        AttributeRegistry.addAtribute(I3DPositionable.class, SetPosition3D.class);
        AttributeRegistry.addAtribute(I3DPositionable.class, GetPosition3D.class);
        AttributeRegistry.addAtribute(ITextable.class, SetText.class);
        AttributeRegistry.addAtribute(ITextable.class, GetText.class);
        AttributeRegistry.addAtribute(IScalable.class, SetScale.class);
        AttributeRegistry.addAtribute(IScalable.class, GetScale.class);
        AttributeRegistry.addAtribute(IThroughVisibility.class, SetVisibleThroughObjects.class);
        AttributeRegistry.addAtribute(IThroughVisibility.class, IsVisibleThroughObjects.class);
        AttributeRegistry.addAtribute(I3DVertex.class, SetVertex.class);
        AttributeRegistry.addAtribute(I3DVertex.class, GetVertexCount.class);
        AttributeRegistry.addAtribute(I2DVertex.class, SetVertex.class);
        AttributeRegistry.addAtribute(I2DVertex.class, GetVertexCount.class);
        AttributeRegistry.addAtribute(IViewDistance.class, SetViewDistance.class);
        AttributeRegistry.addAtribute(IViewDistance.class, GetViewDistance.class);
        AttributeRegistry.addAtribute(ILookable.class, SetLookingAt.class);
        AttributeRegistry.addAtribute(ILookable.class, GetLookingAt.class);
    }
}

