/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface.widgets.component.world;

import com.bymarcin.openglasses.surface.ClientSurface;
import com.bymarcin.openglasses.surface.IRenderableWidget;
import com.bymarcin.openglasses.surface.RenderType;
import com.bymarcin.openglasses.surface.Widget;
import com.bymarcin.openglasses.surface.WidgetType;
import com.bymarcin.openglasses.surface.widgets.core.attribute.I3DPositionable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IAlpha;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IColorizable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.ILookable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IScalable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IThroughVisibility;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IViewDistance;
import com.bymarcin.openglasses.utils.OGUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.opengl.GL11;

public class Cube3D
extends Widget
implements I3DPositionable,
IAlpha,
IThroughVisibility,
IColorizable,
IViewDistance,
ILookable,
IScalable {
    float x;
    float y;
    float z;
    float scale = 1.0f;
    boolean isThroughVisibility;
    boolean isLookingAtEnable;
    int lookAtX;
    int lookAtY;
    int lookAtZ;
    float r;
    float g;
    float b;
    int distance = 100;
    float alpha = 0.5f;

    @Override
    public void writeData(ByteBuf buff) {
        buff.writeFloat(this.x);
        buff.writeFloat(this.y);
        buff.writeFloat(this.z);
        buff.writeFloat(this.alpha);
        buff.writeFloat(this.r);
        buff.writeFloat(this.g);
        buff.writeFloat(this.b);
        buff.writeBoolean(this.isThroughVisibility);
        buff.writeInt(this.distance);
        buff.writeInt(this.lookAtX);
        buff.writeInt(this.lookAtY);
        buff.writeInt(this.lookAtZ);
        buff.writeBoolean(this.isLookingAtEnable);
        buff.writeFloat(this.scale);
    }

    @Override
    public void readData(ByteBuf buff) {
        this.x = buff.readFloat();
        this.y = buff.readFloat();
        this.z = buff.readFloat();
        this.alpha = buff.readFloat();
        this.r = buff.readFloat();
        this.g = buff.readFloat();
        this.b = buff.readFloat();
        this.isThroughVisibility = buff.readBoolean();
        this.distance = buff.readInt();
        this.lookAtX = buff.readInt();
        this.lookAtY = buff.readInt();
        this.lookAtZ = buff.readInt();
        this.isLookingAtEnable = buff.readBoolean();
        this.scale = buff.readFloat();
    }

    @Override
    public WidgetType getType() {
        return WidgetType.CUBE3D;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderCube3D();
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        this.alpha = (float)alpha;
    }

    @Override
    public double getPosX() {
        return this.x;
    }

    @Override
    public double getPosY() {
        return this.y;
    }

    @Override
    public double getPosZ() {
        return this.z;
    }

    @Override
    public void setPos(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    @Override
    public void setColor(double d, double e, double f) {
        this.r = (float)d;
        this.g = (float)e;
        this.b = (float)f;
    }

    @Override
    public float getColorR() {
        return this.r;
    }

    @Override
    public float getColorG() {
        return this.g;
    }

    @Override
    public float getColorB() {
        return this.b;
    }

    @Override
    public boolean isVisibleThroughObjects() {
        return this.isThroughVisibility;
    }

    @Override
    public void setVisibleThroughObjects(boolean visible) {
        this.isThroughVisibility = visible;
    }

    @Override
    public int getDistanceView() {
        return this.distance;
    }

    @Override
    public void setDistanceView(int distance) {
        this.distance = distance;
    }

    @Override
    public void setLookingAt(int x, int y, int z) {
        this.lookAtX = x;
        this.lookAtY = y;
        this.lookAtZ = z;
    }

    @Override
    public boolean isLookingAtEnable() {
        return this.isLookingAtEnable;
    }

    @Override
    public void setLookingAtEnable(boolean enable) {
        this.isLookingAtEnable = enable;
    }

    @Override
    public int getLookingAtX() {
        return this.lookAtX;
    }

    @Override
    public int getLookingAtY() {
        return this.lookAtY;
    }

    @Override
    public int getLookingAtZ() {
        return this.lookAtZ;
    }

    @Override
    public void setScale(double scale) {
        this.scale = (float)scale;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @SideOnly(value=Side.CLIENT)
    class RenderCube3D
    implements IRenderableWidget {
        float tr;

        RenderCube3D() {
            this.tr = (1.0f - Cube3D.this.scale) / 2.0f;
        }

        @Override
        public void render(EntityPlayer player, double playerX, double playerY, double playerZ) {
            if (OGUtils.inRange(playerX, playerY, playerZ, Cube3D.this.x, Cube3D.this.y, Cube3D.this.z, Cube3D.this.distance)) {
                MovingObjectPosition pos = ClientSurface.getBlockCoordsLookingAt(player);
                if (Cube3D.this.isLookingAtEnable && (pos == null || pos.field_72311_b != Cube3D.this.lookAtX || pos.field_72312_c != Cube3D.this.lookAtY || pos.field_72309_d != Cube3D.this.lookAtZ)) {
                    return;
                }
                this.drawQuad(Cube3D.this.x, Cube3D.this.y, Cube3D.this.z, Cube3D.this.alpha);
            }
        }

        public void drawQuad(float posX, float posY, float PosZ, float alpha) {
            GL11.glTranslated((double)posX, (double)posY, (double)PosZ);
            if (Cube3D.this.isThroughVisibility) {
                GL11.glDisable((int)2929);
            } else {
                GL11.glEnable((int)2929);
            }
            GL11.glDisable((int)3553);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.tr, (float)this.tr, (float)this.tr);
            GL11.glScalef((float)Cube3D.this.scale, (float)Cube3D.this.scale, (float)Cube3D.this.scale);
            GL11.glBegin((int)7);
            GL11.glColor4f((float)Cube3D.this.r, (float)Cube3D.this.g, (float)Cube3D.this.b, (float)alpha);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glEnd();
            GL11.glPopMatrix();
            GL11.glEnable((int)3553);
            GL11.glTranslated((double)(-posX), (double)(-posY), (double)(-PosZ));
            GL11.glEnable((int)2929);
        }

        @Override
        public RenderType getRenderType() {
            return RenderType.WorldLocated;
        }

        @Override
        public boolean shouldWidgetBeRendered() {
            return Cube3D.this.isVisible();
        }
    }
}

