/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.event.ClientEventHandler;
import com.bymarcin.openglasses.utils.Location;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class OpenGlassesItem
extends ItemArmor
implements IBauble {
    public OpenGlassesItem() {
        super(ItemArmor.ArmorMaterial.CHAIN, 0, 0);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(OpenGlasses.creativeTab);
        this.func_77655_b("openglasses");
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("openglasses:glasses");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.field_77791_bV;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "openglasses:textures/models/glasses.png";
    }

    public static Location getUUID(ItemStack itemStack) {
        NBTTagCompound tag = OpenGlassesItem.getItemTag(itemStack);
        if (!(tag.func_74764_b("X") && tag.func_74764_b("Y") && tag.func_74764_b("Z") && tag.func_74764_b("uniqueKey"))) {
            return null;
        }
        return new Location(tag.func_74762_e("X"), tag.func_74762_e("Y"), tag.func_74762_e("Z"), tag.func_74762_e("DIM"), tag.func_74763_f("uniqueKey"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(itemStack, player, list, par4);
        Location uuid = OpenGlassesItem.getUUID(itemStack);
        if (uuid != null) {
            list.add("Link to:");
            for (String s : uuid.toArrayString()) {
                list.add(s);
            }
        }
    }

    public static NBTTagCompound getItemTag(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        return stack.field_77990_d;
    }

    public void bindToTerminal(ItemStack glass, Location uuid) {
        NBTTagCompound tag = OpenGlassesItem.getItemTag(glass);
        tag.func_74768_a("X", uuid.x);
        tag.func_74768_a("Y", uuid.y);
        tag.func_74768_a("Z", uuid.z);
        tag.func_74768_a("DIM", uuid.dimID);
        tag.func_74772_a("uniqueKey", uuid.uniqueKey);
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        if (player instanceof EntityPlayer) {
            ClientEventHandler.equiped((EntityPlayer)player, OpenGlassesItem.getUUID(itemstack));
        }
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        if (player instanceof EntityPlayer) {
            ClientEventHandler.unEquiped((EntityPlayer)player);
        }
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

