/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.integration.forestry;

import com.google.common.collect.Sets;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import java.util.HashMap;
import java.util.HashSet;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import li.cil.oc.integration.ManagedTileEntityEnvironment;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DriverBeeHouse
extends DriverSidedTileEntity {
    @Override
    public Class<?> getTileEntityClass() {
        return IBeeHousing.class;
    }

    @Override
    public ManagedEnvironment createEnvironment(World world, int x, int y, int z, ForgeDirection side) {
        return new Environment((IBeeHousing)world.func_147438_o(x, y, z));
    }

    public static final class Environment
    extends ManagedTileEntityEnvironment<IBeeHousing> {
        public Environment(IBeeHousing tileEntity) {
            super(tileEntity, "bee_housing");
        }

        @Callback(doc="function():boolean -- Can the bees breed?")
        public Object[] canBreed(Context context, Arguments args) {
            return new Object[]{((IBeeHousing)this.tileEntity).getBeekeepingLogic().canWork()};
        }

        @Callback(doc="function():table -- Get the drone")
        public Object[] getDrone(Context context, Arguments args) {
            ItemStack drone = ((IBeeHousing)this.tileEntity).getBeeInventory().getDrone();
            if (drone != null) {
                return new Object[]{AlleleManager.alleleRegistry.getIndividual(drone)};
            }
            return null;
        }

        @Callback(doc="function():table -- Get the queen")
        public Object[] getQueen(Context context, Arguments args) {
            ItemStack queen = ((IBeeHousing)this.tileEntity).getBeeInventory().getQueen();
            if (queen != null) {
                return new Object[]{AlleleManager.alleleRegistry.getIndividual(queen)};
            }
            return null;
        }

        @Callback(doc="function():table -- Get the full breeding list thingy.")
        public Object[] getBeeBreedingData(Context context, Arguments args) {
            ISpeciesRoot beeRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
            if (beeRoot == null) {
                return null;
            }
            HashSet result2 = Sets.newHashSet();
            for (IMutation mutation : beeRoot.getMutations(false)) {
                IAlleleSpecies allele2;
                HashMap<String, Object> mutationMap = new HashMap<String, Object>();
                IAlleleSpecies allele1 = mutation.getAllele0();
                if (allele1 != null) {
                    mutationMap.put("allele1", allele1.getName());
                }
                if ((allele2 = mutation.getAllele1()) != null) {
                    mutationMap.put("allele2", allele2.getName());
                }
                mutationMap.put("chance", Float.valueOf(mutation.getBaseChance()));
                mutationMap.put("specialConditions", mutation.getSpecialConditions().toArray());
                IAllele[] template = mutation.getTemplate();
                if (template != null && template.length > 0) {
                    mutationMap.put("result", template[0].getName());
                }
                result2.add(mutationMap);
            }
            return new Object[]{result2};
        }

        @Callback(doc="function():table -- Get all known bees mutations")
        public Object[] listAllSpecies(Context context, Arguments args) {
            ISpeciesRoot beeRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
            if (beeRoot == null) {
                return null;
            }
            HashSet result2 = Sets.newHashSet();
            for (IMutation mutation : beeRoot.getMutations(false)) {
                IAllele allele;
                IAllele[] template = mutation.getTemplate();
                if (template == null || template.length <= 0 || !((allele = template[0]) instanceof IAlleleSpecies)) continue;
                result2.add((IAlleleSpecies)allele);
            }
            return new Object[]{result2};
        }

        @Callback(doc="function(beeName:string):table -- Get the parents for a particular mutation")
        public Object[] getBeeParents(Context context, Arguments args) {
            ISpeciesRoot beeRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
            if (beeRoot == null) {
                return null;
            }
            HashSet result2 = Sets.newHashSet();
            String childType = args.checkString(0).toLowerCase();
            for (IMutation mutation : beeRoot.getMutations(false)) {
                IAllele allele;
                IAllele[] template = mutation.getTemplate();
                if (template == null || template.length < 1 || !((allele = template[0]) instanceof IAlleleSpecies)) continue;
                IAlleleSpecies species = (IAlleleSpecies)allele;
                String uid = species.getUID().toLowerCase();
                String localizedName = species.getName().toLowerCase();
                if (!localizedName.equals(childType) && !uid.equals(childType)) continue;
                result2.add(mutation);
            }
            return new Object[]{result2};
        }
    }
}

