/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.integration.computercraft;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaTask;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import li.cil.oc.OpenComputers;
import li.cil.oc.Settings;
import li.cil.oc.api.FileSystem;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.SidedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.BlacklistedPeripheral;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.integration.computercraft.CallableHelper;
import li.cil.oc.util.Reflection;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class DriverPeripheral
implements SidedBlock {
    private static Set<Class<?>> blacklist;

    private boolean isBlacklisted(Object o) {
        if (o instanceof BlacklistedPeripheral) {
            return ((BlacklistedPeripheral)o).isPeripheralBlacklisted();
        }
        if (blacklist == null) {
            blacklist = new HashSet();
            for (String name : Settings.get().peripheralBlacklist()) {
                Class<?> clazz = Reflection.getClass(name);
                if (clazz == null) continue;
                blacklist.add(clazz);
            }
        }
        for (Class<?> clazz : blacklist) {
            if (!clazz.isInstance(o)) continue;
            return true;
        }
        return false;
    }

    private IPeripheral findPeripheral(World world, int x, int y, int z, ForgeDirection side) {
        try {
            IPeripheral p = ComputerCraft.getPeripheralAt((World)world, (int)x, (int)y, (int)z, (int)side.ordinal());
            if (!this.isBlacklisted(p)) {
                return p;
            }
        }
        catch (Exception e) {
            OpenComputers.log().warn(String.format("Error accessing ComputerCraft peripheral @ (%d, %d, %d).", x, y, z), (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean worksWith(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        return tileEntity != null && !li.cil.oc.api.network.Environment.class.isAssignableFrom(tileEntity.getClass()) && !this.isBlacklisted(tileEntity) && this.findPeripheral(world, x, y, z, side) != null;
    }

    @Override
    public ManagedEnvironment createEnvironment(World world, int x, int y, int z, ForgeDirection side) {
        return new Environment(this.findPeripheral(world, x, y, z, side));
    }

    public static class Environment
    extends li.cil.oc.api.prefab.ManagedEnvironment
    implements ManagedPeripheral {
        protected final IPeripheral peripheral;
        protected final CallableHelper helper;
        protected final Map<String, FakeComputerAccess> accesses = new HashMap<String, FakeComputerAccess>();

        public Environment(IPeripheral peripheral) {
            this.peripheral = peripheral;
            this.helper = new CallableHelper(peripheral.getMethodNames());
            this.setNode((Node)Network.newNode(this, Visibility.Network).create());
        }

        @Override
        public String[] methods() {
            return this.peripheral.getMethodNames();
        }

        @Override
        public Object[] invoke(String method, Context context, Arguments args) throws Exception {
            int index = this.helper.methodIndex(method);
            Object[] argArray = this.helper.convertArguments(args);
            FakeComputerAccess access = this.accesses.containsKey(context.node().address()) ? this.accesses.get(context.node().address()) : new FakeComputerAccess(this, context);
            return this.peripheral.callMethod((IComputerAccess)access, (ILuaContext)UnsupportedLuaContext.instance(), index, argArray);
        }

        @Override
        public void onConnect(Node node2) {
            super.onConnect(node2);
            if (node2.host() instanceof Context) {
                FakeComputerAccess access = new FakeComputerAccess(this, (Context)((Object)node2.host()));
                this.accesses.put(node2.address(), access);
                this.peripheral.attach((IComputerAccess)access);
            }
        }

        @Override
        public void onDisconnect(Node node2) {
            super.onDisconnect(node2);
            if (node2.host() instanceof Context) {
                FakeComputerAccess access = this.accesses.remove(node2.address());
                if (access != null) {
                    this.peripheral.detach((IComputerAccess)access);
                }
            } else if (node2 == this.node()) {
                for (FakeComputerAccess access : this.accesses.values()) {
                    this.peripheral.detach((IComputerAccess)access);
                    access.close();
                }
                this.accesses.clear();
            }
        }

        public static final class UnsupportedLuaContext
        implements ILuaContext {
            protected static final UnsupportedLuaContext Instance = new UnsupportedLuaContext();

            private UnsupportedLuaContext() {
            }

            public static UnsupportedLuaContext instance() {
                return Instance;
            }

            public long issueMainThreadTask(ILuaTask task) throws LuaException {
                throw new UnsupportedOperationException();
            }

            public Object[] executeMainThreadTask(ILuaTask task) throws LuaException, InterruptedException {
                throw new UnsupportedOperationException();
            }

            public Object[] pullEvent(String filter2) throws LuaException, InterruptedException {
                throw new UnsupportedOperationException();
            }

            public Object[] pullEventRaw(String filter2) throws InterruptedException {
                throw new UnsupportedOperationException();
            }

            public Object[] yield(Object[] arguments) throws InterruptedException {
                throw new UnsupportedOperationException();
            }
        }

        public static class FakeComputerAccess
        implements IComputerAccess {
            protected final Environment owner;
            protected final Context context;
            protected final Map<String, ManagedEnvironment> fileSystems = new HashMap<String, ManagedEnvironment>();

            public FakeComputerAccess(Environment owner, Context context) {
                this.owner = owner;
                this.context = context;
            }

            public void close() {
                for (ManagedEnvironment fileSystem : this.fileSystems.values()) {
                    fileSystem.node().remove();
                }
                this.fileSystems.clear();
            }

            public String mount(String desiredLocation, IMount mount) {
                if (this.fileSystems.containsKey(desiredLocation)) {
                    return null;
                }
                return this.mount(desiredLocation, FileSystem.asManagedEnvironment(FileSystem.fromComputerCraft(mount)));
            }

            public String mount(String desiredLocation, IMount mount, String driveName) {
                if (this.fileSystems.containsKey(desiredLocation)) {
                    return null;
                }
                return this.mount(desiredLocation, FileSystem.asManagedEnvironment(FileSystem.fromComputerCraft(mount), driveName));
            }

            public String mountWritable(String desiredLocation, IWritableMount mount) {
                if (this.fileSystems.containsKey(desiredLocation)) {
                    return null;
                }
                return this.mount(desiredLocation, FileSystem.asManagedEnvironment(FileSystem.fromComputerCraft(mount)));
            }

            public String mountWritable(String desiredLocation, IWritableMount mount, String driveName) {
                if (this.fileSystems.containsKey(desiredLocation)) {
                    return null;
                }
                return this.mount(desiredLocation, FileSystem.asManagedEnvironment(FileSystem.fromComputerCraft(mount), driveName));
            }

            private String mount(String path, ManagedEnvironment fileSystem) {
                this.fileSystems.put(path, fileSystem);
                this.context.node().connect(fileSystem.node());
                return path;
            }

            public void unmount(String location) {
                ManagedEnvironment fileSystem = this.fileSystems.remove(location);
                if (fileSystem != null) {
                    fileSystem.node().remove();
                }
            }

            public int getID() {
                return this.context.node().address().hashCode();
            }

            public void queueEvent(String event, Object[] arguments) {
                this.context.signal(event, arguments);
            }

            public String getAttachmentName() {
                return this.owner.node().address();
            }
        }
    }
}

