/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import openblocks.client.model.ModelProjector;
import openblocks.client.renderer.HeightMapRenderer;
import openblocks.common.HeightMapData;
import openblocks.common.MapDataManager;
import openblocks.common.tileentity.TileEntityProjector;
import openmods.OpenMods;
import org.lwjgl.opengl.GL11;

public class TileEntityProjectorRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("openblocks", "textures/models/projector.png");
    private static final float BLOCK_CENTRE_TRANSLATION = 0.5f;
    private static ModelProjector model = new ModelProjector();

    public void func_147500_a(TileEntity te, double x, double y, double z, float partialTickTime) {
        int pass = MinecraftForgeClient.getRenderPass();
        TileEntityProjector projector = (TileEntityProjector)te;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glRotated((double)(90 * projector.rotation()), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)0.0, (double)-0.5);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        int mapId = projector.mapId();
        if (pass <= 0) {
            this.renderProjector(projector, partialTickTime, mapId >= 0);
        } else {
            TileEntityProjectorRenderer.renderMap(projector, mapId);
        }
        GL11.glPopMatrix();
    }

    private static void renderMap(TileEntityProjector projector, int mapId) {
        HeightMapData data;
        if (projector.func_145831_w() != null && (data = MapDataManager.getMapData(projector.func_145831_w(), mapId)).isValid()) {
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
            HeightMapRenderer.instance.render(mapId, data);
        }
    }

    private void renderProjector(TileEntityProjector projector, float partialTickTime, boolean active) {
        GL11.glTranslated((double)0.25, (double)0.5, (double)0.25);
        this.func_147499_a(TEXTURE);
        if (active) {
            long ticks = OpenMods.proxy.getTicks(projector.func_145831_w());
            model.render((float)ticks * 0.01f, (float)ticks * 0.3f, 0.25f * MathHelper.func_76126_a((float)((float)ticks * 0.005f)) + 0.25f);
        } else {
            model.render(0.0f, 0.0f, 0.0f);
        }
    }
}

