/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.entity;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.client.model.ModelCartographer;
import openblocks.client.renderer.entity.EntitySelectionHandler;
import openblocks.common.entity.EntityCartographer;
import openmods.renderer.DisplayListWrapper;
import openmods.utils.BlockUtils;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public class EntityCartographerRenderer
extends Render {
    private static final double Z_FIGHTER = 1.0E-4;
    private static final double CONE_START = 0.075;
    private static final double CONE_END = 0.3;
    private static final double BASE_SIZE = 0.125;
    private static final double MAP_SIZE = 0.08;
    private static final double INTERSECTION_DIST = 0.15625;
    private static final double INTERSECTION_SIZE = 0.045138888888888895;
    private static final ResourceLocation TEXTURE = new ResourceLocation("openblocks:textures/models/cartographer.png");
    private static final ModelCartographer MODEL = new ModelCartographer();
    private static final DisplayListWrapper CONE_DISPLAY = new DisplayListWrapper(){

        public void compile() {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            GL11.glBegin((int)7);
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            GL11.glVertex3d((double)-0.045138888888888895, (double)-0.045138888888888895, (double)-0.15635);
            GL11.glVertex3d((double)-0.045138888888888895, (double)0.045138888888888895, (double)-0.15635);
            GL11.glVertex3d((double)0.045138888888888895, (double)0.045138888888888895, (double)-0.15635);
            GL11.glVertex3d((double)0.045138888888888895, (double)-0.045138888888888895, (double)-0.15635);
            GL11.glEnd();
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            GL11.glBegin((int)6);
            GL11.glColor4d((double)0.0, (double)1.0, (double)1.0, (double)0.125);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)-0.075);
            GL11.glVertex3d((double)-0.125, (double)-0.125, (double)-0.3);
            GL11.glVertex3d((double)0.125, (double)-0.125, (double)-0.3);
            GL11.glVertex3d((double)0.125, (double)0.125, (double)-0.3);
            GL11.glVertex3d((double)-0.125, (double)0.125, (double)-0.3);
            GL11.glVertex3d((double)-0.125, (double)-0.125, (double)-0.3);
            GL11.glEnd();
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
        }
    };

    public void func_76986_a(Entity entity, double x, double y, double z, float scale, float partialTickTime) {
        EntityCartographer cartographer = (EntityCartographer)entity;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.func_110776_a(TEXTURE);
        MODEL.renderBase(cartographer.eyeYaw);
        this.func_110776_a(TextureMap.field_110576_c);
        MODEL.renderEye(cartographer.eyeYaw, cartographer.eyePitch);
        cartographer.updateEye();
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return TEXTURE;
    }

    public static class Selection
    implements EntitySelectionHandler.ISelectionRenderer<EntityCartographer> {
        private static final Random RANDOM = new Random();
        private DynamicTexture mapTextureData;
        private ResourceLocation mapTextureLocation;

        @Override
        public void render(EntityCartographer e, EntityPlayer player, RenderGlobal context, float partialTickTime) {
            if (RANDOM.nextFloat() < 0.1f) {
                return;
            }
            GL11.glPushMatrix();
            RenderUtils.translateToPlayer((Entity)e, (float)partialTickTime);
            ForgeDirection side = BlockUtils.get2dOrientation((EntityLivingBase)player).getOpposite();
            switch (side) {
                case EAST: {
                    GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
                case WEST: {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
                case NORTH: {
                    GL11.glRotated((double)0.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
                case SOUTH: {
                    GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
            }
            GL11.glTranslated((double)0.0, (double)-0.03, (double)0.0);
            CONE_DISPLAY.render();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            if (e.isMapping.get()) {
                GL11.glTranslated((double)0.125, (double)0.125, (double)-0.3);
                this.bindMapTexture(textureManager);
                this.renderProgressMap(e.jobs);
            } else {
                textureManager.func_110577_a(TEXTURE);
                Selection.drawBase();
                GL11.glTranslated((double)0.125, (double)0.125, (double)-0.3001);
                Selection.renderText(e, context);
            }
            GL11.glPopMatrix();
        }

        private static void drawBase() {
            GL11.glDisable((int)2884);
            GL11.glBegin((int)7);
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex3d((double)-0.125, (double)-0.125, (double)-0.3);
            GL11.glTexCoord2d((double)0.5, (double)1.0);
            GL11.glVertex3d((double)0.125, (double)-0.125, (double)-0.3);
            GL11.glTexCoord2d((double)0.5, (double)0.5);
            GL11.glVertex3d((double)0.125, (double)0.125, (double)-0.3);
            GL11.glTexCoord2d((double)0.0, (double)0.5);
            GL11.glVertex3d((double)-0.125, (double)0.125, (double)-0.3);
            GL11.glEnd();
            GL11.glEnable((int)2884);
        }

        private static void renderText(EntityCartographer e, RenderGlobal context) {
            GL11.glScaled((double)0.015625, (double)0.015625, (double)1.0);
            FontRenderer fonts = Minecraft.func_71410_x().field_71466_p;
            String coords = String.format("%d,%d", e.getNewMapCenterX(), e.getNewMapCenterZ());
            int len = fonts.func_78256_a(coords);
            double scaleV = 0.5;
            int margin = 2;
            double available = 16 - 2 * margin;
            double scaleH = available / (double)len;
            double scale = Math.min(scaleV, scaleH);
            GL11.glTranslated((double)(-margin), (double)-2.0, (double)0.0);
            GL11.glScaled((double)(-scale), (double)(-scale), (double)1.0);
            fonts.func_78276_b(coords, 0, 0, 0);
        }

        private void renderProgressMap(EntityCartographer.MapJobs segments) {
            int[] mapColors = this.mapTextureData.func_110565_c();
            int bit = 0;
            int mapSize = segments.size();
            for (int row = 0; row < mapSize; ++row) {
                for (int column = 0; column < mapSize; ++column) {
                    mapColors[row * 64 + column] = segments.test(bit++) ? -16711911 : -16752629;
                }
            }
            this.mapTextureData.func_110564_a();
            float maxTex = (float)mapSize / 64.0f;
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3d((double)-0.045, (double)-0.045, (double)0.0);
            GL11.glTexCoord2f((float)0.0f, (float)maxTex);
            GL11.glVertex3d((double)-0.045, (double)-0.20500000000000002, (double)0.0);
            GL11.glTexCoord2f((float)maxTex, (float)maxTex);
            GL11.glVertex3d((double)-0.20500000000000002, (double)-0.20500000000000002, (double)0.0);
            GL11.glTexCoord2f((float)maxTex, (float)0.0f);
            GL11.glVertex3d((double)-0.20500000000000002, (double)-0.045, (double)0.0);
            GL11.glEnd();
        }

        private void bindMapTexture(TextureManager manager) {
            if (this.mapTextureLocation == null) {
                this.mapTextureData = new DynamicTexture(64, 64);
                this.mapTextureLocation = manager.func_110578_a("selection_", this.mapTextureData);
            }
            manager.func_110577_a(this.mapTextureLocation);
        }
    }
}

