/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.OpenBlocksGuiHandler;
import openmods.infobook.BookDocumentation;
import openmods.inventory.ItemInventory;
import openmods.inventory.PlayerItemInventory;
import openmods.inventory.StackEqualityTesterBuilder;
import openmods.inventory.legacy.ItemDistribution;

@BookDocumentation
public class ItemDevNull
extends Item {
    public static final int STACK_LIMIT = 5;
    private static final StackEqualityTesterBuilder.IEqualityTester tester = new StackEqualityTesterBuilder().useItem().useDamage().useNBT().build();

    public ItemDevNull() {
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
        this.func_77625_d(1);
    }

    private static int calculateDepth(ItemStack stack) {
        return ItemDevNull.calculateDepth(stack, 1);
    }

    private static int calculateDepth(ItemStack stack, int count) {
        if (stack == null) {
            return count;
        }
        if (stack.func_77973_b() instanceof ItemDevNull) {
            ItemStack innerStack = new ItemInventory(stack, 1).func_70301_a(0);
            return ItemDevNull.calculateDepth(innerStack, count + 1);
        }
        return count;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!(world.field_72995_K || Config.devNullSneakGui && !player.func_70093_af())) {
            player.openGui((Object)OpenBlocks.instance, OpenBlocksGuiHandler.GuiId.devNull.ordinal(), world, player.field_71071_by.field_70461_c, 0, 0);
        }
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int sideId, float hitX, float hitY, float hitZ) {
        Item item;
        ItemInventory inventory = new ItemInventory(stack, 1);
        ItemStack containedStack = inventory.func_70301_a(0);
        if (containedStack != null && (item = containedStack.func_77973_b()) instanceof ItemBlock) {
            Block placedBlock = ((ItemBlock)item).field_150939_a;
            Block clickedBlock = world.func_147439_a(x, y, z);
            if (clickedBlock == Blocks.field_150431_aC) {
                sideId = 1;
            } else if (!clickedBlock.isReplaceable((IBlockAccess)world, x, y, z)) {
                ForgeDirection side = ForgeDirection.getOrientation((int)sideId);
                x += side.offsetX;
                y += side.offsetY;
                z += side.offsetZ;
            }
            return !world.func_147472_a(placedBlock, x, y, z, false, sideId, null, stack);
        }
        return false;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        Item item;
        PlayerItemInventory inventory = new PlayerItemInventory(player, 1);
        ItemStack containedStack = inventory.func_70301_a(0);
        if (containedStack != null && (item = containedStack.func_77973_b()) instanceof ItemBlock) {
            boolean response = ((ItemBlock)item).func_77648_a(containedStack, player, world, x, y, z, par7, par8, par9, par10);
            if (containedStack.field_77994_a == 0) {
                inventory.func_70299_a(0, null);
            }
            inventory.func_70296_d();
            return response;
        }
        return true;
    }

    @SubscribeEvent
    public void onItemPickUp(EntityItemPickupEvent evt) {
        EntityPlayer player = evt.entityPlayer;
        ItemStack pickedStack = evt.item.func_92059_d();
        if (pickedStack == null || player == null) {
            return;
        }
        boolean foundMatchingContainer = false;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            boolean isMatching;
            ItemInventory inventory;
            ItemStack containedStack;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != this || (containedStack = (inventory = new ItemInventory(stack, 1)).func_70301_a(0)) == null || !(isMatching = tester.isEqual((Object)pickedStack, (Object)containedStack))) continue;
            ItemDistribution.tryInsertStack((IInventory)inventory, (int)0, (ItemStack)pickedStack, (boolean)true);
            if (pickedStack.field_77994_a == 0) {
                return;
            }
            foundMatchingContainer = true;
        }
        if (foundMatchingContainer) {
            pickedStack.field_77994_a = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        super.func_94581_a(register);
        Icons.iconTransparent = register.func_94245_a("openblocks:devnull");
        Icons.iconFull = register.func_94245_a("openblocks:devfull");
        Icons.iconOverload = register.func_94245_a("openblocks:devzerooverzero");
    }

    public static class Icons {
        public static IIcon iconFull;
        public static IIcon iconTransparent;
        public static IIcon iconOverload;
    }

    public static class DevNullInventory
    extends PlayerItemInventory {
        private final EntityPlayer player;

        public DevNullInventory(EntityPlayer player, int protectedSlot) {
            super(player, 1, protectedSlot);
            this.player = player;
        }

        public void onInventoryChanged(int slotNumber) {
            super.onInventoryChanged(slotNumber);
            if (!this.player.field_70170_p.field_72995_K && slotNumber == 0) {
                ItemStack stack = this.func_70301_a(0);
                this.checkStack(stack);
            }
        }

        public boolean func_94041_b(int i, ItemStack stack) {
            return ItemDevNull.calculateDepth(stack) < 7;
        }

        private void checkStack(ItemStack stack) {
            if (ItemDevNull.calculateDepth(stack) > 5) {
                this.player.func_71029_a((StatBase)OpenBlocks.stackAchievement);
            }
        }
    }
}

