/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.FavoriteRecipes;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.Widget;
import codechicken.nei.api.IGuiContainerOverlay;
import codechicken.nei.api.ShortcutInputHandler;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiFavoriteButton;
import codechicken.nei.recipe.GuiOverlayButton;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeButton;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeHandlerRef;
import cpw.mods.fml.common.eventhandler.Event;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class NEIRecipeWidget
extends Widget {
    protected final WeakHashMap<PositionedStack, List<ItemStack>> permutations = new WeakHashMap();
    protected boolean needUpdate = true;
    protected int cycleticks = 0;
    protected int lastcycle = 0;
    protected final RecipeHandlerRef handlerRef;
    protected final HandlerInfo handlerInfo;
    protected boolean showAsWidget = false;
    protected List<GuiRecipeButton> recipeButtons = null;

    public NEIRecipeWidget(RecipeHandlerRef handlerRef) {
        this.handlerRef = handlerRef;
        this.handlerInfo = GuiRecipeTab.getHandlerInfo(this.handlerRef.handler);
        this.update();
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void update() {
        this.w = Math.max(166, this.handlerInfo.getWidth());
        if (this.showAsWidget || !this.handlerInfo.expandVertically()) {
            int recipeHeight = this.handlerRef.handler.getRecipeHeight(this.handlerRef.recipeIndex);
            this.h = recipeHeight > 0 ? recipeHeight : this.handlerInfo.getHeight();
            this.h += this.handlerInfo.getYShift();
        }
        if (!this.needUpdate && !NEIClientUtils.shiftKey() && this.cycleticks++ / 20 != this.lastcycle) {
            this.lastcycle = this.cycleticks / 20;
            this.needUpdate = true;
        }
    }

    public List<GuiRecipeButton> getRecipeButtons() {
        if (this.recipeButtons == null) {
            this.recipeButtons = this.handlerRef.handler.getResultStack(this.handlerRef.recipeIndex) != null || !this.handlerRef.handler.getOtherStacks(this.handlerRef.recipeIndex).isEmpty() ? this.initButtons() : Collections.emptyList();
        }
        return Collections.unmodifiableList(this.recipeButtons);
    }

    protected List<GuiRecipeButton> getRecipeButtonsIfInit() {
        if (this.recipeButtons == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.recipeButtons);
    }

    public RecipeHandlerRef getRecipeHandlerRef() {
        return this.handlerRef;
    }

    public Recipe getRecipe() {
        return Recipe.of(this.handlerRef);
    }

    public HandlerInfo getHandlerInfo() {
        return this.handlerInfo;
    }

    public void showAsWidget(boolean show) {
        this.showAsWidget = show;
    }

    protected List<GuiRecipeButton> initButtons() {
        GuiRecipe<?> guiRecipe = this.getGuiRecipe();
        if (guiRecipe != null) {
            GuiRecipeButton.UpdateRecipeButtonsEvent.Pre preEvent = new GuiRecipeButton.UpdateRecipeButtonsEvent.Pre(guiRecipe, this, this.handlerInfo);
            if (MinecraftForge.EVENT_BUS.post((Event)preEvent)) {
                return preEvent.buttonList;
            }
            GuiRecipeButton.UpdateRecipeButtonsEvent.Post postEvent = new GuiRecipeButton.UpdateRecipeButtonsEvent.Post(guiRecipe, this, this.getDefatulButtons());
            MinecraftForge.EVENT_BUS.post((Event)postEvent);
            return postEvent.buttonList;
        }
        return this.getDefatulButtons();
    }

    protected List<GuiRecipeButton> getDefatulButtons() {
        GuiContainer guiContainer = NEIClientUtils.getGuiContainer();
        ArrayList<GuiRecipeButton> buttons = new ArrayList<GuiRecipeButton>();
        boolean showFavorites = NEIClientConfig.favoritesEnabled() && this.handlerInfo.getShowFavoritesButton();
        boolean showOverlay = this.handlerInfo.getShowOverlayButton();
        int x = Math.min(168, this.w) - 12;
        int y = this.h - 12 - 6;
        if (guiContainer instanceof IGuiContainerOverlay) {
            IGuiContainerOverlay overlay = (IGuiContainerOverlay)guiContainer;
            guiContainer = overlay.getFirstScreen();
        }
        if (showOverlay) {
            buttons.add(new GuiOverlayButton(guiContainer, this.handlerRef, x, y));
            y -= 13;
        }
        if (showFavorites) {
            buttons.add(new GuiFavoriteButton(this.handlerRef, x, y));
        }
        return buttons;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        int yShift = this.handlerInfo.getYShift();
        if (this.needUpdate) {
            this.needUpdate = false;
            this.updatePermutations();
        }
        GL11.glPushAttrib((int)24640);
        GL11.glTranslatef((float)this.x, (float)(this.y + yShift), (float)0.0f);
        this.handlerRef.handler.drawBackground(this.handlerRef.recipeIndex);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiContainerManager.enableMatrixStackLogging();
        for (PositionedStack pStack : this.handlerRef.handler.getIngredientStacks(this.handlerRef.recipeIndex)) {
            GuiContainerManager.drawItem(pStack.relx, pStack.rely, pStack.item);
            if (!pStack.contains(mouseX - this.x, mouseY - this.y - yShift)) continue;
            NEIClientUtils.gl2DRenderContext(() -> GuiDraw.drawRect((int)pStack.relx, (int)pStack.rely, (int)16, (int)16, (int)-2130706433));
        }
        for (PositionedStack pStack : this.handlerRef.handler.getOtherStacks(this.handlerRef.recipeIndex)) {
            GuiContainerManager.drawItem(pStack.relx, pStack.rely, pStack.item);
            if (!pStack.contains(mouseX - this.x, mouseY - this.y - yShift)) continue;
            NEIClientUtils.gl2DRenderContext(() -> GuiDraw.drawRect((int)pStack.relx, (int)pStack.rely, (int)16, (int)16, (int)-2130706433));
        }
        PositionedStack pStackResult = this.handlerRef.handler.getResultStack(this.handlerRef.recipeIndex);
        if (pStackResult != null) {
            GuiContainerManager.drawItem(pStackResult.relx, pStackResult.rely, pStackResult.item);
            if (pStackResult.contains(mouseX - this.x, mouseY - this.y - yShift)) {
                NEIClientUtils.gl2DRenderContext(() -> GuiDraw.drawRect((int)pStackResult.relx, (int)pStackResult.rely, (int)16, (int)16, (int)-2130706433));
            }
        }
        GuiContainerManager.disableMatrixStackLogging();
        this.handlerRef.handler.drawForeground(this.handlerRef.recipeIndex);
        GuiRecipeButton overlayButton = this.getRecipeButtons().stream().filter(b -> this.showAsWidget ? b instanceof GuiOverlayButton : b.contains(mouseX - this.x, mouseY - this.y - yShift)).findAny().orElse(null);
        if (overlayButton != null && overlayButton.field_146124_l) {
            NEIClientUtils.gl2DRenderContext(() -> overlayButton.drawItemOverlay());
        }
        GL11.glTranslatef((float)(-this.x), (float)(-this.y - yShift), (float)0.0f);
        GL11.glPopAttrib();
        if (!this.showAsWidget) {
            Minecraft mc = NEIClientUtils.mc();
            for (GuiRecipeButton button : this.getRecipeButtons()) {
                button.field_146128_h += this.x;
                button.field_146129_i += this.y;
                button.func_146112_a(mc, mouseX, mouseY);
                button.field_146128_h -= this.x;
                button.field_146129_i -= this.y;
            }
        }
        LayoutManager.recipeHandlerWidget.drawGuiPlaceholder(this);
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        return false;
    }

    @Override
    public void lastKeyTyped(int keyID, char keyChar) {
        Point mouse = GuiDraw.getMousePosition();
        this.forEachButtons(button -> {
            if (button.contains(mouse.x, mouse.y)) {
                button.lastKeyTyped(keyChar, keyID);
            }
            return null;
        }, null);
    }

    @Override
    public boolean handleClick(int mouseX, int mouseY, int button) {
        Minecraft mc;
        if (ShortcutInputHandler.handleMouseClick(this.getStackMouseOver(mouseX, mouseY))) {
            return true;
        }
        if (button == 0 && this.forEachButtons(arg_0 -> NEIRecipeWidget.lambda$handleClick$6(mc = NEIClientUtils.mc(), mouseX, mouseY, arg_0), false).booleanValue()) {
            return true;
        }
        GuiRecipe<?> guiRecipe = this.getGuiRecipe();
        if (guiRecipe == null) {
            return false;
        }
        return this.handlerRef.handler.mouseClicked(guiRecipe, button, this.handlerRef.recipeIndex);
    }

    @Override
    public List<String> handleTooltip(int mouseX, int mouseY, List<String> tooltip) {
        GuiRecipe<?> guiRecipe = this.getGuiRecipe();
        if (guiRecipe == null) {
            return tooltip;
        }
        List<String> localTooltip = this.handlerRef.handler.handleTooltip(guiRecipe, tooltip, this.handlerRef.recipeIndex);
        return this.forEachButtons(button -> button.contains(mouseX, mouseY) ? button.handleTooltip(localTooltip) : null, localTooltip);
    }

    @Override
    public List<String> handleItemTooltip(ItemStack itemstack, int mousex, int mousey, List<String> tooltip) {
        GuiRecipe<?> guiRecipe = this.getGuiRecipe();
        if (guiRecipe == null) {
            return tooltip;
        }
        return this.handlerRef.handler.handleItemTooltip(guiRecipe, itemstack, tooltip, this.handlerRef.recipeIndex);
    }

    @Override
    public Map<String, String> handleHotkeys(int mouseX, int mouseY, Map<String, String> hotkeys) {
        return this.forEachButtons(button -> button.contains(mouseX, mouseY) ? button.handleHotkeys(mouseX, mouseY, hotkeys) : null, hotkeys);
    }

    @Override
    public boolean onMouseWheel(int scroll, int mx, int my) {
        if (this.forEachButtons(button -> button.contains(mx, my) ? Boolean.valueOf(button.mouseScrolled(scroll)) : null, false).booleanValue()) {
            return true;
        }
        if (this.scrollPermutations(scroll, mx, my)) {
            return true;
        }
        GuiRecipe<?> guiRecipe = this.getGuiRecipe();
        return guiRecipe != null && this.handlerRef.handler.mouseScrolled(guiRecipe, scroll, this.handlerRef.recipeIndex);
    }

    protected boolean scrollPermutations(int scroll, int mx, int my) {
        if (!NEIClientUtils.shiftKey()) {
            return false;
        }
        PositionedStack overStack = this.getPositionedStackMouseOver(mx, my);
        if (overStack != null && overStack.items.length > 1) {
            List<ItemStack> items = overStack.getFilteredPermutations();
            int stackIndex = overStack.getPermutationIndex(overStack.item);
            ItemStack stack = items.get((items.size() - scroll + stackIndex) % items.size());
            Stream.concat(this.handlerRef.handler.getIngredientStacks(this.handlerRef.recipeIndex).stream(), this.handlerRef.handler.getOtherStacks(this.handlerRef.recipeIndex).stream()).filter(pStack -> pStack.containsWithNBT(stack)).forEach(pStack -> pStack.setPermutationToRender(stack));
            return true;
        }
        return false;
    }

    protected <R> R forEachButtons(Function<GuiRecipeButton, R> callback, R defaultValue) {
        for (GuiRecipeButton button : this.getRecipeButtonsIfInit()) {
            button.field_146128_h += this.x;
            button.field_146129_i += this.y;
            R result = callback.apply(button);
            button.field_146128_h -= this.x;
            button.field_146129_i -= this.y;
            if (result == null) continue;
            return result;
        }
        return defaultValue;
    }

    public boolean isFocusedRecipe(int mx, int my) {
        int yShift = this.handlerInfo.getYShift();
        PositionedStack pStackResult = this.handlerRef.handler.getResultStack(this.handlerRef.recipeIndex);
        if (pStackResult != null && pStackResult.contains(mx - this.x, my - this.y - yShift)) {
            return true;
        }
        for (PositionedStack pStackOver : this.handlerRef.handler.getOtherStacks(this.handlerRef.recipeIndex)) {
            if (!pStackOver.contains(mx - this.x, my - this.y - yShift)) continue;
            return true;
        }
        return false;
    }

    public PositionedStack getPositionedStackMouseOver(int mx, int my) {
        int yShift = this.handlerInfo.getYShift();
        for (PositionedStack pStack : this.handlerRef.handler.getIngredientStacks(this.handlerRef.recipeIndex)) {
            if (!pStack.contains(mx - this.x, my - this.y - yShift)) continue;
            return pStack;
        }
        for (PositionedStack pStack : this.handlerRef.handler.getOtherStacks(this.handlerRef.recipeIndex)) {
            if (!pStack.contains(mx - this.x, my - this.y - yShift)) continue;
            return pStack;
        }
        PositionedStack pStackResult = this.handlerRef.handler.getResultStack(this.handlerRef.recipeIndex);
        if (pStackResult != null && pStackResult.contains(mx - this.x, my - this.y - yShift)) {
            return pStackResult;
        }
        return null;
    }

    @Override
    public ItemStack getStackMouseOver(int mx, int my) {
        PositionedStack pStack = this.getPositionedStackMouseOver(mx, my);
        return pStack != null ? pStack.item : null;
    }

    protected GuiRecipe<?> getGuiRecipe() {
        GuiContainer guiContainer = NEIClientUtils.getGuiContainer();
        if (guiContainer instanceof GuiRecipe) {
            GuiRecipe guiRecipe = (GuiRecipe)guiContainer;
            return guiRecipe;
        }
        return null;
    }

    protected GuiContainer getFirstGui() {
        GuiContainer guiContainer = NEIClientUtils.getGuiContainer();
        if (guiContainer instanceof GuiRecipe) {
            GuiRecipe guiRecipe = (GuiRecipe)guiContainer;
            return guiRecipe.firstGui;
        }
        return guiContainer;
    }

    protected void updatePermutations() {
        List permutations;
        for (PositionedStack pStack : this.handlerRef.handler.getIngredientStacks(this.handlerRef.recipeIndex)) {
            if (pStack.items.length <= 1) continue;
            permutations = this.permutations.computeIfAbsent(pStack, stack -> stack.getFilteredPermutations(FavoriteRecipes::contains));
            pStack.setPermutationToRender((ItemStack)permutations.get(this.lastcycle % permutations.size()));
        }
        for (PositionedStack pStack : this.handlerRef.handler.getOtherStacks(this.handlerRef.recipeIndex)) {
            if (pStack.items.length <= 1) continue;
            permutations = this.permutations.computeIfAbsent(pStack, stack -> stack.getFilteredPermutations(FavoriteRecipes::contains));
            pStack.setPermutationToRender((ItemStack)permutations.get(this.lastcycle % permutations.size()));
        }
        PositionedStack pStackResult = this.handlerRef.handler.getResultStack(this.handlerRef.recipeIndex);
        if (pStackResult != null && pStackResult.items.length > 1) {
            List permutations2 = this.permutations.computeIfAbsent(pStackResult, stack -> stack.getFilteredPermutations(FavoriteRecipes::contains));
            pStackResult.setPermutationToRender((ItemStack)permutations2.get(this.lastcycle % permutations2.size()));
        }
    }

    private static /* synthetic */ Boolean lambda$handleClick$6(Minecraft mc, int mouseX, int mouseY, GuiRecipeButton guibutton) {
        if (guibutton.func_146116_c(mc, mouseX, mouseY)) {
            NEIClientUtils.playClickSound();
            guibutton.func_146118_a(mouseX, mouseY);
            return true;
        }
        return null;
    }
}

