/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.bookmark;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.StackInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class BookmarkItem {
    private static Map<ItemStack, String> fuzzyPermutations = new HashMap<ItemStack, String>();
    public int groupId;
    public long amount = 0L;
    public final int fluidCellAmount;
    public ItemStack itemStack;
    public Map<String, ItemStack> permutations;
    public long factor;
    public Recipe.RecipeId recipeId;
    public boolean isIngredient = false;

    protected BookmarkItem(int groupId, long amount, int fluidCellAmount, ItemStack itemStack, Map<String, ItemStack> permutations, long factor, Recipe.RecipeId recipeId, boolean isIngredient) {
        this.groupId = groupId;
        this.amount = amount;
        this.fluidCellAmount = fluidCellAmount;
        this.itemStack = itemStack;
        this.permutations = permutations;
        this.factor = factor;
        this.recipeId = recipeId;
        this.isIngredient = isIngredient;
    }

    public static BookmarkItem of(int groupId, ItemStack stack, long factor, Recipe.RecipeId recipeId, boolean isIngredient, Map<String, ItemStack> permutations) {
        long amount;
        FluidStack fluidStack = StackInfo.getFluid(stack);
        int fluidCellAmount = 1;
        if (fluidStack != null) {
            amount = (long)fluidStack.amount * (long)Math.max(0, stack.field_77994_a);
            fluidCellAmount = Math.max(1, StackInfo.isFluidContainer(stack) ? fluidStack.amount : 1);
        } else {
            amount = StackInfo.getAmount(stack);
        }
        return new BookmarkItem(groupId, amount, fluidCellAmount, stack, permutations, factor * (long)fluidCellAmount, recipeId, isIngredient);
    }

    public static BookmarkItem of(int groupId, ItemStack stack, long factor, Recipe.RecipeId recipeId, boolean isIngredient) {
        return BookmarkItem.of(groupId, stack, factor, recipeId, isIngredient, BookmarkItem.generatePermutations(stack, recipeId, isIngredient));
    }

    public static BookmarkItem of(int groupId, ItemStack stack) {
        NBTTagCompound nbTag = StackInfo.itemStackToNBT(stack);
        long factor = nbTag.func_74764_b("gtFluidName") ? (long)Math.min(144, nbTag.func_74762_e("Count")) : 1L;
        return BookmarkItem.of(groupId, stack, factor, null, false, Collections.singletonMap(BookmarkItem.getItemGUID(stack), stack));
    }

    public BookmarkItem copyWithAmount(long amount) {
        return new BookmarkItem(this.groupId, amount, this.fluidCellAmount, this.itemStack, this.permutations, this.factor, this.recipeId, this.isIngredient);
    }

    public BookmarkItem copy() {
        return this.copyWithAmount(this.amount);
    }

    public static Map<String, ItemStack> generatePermutations(ItemStack stack, Recipe.RecipeId recipeId, boolean isIngredient) {
        if (isIngredient && recipeId != null) {
            return BookmarkItem.generatePermutations(stack, Recipe.of(recipeId));
        }
        return Collections.singletonMap(BookmarkItem.getItemGUID(stack), stack);
    }

    public static Map<String, ItemStack> generatePermutations(ItemStack stack, Recipe recipe) {
        Recipe.RecipeIngredient ingr;
        if (recipe != null && (ingr = (Recipe.RecipeIngredient)recipe.getIngredients().stream().filter(ingredient -> ingredient.contains(stack)).findAny().orElse(null)) != null) {
            HashMap<String, ItemStack> permutations = new HashMap<String, ItemStack>();
            for (ItemStack ingrStack : ingr.getPermutations()) {
                permutations.put(BookmarkItem.getItemGUID(ingrStack), ingrStack);
            }
            return permutations;
        }
        return Collections.singletonMap(BookmarkItem.getItemGUID(stack), stack);
    }

    private static synchronized String getItemGUID(ItemStack stack) {
        FluidStack fluidStack = StackInfo.getFluid(stack);
        if (fluidStack != null) {
            return fluidStack.getFluid().getName() + ":" + fluidStack.tag;
        }
        for (Map.Entry<ItemStack, String> entry : fuzzyPermutations.entrySet()) {
            if (!NEIClientUtils.areStacksSameTypeCraftingWithNBT(stack, entry.getKey())) continue;
            fuzzyPermutations.put(stack, entry.getValue());
            return entry.getValue();
        }
        String stackGUID = StackInfo.getItemStackGUID(stack);
        fuzzyPermutations.put(stack, stackGUID);
        return stackGUID;
    }

    public boolean containsItems(BookmarkItem item) {
        return this.permutations.keySet().stream().anyMatch(item.permutations::containsKey);
    }

    public ItemStack getItemStack() {
        return this.getItemStack(this.amount);
    }

    public ItemStack getItemStack(long amount) {
        return StackInfo.withAmount(this.itemStack, this.getStackSize(amount));
    }

    public long getStackSize() {
        return this.getStackSize(this.amount);
    }

    public long getStackSize(long amount) {
        return (long)(this.factor > 0L ? Math.ceil((double)amount / (double)this.fluidCellAmount) : 0.0);
    }

    public long getMultiplier() {
        return this.getMultiplier(this.amount);
    }

    public long getMultiplier(long amount) {
        return (long)(this.factor > 0L ? Math.ceil((double)amount / (double)this.factor) : 0.0);
    }

    public long getFactor() {
        return this.factor / (long)this.fluidCellAmount;
    }

    public boolean equalsRecipe(BookmarkItem meta) {
        return this.equalsRecipe(meta.recipeId, meta.groupId);
    }

    public boolean equalsRecipe(Recipe.RecipeId recipeId, int groupId) {
        return groupId == this.groupId && recipeId != null && recipeId.equals(this.recipeId);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.fluidCellAmount, this.isIngredient, this.recipeId);
    }

    public boolean equals(Object object) {
        if (object instanceof BookmarkItem) {
            BookmarkItem item = (BookmarkItem)object;
            return this.groupId == item.groupId && this.isIngredient == item.isIngredient && this.fluidCellAmount == item.fluidCellAmount && StackInfo.equalItemAndNBT(this.itemStack, item.itemStack, true) && (this.recipeId == item.recipeId || this.recipeId != null && this.recipeId.equals(item.recipeId));
        }
        return false;
    }
}

