/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.search;

import codechicken.nei.ItemList;
import codechicken.nei.SearchTokenParser;
import codechicken.nei.api.ItemFilter;
import java.util.ArrayList;

public class SearchToken {
    public Character ignore = null;
    public boolean quotes = false;
    public Character firstChar = null;
    public String[] words;
    public String rawText = "";
    public int start = 0;
    public int end = 0;

    public ItemFilter getFilter(SearchTokenParser parser) {
        if (this.words == null || this.words.length == 0) {
            return null;
        }
        if (!this.rawText.isEmpty()) {
            ItemFilter result = this.parseToken(parser);
            if (this.ignore != null) {
                return new ItemList.NegatedItemFilter(result);
            }
            return result;
        }
        if (this.ignore == null) {
            return new ItemList.NothingItemFilter();
        }
        return null;
    }

    public boolean isSimpleFilter() {
        return this.firstChar == null && !this.quotes && this.ignore == null;
    }

    private ItemFilter parseToken(SearchTokenParser parser) {
        SearchTokenParser.ISearchParserProvider provider;
        SearchTokenParser.ISearchParserProvider iSearchParserProvider = provider = this.firstChar == null ? null : parser.getProvider(this.firstChar.charValue());
        if (provider == null || provider.getSearchMode() == SearchTokenParser.SearchMode.NEVER) {
            ArrayList<ItemFilter> filters = new ArrayList<ItemFilter>();
            for (SearchTokenParser.ISearchParserProvider _provider : parser.getProviders()) {
                if (_provider.getSearchMode() != SearchTokenParser.SearchMode.ALWAYS) continue;
                ItemList.AllMultiItemFilter filter = this.generateFilters(_provider);
                if (filter.filters.isEmpty()) continue;
                filters.add(filter);
            }
            return filters.isEmpty() ? new ItemList.NothingItemFilter() : new ItemList.AnyMultiItemFilter(filters);
        }
        return this.generateFilters(provider);
    }

    private ItemList.AllMultiItemFilter generateFilters(SearchTokenParser.ISearchParserProvider provider) {
        ItemList.AllMultiItemFilter filters = new ItemList.AllMultiItemFilter();
        for (String work : this.words) {
            ItemFilter filter = provider.getFilter(work);
            if (filter == null) continue;
            filters.filters.add(filter);
        }
        return filters;
    }
}

