/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ItemList;
import codechicken.nei.LRUCache;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.IRecipeFilter;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.filter.AllMultiRecipeFilter;
import codechicken.nei.filter.AnyMultiRecipeFilter;
import codechicken.nei.filter.RecipeFilter;
import codechicken.nei.search.ItemFilterVisitor;
import codechicken.nei.search.RecipeFilterVisitor;
import codechicken.nei.search.SearchExpressionUtils;
import codechicken.nei.search.SearchToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class SearchTokenParser {
    public static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    protected final LRUCache<String, ItemFilter> filtersCache = new LRUCache(20);
    protected final LRUCache<String, IRecipeFilter> recipesCache = new LRUCache(20);
    protected final List<ISearchParserProvider> searchProviders;
    protected final ProvidersCache providersCache = new ProvidersCache();
    protected final Map<Character, Character> prefixRedefinitions = new HashMap<Character, Character>();
    protected String prefixes = null;

    public SearchTokenParser(List<ISearchParserProvider> searchProviders) {
        this.searchProviders = searchProviders;
    }

    public SearchTokenParser() {
        this(new ArrayList<ISearchParserProvider>());
    }

    public void addProvider(ISearchParserProvider provider) {
        this.searchProviders.add(provider);
        this.clearCache();
    }

    public void clearCache() {
        this.providersCache.clear();
        this.filtersCache.clear();
        this.recipesCache.clear();
        this.prefixes = null;
    }

    public List<ISearchParserProvider> getProviders() {
        Language currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (!currentLanguage.func_135034_a().equals(this.providersCache.languageCode)) {
            this.providersCache.providers = new ArrayList<ISearchParserProvider>();
            this.providersCache.languageCode = currentLanguage.func_135034_a();
            HashMap<Character, ISearchParserProvider> providers = new HashMap<Character, ISearchParserProvider>();
            for (int index = this.searchProviders.size() - 1; index >= 0; --index) {
                ISearchParserProvider provider = this.searchProviders.get(index);
                if (!provider.getMatchingLanguages().contains(currentLanguage)) continue;
                if (provider.getSearchMode() == SearchMode.PREFIX && !providers.containsKey(Character.valueOf(provider.getPrefix()))) {
                    providers.put(Character.valueOf(provider.getPrefix()), provider);
                    continue;
                }
                if (provider.getSearchMode() != SearchMode.ALWAYS) continue;
                this.providersCache.providers.add(provider);
            }
            this.providersCache.providers.addAll(providers.values());
        }
        return this.providersCache.providers;
    }

    public boolean hasRedefinedPrefix(char ch) {
        return this.getPrefixes().indexOf(ch) >= 0;
    }

    public ISearchParserProvider getProvider(char ch) {
        if (!this.hasRedefinedPrefix(ch)) {
            return null;
        }
        for (ISearchParserProvider provider : this.getProviders()) {
            if (provider.getSearchMode() != SearchMode.PREFIX || this.getRedefinedPrefix(provider.getPrefix()) != ch) continue;
            return provider;
        }
        return null;
    }

    public List<ItemFilter> getAlwaysProvidersFilters(String searchText) {
        ArrayList<ItemFilter> filters = new ArrayList<ItemFilter>();
        for (ISearchParserProvider provider : this.getProviders()) {
            if (provider.getSearchMode() != SearchMode.ALWAYS) continue;
            filters.add(provider.getFilter(searchText));
        }
        return filters;
    }

    public synchronized ItemFilter getFilter(String filterText) {
        return this.getFilter(filterText, false);
    }

    public synchronized ItemFilter getFilter(String rawText, boolean skipRecipeTokens) {
        String filterText = EnumChatFormatting.func_110646_a((String)rawText).toLowerCase();
        if (filterText == null || filterText.isEmpty()) {
            return new ItemList.EverythingItemFilter();
        }
        int patternMode = NEIClientConfig.getIntSetting("inventory.search.patternMode");
        if (patternMode != 3) {
            return this.filtersCache.computeIfAbsent(skipRecipeTokens + ":" + filterText, _t -> {
                ArrayList<ItemFilter> searchTokens = new ArrayList<ItemFilter>();
                for (String[] subQuery : this.splitByDelimiters(filterText, "|", false)) {
                    if (subQuery[1].isEmpty()) continue;
                    ArrayList<ItemFilter> tokens = new ArrayList<ItemFilter>();
                    for (String[] contextQuery : this.splitByDelimiters(subQuery[1], skipRecipeTokens ? "<>" : "", false)) {
                        if (contextQuery[1].isEmpty() || contextQuery[0].startsWith(">")) continue;
                        if (!contextQuery[0].isEmpty()) {
                            contextQuery[0] = contextQuery[0].substring(1);
                        }
                        for (SearchToken token : this.splitSearchText(contextQuery[0] + contextQuery[1])) {
                            ItemFilter result = token.getFilter(this);
                            if (result == null) continue;
                            tokens.add(result);
                        }
                    }
                    if (tokens.size() == 1) {
                        searchTokens.add((ItemFilter)tokens.get(0));
                        continue;
                    }
                    if (tokens.isEmpty()) continue;
                    searchTokens.add(new ItemList.AllMultiItemFilter(tokens));
                }
                if (searchTokens.isEmpty()) {
                    return new ItemList.EverythingItemFilter();
                }
                if (searchTokens.size() == 1) {
                    return new IsRegisteredItemFilter((ItemFilter)searchTokens.get(0));
                }
                return new IsRegisteredItemFilter(new ItemList.AnyMultiItemFilter(searchTokens));
            });
        }
        return this.filtersCache.computeIfAbsent(filterText, text -> {
            int spaceMode = NEIClientConfig.getIntSetting("inventory.search.spaceMode");
            if (spaceMode == 1) {
                text = SPACE_PATTERN.matcher((CharSequence)text).replaceAll("\\\\ ");
            }
            return new IsRegisteredItemFilter(SearchExpressionUtils.visitSearchExpression(text, new ItemFilterVisitor(this)));
        });
    }

    public synchronized IRecipeFilter getRecipeFilter(String filterText) {
        if ((filterText = EnumChatFormatting.func_110646_a((String)filterText).toLowerCase()) == null || filterText.isEmpty()) {
            return new RecipeFilter(RecipeFilter.FilterContext.ANY, true, new ItemList.EverythingItemFilter());
        }
        int patternMode = NEIClientConfig.getIntSetting("inventory.search.patternMode");
        if (patternMode != 3) {
            return this.recipesCache.computeIfAbsent(filterText, input -> {
                ArrayList<IRecipeFilter> searchTokens = new ArrayList<IRecipeFilter>();
                for (String[] orQueryPart : this.splitByDelimiters((String)input, "|", false)) {
                    if (orQueryPart[1].isEmpty()) continue;
                    ArrayList<IRecipeFilter> contextList = new ArrayList<IRecipeFilter>();
                    for (String[] contextQuery : this.splitByDelimiters(orQueryPart[1], "<>", false)) {
                        if (contextQuery[1].isEmpty()) continue;
                        ArrayList<IRecipeFilter> tokens = new ArrayList<IRecipeFilter>();
                        RecipeFilter.FilterContext context = RecipeFilter.FilterContext.ANY;
                        if (!contextQuery[0].isEmpty()) {
                            context = RecipeFilter.FilterContext.fromChar(contextQuery[0].charAt(0));
                            contextQuery[0] = contextQuery[0].substring(1);
                        }
                        for (SearchToken token : this.splitSearchText(contextQuery[0] + contextQuery[1])) {
                            ItemFilter result = token.getFilter(this);
                            if (result == null) continue;
                            tokens.add(new RecipeFilter(context, token.ignore == null || token.ignore.charValue() != '!', result));
                        }
                        if (tokens.size() == 1) {
                            contextList.add((IRecipeFilter)tokens.get(0));
                            continue;
                        }
                        if (tokens.isEmpty()) continue;
                        contextList.add(new AllMultiRecipeFilter(tokens));
                    }
                    if (contextList.size() == 1) {
                        searchTokens.add((IRecipeFilter)contextList.get(0));
                        continue;
                    }
                    if (contextList.isEmpty()) continue;
                    searchTokens.add(new AllMultiRecipeFilter(contextList));
                }
                if (searchTokens.isEmpty()) {
                    return new RecipeFilter(RecipeFilter.FilterContext.ANY, true, new ItemList.EverythingItemFilter());
                }
                if (searchTokens.size() == 1) {
                    return (IRecipeFilter)searchTokens.get(0);
                }
                return new AnyMultiRecipeFilter(searchTokens);
            });
        }
        return this.recipesCache.computeIfAbsent(filterText, text -> {
            int spaceMode = NEIClientConfig.getIntSetting("inventory.search.spaceMode");
            if (spaceMode == 1) {
                text = SPACE_PATTERN.matcher((CharSequence)text).replaceAll("\\\\ ");
            }
            return SearchExpressionUtils.visitSearchExpression(text, new RecipeFilterVisitor(this));
        });
    }

    public List<SearchToken> splitSearchText(String filterText) {
        if (filterText.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SearchToken> tokens = new ArrayList<SearchToken>();
        int spaceMode = NEIClientConfig.getIntSetting("inventory.search.spaceMode");
        String prefixes = this.getPrefixes();
        SearchToken lastToken = null;
        int lastEnd = 0;
        for (String[] part : this.splitByDelimiters(filterText, "-!" + prefixes, true)) {
            SearchToken token = this.createToken(lastEnd, part, prefixes);
            int length = part[0].length() + part[1].length();
            if (token.isSimpleFilter() && token.rawText.isEmpty()) {
                lastEnd += length;
                continue;
            }
            if (spaceMode == 0) {
                lastToken = token;
                tokens.add(lastToken);
            } else if (spaceMode == 1) {
                if (lastToken != null && lastToken.isSimpleFilter() && token.isSimpleFilter()) {
                    lastToken.words[0] = lastToken.rawText = filterText.substring(lastToken.start, token.end).trim();
                    lastToken.end = token.end;
                } else {
                    lastToken = token;
                    tokens.add(lastToken);
                }
            } else if (spaceMode == 2) {
                if (lastToken != null && lastToken.isSimpleFilter() && token.isSimpleFilter()) {
                    String[] newWords = new String[lastToken.words.length + token.words.length];
                    System.arraycopy(lastToken.words, 0, newWords, 0, lastToken.words.length);
                    System.arraycopy(token.words, 0, newWords, lastToken.words.length, token.words.length);
                    lastToken.words = newWords;
                    lastToken.rawText = filterText.substring(lastToken.start, token.end).trim();
                    lastToken.end = token.end;
                } else {
                    lastToken = token;
                    tokens.add(lastToken);
                }
            }
            lastEnd += length;
        }
        return tokens;
    }

    private SearchToken createToken(int lastEnd, String[] part, String prefixes) {
        String text;
        char firstChar;
        SearchToken token = new SearchToken();
        String pref = part[0];
        String query = part[1].trim();
        token.start = lastEnd;
        token.end = lastEnd + pref.length() + query.length();
        if (pref.startsWith("-")) {
            token.ignore = Character.valueOf('-');
            pref = pref.substring(1);
        } else if (pref.startsWith("!")) {
            token.ignore = Character.valueOf('!');
            pref = pref.substring(1);
        }
        if (!pref.isEmpty() && prefixes.indexOf(firstChar = pref.charAt(0)) >= 0) {
            token.firstChar = Character.valueOf(firstChar);
            pref = pref.substring(1);
        }
        boolean bl = token.quotes = (text = pref + query).length() > 1 && text.startsWith("\"") && text.endsWith("\"");
        if (token.quotes) {
            text = text.substring(1, text.length() - 1);
        }
        token.rawText = text;
        token.words = new String[]{token.quotes ? text.replaceAll("\\\\\"", "\"") : text};
        return token;
    }

    public List<String[]> splitByDelimiters(String input, String delimiters, boolean space) {
        if (delimiters == null || delimiters.isEmpty()) {
            return Collections.singletonList(new String[]{"", input});
        }
        ArrayList<String[]> tokens = new ArrayList<String[]>();
        int length = input.length();
        boolean insideQuotes = false;
        String token = "";
        int lastEnd = 0;
        for (int index = 0; index < length; ++index) {
            char ch = input.charAt(index);
            if (!(insideQuotes || delimiters.indexOf(ch) < 0 || space && index != 0 && input.charAt(index - 1) != ' ')) {
                if (lastEnd == index) {
                    token = token + String.valueOf(ch);
                } else {
                    tokens.add(new String[]{token, input.substring(lastEnd, index)});
                    token = String.valueOf(ch);
                }
                lastEnd = index + 1;
            } else if (!insideQuotes && space && ch != ' ' && index > 0 && input.charAt(index - 1) == ' ') {
                tokens.add(new String[]{token, input.substring(lastEnd, index)});
                token = "";
                lastEnd = index;
            }
            if (ch != '\"' || index != 0 && input.charAt(index - 1) == '\\') continue;
            insideQuotes = !insideQuotes;
        }
        tokens.add(new String[]{token, input.substring(lastEnd)});
        return tokens;
    }

    private String getPrefixes() {
        if (this.prefixes == null) {
            StringBuilder builder = new StringBuilder();
            for (ISearchParserProvider provider : this.getProviders()) {
                if (provider.getSearchMode() != SearchMode.PREFIX) continue;
                builder.append(this.getRedefinedPrefix(provider.getPrefix()));
            }
            this.prefixes = builder.toString();
        }
        return this.prefixes;
    }

    public char getRedefinedPrefix(char prefix) {
        return this.prefixRedefinitions.getOrDefault(Character.valueOf(prefix), Character.valueOf(prefix)).charValue();
    }

    private static class ProvidersCache {
        public String languageCode = null;
        public List<ISearchParserProvider> providers = new ArrayList<ISearchParserProvider>();

        private ProvidersCache() {
        }

        public void clear() {
            this.languageCode = null;
            this.providers.clear();
        }
    }

    public static interface ISearchParserProvider {
        public ItemFilter getFilter(String var1);

        public static List<Language> getAllLanguages() {
            return new ArrayList<Language>(Minecraft.func_71410_x().func_135016_M().func_135040_d());
        }

        default public List<Language> getMatchingLanguages() {
            return ISearchParserProvider.getAllLanguages();
        }

        public char getPrefix();

        public EnumChatFormatting getHighlightedColor();

        public SearchMode getSearchMode();
    }

    public static enum SearchMode {
        ALWAYS,
        PREFIX,
        NEVER;


        public static SearchMode fromInt(int value) {
            SearchMode searchMode;
            switch (value) {
                case 0: {
                    searchMode = ALWAYS;
                    break;
                }
                case 1: {
                    searchMode = PREFIX;
                    break;
                }
                default: {
                    searchMode = NEVER;
                }
            }
            return searchMode;
        }
    }

    public static class IsRegisteredItemFilter
    implements ItemFilter {
        public ItemFilter filter;

        public IsRegisteredItemFilter(ItemFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean matches(ItemStack item) {
            return item != null && item.func_77973_b() != null && item.func_77973_b().delegate.name() != null && this.filter.matches(item);
        }
    }
}

