/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.bookmark;

import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.recipe.chain.RecipeChainMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;

public class RecipeChainDetails {
    public final Map<Integer, BookmarkChainItem> calculatedItems = new HashMap<Integer, BookmarkChainItem>();
    public final Map<Integer, Recipe.RecipeId> itemToRecipe = new HashMap<Integer, Recipe.RecipeId>();
    public final Set<Recipe.RecipeId> outputRecipes = new HashSet<Recipe.RecipeId>();
    public final Set<Recipe.RecipeId> recipeInMiddle = new HashSet<Recipe.RecipeId>();
    public final Map<Recipe.RecipeId, Set<Recipe.RecipeId>> recipeRelations = new HashMap<Recipe.RecipeId, Set<Recipe.RecipeId>>();

    public void refresh(Map<Integer, BookmarkItem> chainItems, Set<Recipe.RecipeId> collapsedRecipes) {
        HashMap<BookmarkItem, Integer> sortingChainItems = new HashMap<BookmarkItem, Integer>();
        for (Map.Entry<Integer, BookmarkItem> entry : chainItems.entrySet()) {
            sortingChainItems.put(entry.getValue(), entry.getKey());
        }
        this.itemToRecipe.clear();
        this.outputRecipes.clear();
        this.recipeInMiddle.clear();
        this.calculatedItems.clear();
        this.recipeRelations.clear();
        RecipeChainMath math = RecipeChainMath.of(new ArrayList<BookmarkItem>(chainItems.values()), collapsedRecipes).refresh();
        this.outputRecipes.addAll(math.outputRecipes.keySet());
        for (BookmarkItem bookmarkItem : math.preferredItems.values()) {
            if (bookmarkItem == null || bookmarkItem.recipeId == null) continue;
            this.recipeInMiddle.add(bookmarkItem.recipeId);
        }
        for (BookmarkItem bookmarkItem : math.initialItems) {
            this.calculatedItems.put((Integer)sortingChainItems.get(bookmarkItem), BookmarkChainItem.of(bookmarkItem, math.requiredAmount.getOrDefault(bookmarkItem, 0L), CalculatedType.INGREDIENT));
        }
        if (collapsedRecipes.isEmpty()) {
            for (BookmarkItem bookmarkItem : math.recipeResults) {
                this.generateResult(math, bookmarkItem, (Integer)sortingChainItems.get(bookmarkItem));
            }
            for (BookmarkItem bookmarkItem : math.recipeIngredients) {
                this.generateIngredient(math, bookmarkItem, (Integer)sortingChainItems.get(bookmarkItem));
            }
        } else {
            Set<Recipe.RecipeId> set = this.findTopLevelRecipes(math, collapsedRecipes);
            for (Recipe.RecipeId recipeId : collapsedRecipes) {
                this.recipeRelations.put(recipeId, this.getRecipeRelations(math, recipeId, set, new HashSet<Recipe.RecipeId>(Arrays.asList(recipeId))));
                this.generateCollapsedRecipe(math, recipeId, set, sortingChainItems);
                this.generateShadowItems(recipeId, chainItems.values(), sortingChainItems);
            }
            for (BookmarkItem item : math.recipeResults) {
                if (collapsedRecipes.contains(item.recipeId) || !set.contains(item.recipeId)) continue;
                this.generateResult(math, item, (Integer)sortingChainItems.get(item));
            }
            for (BookmarkItem item : math.recipeIngredients) {
                if (collapsedRecipes.contains(item.recipeId) || !set.contains(item.recipeId)) continue;
                this.generateIngredient(math, item, (Integer)sortingChainItems.get(item));
            }
        }
        for (Map.Entry<Integer, BookmarkItem> entry : chainItems.entrySet()) {
            int itemIndex = entry.getKey();
            if (itemIndex < 0 || !this.calculatedItems.containsKey(itemIndex)) continue;
            BookmarkItem item = entry.getValue();
            if (this.recipeInMiddle.contains(item.recipeId)) {
                this.calculatedItems.get(itemIndex).setRealAmount(item.amount);
                continue;
            }
            this.calculatedItems.get(itemIndex).setRealAmount(Math.max(item.factor, item.amount));
        }
    }

    private Set<Recipe.RecipeId> getRecipeRelations(RecipeChainMath math, Recipe.RecipeId recipeId, Set<Recipe.RecipeId> topLevelRecipes, Set<Recipe.RecipeId> recipes) {
        for (BookmarkItem item : math.recipeIngredients) {
            BookmarkItem prefItem;
            if (!item.recipeId.equals(recipeId) || (prefItem = math.preferredItems.get(item)) == null || topLevelRecipes.contains(prefItem.recipeId) || !recipes.add(prefItem.recipeId)) continue;
            this.getRecipeRelations(math, prefItem.recipeId, topLevelRecipes, recipes);
        }
        return recipes;
    }

    private void generateCollapsedRecipe(RecipeChainMath math, Recipe.RecipeId recipeId, Set<Recipe.RecipeId> topLevelRecipes, Map<BookmarkItem, Integer> sortingChainItems) {
        List<BookmarkChainItem> items = this.collectItems(math, recipeId, this.recipeRelations.get(recipeId), topLevelRecipes);
        for (BookmarkChainItem value : items) {
            int itemIndex = sortingChainItems.get(value.getItem());
            if (value.getItem().isIngredient || !recipeId.equals(value.getItem().recipeId)) {
                itemIndex *= -1;
            }
            if (!value.getItem().isIngredient && !math.outputRecipes.containsKey(value.getItem().recipeId)) {
                value.calculatedType = CalculatedType.REMAINDER;
            }
            this.itemToRecipe.put(itemIndex, recipeId);
            this.calculatedItems.put(itemIndex, value);
        }
    }

    private void generateShadowItems(Recipe.RecipeId recipeId, Iterable<BookmarkItem> chainItems, Map<BookmarkItem, Integer> sortingChainItems) {
        Set<Recipe.RecipeId> recipeRelations = this.recipeRelations.get(recipeId);
        ArrayList<BookmarkItem> subChainItems = new ArrayList<BookmarkItem>();
        for (BookmarkItem item : chainItems) {
            if (!recipeRelations.contains(item.recipeId)) continue;
            subChainItems.add(item.copyWithAmount(recipeId.equals(item.recipeId) ? item.amount : 0L));
        }
        RecipeChainMath math = RecipeChainMath.of(subChainItems, Collections.emptySet()).refresh();
        List<BookmarkChainItem> items = this.collectItems(math, recipeId, this.recipeRelations.get(recipeId), Collections.emptySet());
        for (BookmarkChainItem value : items) {
            int itemIndex = sortingChainItems.get(value.getItem());
            if (value.getItem().isIngredient || !recipeId.equals(value.getItem().recipeId)) {
                itemIndex *= -1;
            }
            if (!this.calculatedItems.containsKey(itemIndex)) continue;
            this.calculatedItems.get(itemIndex).setRealAmount(value.getShiftAmount());
        }
    }

    private List<BookmarkChainItem> collectItems(RecipeChainMath math, Recipe.RecipeId recipeId, Set<Recipe.RecipeId> recipeRelations, Set<Recipe.RecipeId> topLevelRecipes) {
        HashMap<String, BookmarkChainItem> items = new HashMap<String, BookmarkChainItem>();
        HashMap<Recipe.RecipeId, Long> multiplier = new HashMap<Recipe.RecipeId, Long>();
        for (Recipe.RecipeId relRecipeId : recipeRelations) {
            for (BookmarkItem item : math.recipeResults) {
                if (!item.recipeId.equals(relRecipeId)) continue;
                long amount = item.amount - math.requiredAmount.getOrDefault(item, 0L);
                if (item.recipeId.equals(recipeId)) {
                    multiplier.put(item.recipeId, item.getMultiplier());
                    items.computeIfAbsent(StackInfo.getItemStackGUID(item.itemStack), is -> BookmarkChainItem.of(item, 0L, 0L, CalculatedType.RESULT)).append(amount, item.amount);
                    continue;
                }
                if (amount <= 0L) continue;
                items.computeIfAbsent(StackInfo.getItemStackGUID(item.itemStack), is -> BookmarkChainItem.of(item, 0L, 0L, CalculatedType.RESULT)).append(amount, amount);
            }
            for (BookmarkItem item : math.recipeIngredients) {
                long refAmount;
                if (!item.recipeId.equals(relRecipeId)) continue;
                BookmarkItem prefItem = math.preferredItems.get(item);
                long amount = math.requiredAmount.containsKey(prefItem) ? 0L : math.requiredAmount.getOrDefault(item, item.amount);
                long l = refAmount = prefItem != null && !topLevelRecipes.contains(prefItem.recipeId) ? math.requiredAmount.getOrDefault(prefItem, 0L) : 0L;
                if (amount == 0L && (item.amount <= refAmount || !math.requiredAmount.containsKey(prefItem)) && (!recipeId.equals(item.recipeId) || (Long)multiplier.get(recipeId) != 0L)) continue;
                items.computeIfAbsent(StackInfo.getItemStackGUID(item.itemStack), is -> BookmarkChainItem.of(item, 0L, 0L, CalculatedType.INGREDIENT)).append(amount, item.amount - refAmount);
            }
        }
        return new ArrayList<BookmarkChainItem>(items.values());
    }

    private void generateResult(RecipeChainMath math, BookmarkItem item, int itemIndex) {
        long amount = item.amount - math.requiredAmount.getOrDefault(item, 0L);
        CalculatedType calculatedType = math.outputRecipes.containsKey(item.recipeId) ? CalculatedType.RESULT : CalculatedType.REMAINDER;
        this.calculatedItems.put(itemIndex, BookmarkChainItem.of(item, amount, calculatedType));
    }

    private void generateIngredient(RecipeChainMath math, BookmarkItem item, int itemIndex) {
        BookmarkItem prefItem = math.preferredItems.get(item);
        long amount = math.requiredAmount.containsKey(prefItem) ? 0L : math.requiredAmount.getOrDefault(item, item.amount);
        this.calculatedItems.put(itemIndex, BookmarkChainItem.of(item, amount, CalculatedType.INGREDIENT));
    }

    private Set<Recipe.RecipeId> findTopLevelRecipes(RecipeChainMath math, Set<Recipe.RecipeId> collapsedRecipes) {
        HashSet<Recipe.RecipeId> result = new HashSet<Recipe.RecipeId>(math.outputRecipes.keySet());
        for (BookmarkItem item : math.recipeResults) {
            if (result.contains(item.recipeId)) continue;
            Set<Recipe.RecipeId> parents = this.getRecipeParents(math, item.recipeId, new HashSet<Recipe.RecipeId>(), new HashSet<Recipe.RecipeId>(Arrays.asList(item.recipeId)));
            if (parents.size() == 1) {
                if (!parents.stream().noneMatch(collapsedRecipes::contains)) continue;
            }
            result.add(item.recipeId);
        }
        return result;
    }

    private Set<Recipe.RecipeId> getRecipeParents(RecipeChainMath math, Recipe.RecipeId recipeId, Set<Recipe.RecipeId> parents, Set<Recipe.RecipeId> visited) {
        Set recipeIds = math.preferredItems.entrySet().stream().filter(entry -> entry.getValue() != null && recipeId.equals(((BookmarkItem)entry.getValue()).recipeId) && !visited.contains(((BookmarkItem)entry.getKey()).recipeId)).map(entry -> ((BookmarkItem)entry.getKey()).recipeId).collect(Collectors.toSet());
        visited.addAll(recipeIds);
        if (recipeIds.isEmpty()) {
            parents.add(recipeId);
        } else {
            for (Recipe.RecipeId ingrRecipeId : recipeIds) {
                if (math.outputRecipes.containsKey(ingrRecipeId)) {
                    parents.add(ingrRecipeId);
                    continue;
                }
                this.getRecipeParents(math, ingrRecipeId, parents, visited);
            }
        }
        return parents;
    }

    public static enum CalculatedType {
        INGREDIENT,
        RESULT,
        REMAINDER;


        public int toInt() {
            switch (this) {
                case RESULT: {
                    return 0;
                }
                case REMAINDER: {
                    return 1;
                }
                case INGREDIENT: {
                    return 2;
                }
            }
            return -1;
        }
    }

    public static class BookmarkChainItem {
        private final BookmarkItem item;
        private long realAmount = 0L;
        private long shiftAmount = 0L;
        private long calculatedAmount = 0L;
        public CalculatedType calculatedType;

        protected BookmarkChainItem(BookmarkItem item, long shiftItem, long calculatedItem, CalculatedType calculatedType) {
            this.item = item.copy();
            this.shiftAmount = shiftItem;
            this.calculatedAmount = calculatedItem;
            this.calculatedType = calculatedType;
        }

        public static BookmarkChainItem of(BookmarkItem item, long shiftItem, long calculatedAmount, CalculatedType calculatedType) {
            return new BookmarkChainItem(item, shiftItem, calculatedAmount, calculatedType);
        }

        public static BookmarkChainItem of(BookmarkItem item, long shiftItem, CalculatedType calculatedType) {
            return new BookmarkChainItem(item, shiftItem, item.amount, calculatedType);
        }

        public static BookmarkChainItem of(BookmarkItem item) {
            return new BookmarkChainItem(item, item.amount, item.amount, item.isIngredient ? CalculatedType.INGREDIENT : CalculatedType.RESULT);
        }

        public ItemStack getItemStack(long amount) {
            return this.item.getItemStack(amount);
        }

        public void setRealAmount(long amount) {
            this.realAmount = amount;
        }

        public long getRealAmount() {
            return this.realAmount;
        }

        public long getShiftAmount() {
            return this.shiftAmount;
        }

        public long getCalculatedAmount() {
            return this.calculatedAmount;
        }

        public BookmarkItem getItem() {
            return this.item;
        }

        public void append(long amount, long calculatedAmount) {
            this.shiftAmount += amount;
            this.calculatedAmount += calculatedAmount;
            this.item.amount = this.calculatedAmount;
        }
    }
}

