/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.Image;
import codechicken.nei.ItemPanels;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIActions;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.VisiblityData;
import codechicken.nei.api.LayoutStyle;
import codechicken.nei.drawable.DrawableBuilder;
import net.minecraft.client.gui.inventory.GuiContainer;
import org.lwjgl.opengl.GL11;

public class LayoutStyleMinecraft
extends LayoutStyle {
    protected static final int BUTTON_SIZE = 20;
    protected static final int MARGIN = 2;
    public int buttonCount;
    public int leftSize;
    public int numButtons;

    @Override
    public String getName() {
        return "minecraft";
    }

    @Override
    public void init() {
        LayoutManager.delete.icon = new Image(144, 12, 12, 12);
        LayoutManager.rain.icon = new Image(120, 12, 12, 12);
        LayoutManager.gamemode.icons[0] = new Image(132, 12, 12, 12);
        LayoutManager.gamemode.icons[1] = new Image(156, 12, 12, 12);
        LayoutManager.gamemode.icons[2] = new Image(168, 12, 12, 12);
        LayoutManager.magnet.icon = new Image(180, 24, 12, 12);
        LayoutManager.timeButtons[0].icon = new Image(132, 24, 12, 12);
        LayoutManager.timeButtons[1].icon = new Image(120, 24, 12, 12);
        LayoutManager.timeButtons[2].icon = new Image(144, 24, 12, 12);
        LayoutManager.timeButtons[3].icon = new Image(156, 24, 12, 12);
        LayoutManager.heal.icon = new Image(168, 24, 12, 12);
        LayoutManager.itemPresenceOverlays[0] = new DrawableBuilder("nei:textures/nei_tabbed_sprites.png", 0, 40, 8, 8).build();
        LayoutManager.itemPresenceOverlays[1] = new DrawableBuilder("nei:textures/nei_tabbed_sprites.png", 8, 40, 8, 8).build();
    }

    @Override
    public void reset() {
        this.buttonCount = 0;
    }

    @Override
    public void layout(GuiContainer gui, VisiblityData visiblity) {
        this.reset();
        this.leftSize = ItemPanels.bookmarkPanel.getWidth(gui);
        this.numButtons = Math.max(this.leftSize / 20, 1);
        LayoutManager.delete.state = 4;
        if (NEIController.getDeleteMode()) {
            LayoutManager.delete.state |= 1;
        } else if (!visiblity.enableDeleteMode) {
            LayoutManager.delete.state |= 2;
        }
        LayoutManager.rain.state = 4;
        if (NEIClientConfig.disabledActions.contains("rain")) {
            LayoutManager.rain.state |= 2;
        } else if (NEIClientUtils.isRaining()) {
            LayoutManager.rain.state |= 1;
        }
        LayoutManager.gamemode.state = 4;
        if (NEIClientUtils.getGamemode() != 0) {
            LayoutManager.gamemode.state |= 1;
            LayoutManager.gamemode.index = NEIClientUtils.getGamemode() - 1;
        } else if (NEIClientUtils.isValidGamemode("creative")) {
            LayoutManager.gamemode.index = 0;
        } else if (NEIClientUtils.isValidGamemode("creative+")) {
            LayoutManager.gamemode.index = 1;
        } else if (NEIClientUtils.isValidGamemode("adventure")) {
            LayoutManager.gamemode.index = 2;
        }
        LayoutManager.bookmarksButton.index = NEIClientConfig.isBookmarkPanelHidden() ? 0 : 1;
        LayoutManager.options.index = NEIClientConfig.getCheatMode();
        LayoutManager.magnet.state = 4 | (NEIClientConfig.getMagnetMode() ? 1 : 0);
        if (NEIClientConfig.canPerformAction("delete")) {
            this.layoutButton(LayoutManager.delete);
        }
        if (NEIClientConfig.canPerformAction("rain")) {
            this.layoutButton(LayoutManager.rain);
        }
        if (NEIClientUtils.isValidGamemode("creative") || NEIClientUtils.isValidGamemode("creative+") || NEIClientUtils.isValidGamemode("adventure")) {
            this.layoutButton(LayoutManager.gamemode);
        }
        if (NEIClientConfig.canPerformAction("magnet")) {
            this.layoutButton(LayoutManager.magnet);
        }
        if (NEIClientConfig.canPerformAction("time")) {
            for (int i = 0; i < 4; ++i) {
                LayoutManager.timeButtons[i].state = NEIClientConfig.disabledActions.contains(NEIActions.timeZones[i]) ? 2 : 0;
                this.layoutButton(LayoutManager.timeButtons[i]);
            }
        }
        if (NEIClientConfig.canPerformAction("heal")) {
            this.layoutButton(LayoutManager.heal);
        }
        this.layoutFooter(gui, visiblity);
        LayoutManager.itemPanel.resize(gui);
        LayoutManager.bookmarkPanel.resize(gui);
        LayoutManager.itemZoom.resize(gui);
    }

    protected void layoutFooter(GuiContainer gui, VisiblityData visiblity) {
        LayoutManager.options.x = 2;
        LayoutManager.options.y = gui.field_146295_m - 20 - 2;
        LayoutManager.options.h = 20;
        LayoutManager.options.w = 20;
        LayoutManager.bookmarksButton.x = LayoutManager.options.x + LayoutManager.options.w + 2;
        LayoutManager.bookmarksButton.y = gui.field_146295_m - 20 - 2;
        LayoutManager.bookmarksButton.h = 20;
        LayoutManager.bookmarksButton.w = 20;
        Rectangle4i searchArea = this.getSearchFieldArea(gui);
        Rectangle4i quantityArea = this.getQuantityFieldArea(visiblity);
        LayoutManager.searchField.x = searchArea.x;
        LayoutManager.searchField.y = searchArea.y;
        LayoutManager.searchField.w = searchArea.w;
        LayoutManager.searchField.h = searchArea.h;
        if (!NEIClientConfig.subsetWidgetOnTop() && visiblity.showSubsetDropdown) {
            LayoutManager.dropDown.x = searchArea.x;
            LayoutManager.dropDown.y = searchArea.y;
            LayoutManager.dropDown.w = 20;
            LayoutManager.dropDown.h = 20;
            LayoutManager.searchField.x += 20;
            LayoutManager.searchField.w -= 20;
        } else {
            LayoutManager.dropDown.h = 16;
            LayoutManager.dropDown.w = 150;
            LayoutManager.dropDown.y = 2;
            LayoutManager.dropDown.x = (gui.field_146294_l - LayoutManager.dropDown.w) / 2;
        }
        if (quantityArea.w == ItemPanels.itemPanel.w) {
            LayoutManager.less.w = 20;
            LayoutManager.more.w = 20;
            LayoutManager.less.h = LayoutManager.quantity.h = quantityArea.h;
            LayoutManager.more.h = LayoutManager.quantity.h;
            LayoutManager.less.y = LayoutManager.quantity.y = quantityArea.y;
            LayoutManager.more.y = LayoutManager.quantity.y;
            LayoutManager.less.x = quantityArea.x;
            LayoutManager.more.x = quantityArea.x2() - 20;
            LayoutManager.quantity.x = LayoutManager.less.x + LayoutManager.less.w + 1;
            LayoutManager.quantity.w = LayoutManager.more.x - LayoutManager.quantity.x - 1;
        } else {
            LayoutManager.quantity.x = quantityArea.x;
            LayoutManager.quantity.w = quantityArea.w - 18;
            LayoutManager.quantity.y = LayoutManager.more.y = quantityArea.y;
            LayoutManager.quantity.h = quantityArea.h;
            LayoutManager.less.w = 18;
            LayoutManager.more.w = 18;
            LayoutManager.more.x = LayoutManager.less.x = LayoutManager.quantity.x + LayoutManager.quantity.w;
            LayoutManager.more.h = LayoutManager.less.h = LayoutManager.quantity.h / 2;
            LayoutManager.less.y = LayoutManager.more.y + LayoutManager.more.h;
        }
    }

    private Rectangle4i getSearchFieldArea(GuiContainer gui) {
        Rectangle4i area = new Rectangle4i(0, 0, 0, 20);
        if (NEIClientConfig.isSearchWidgetCentered()) {
            area.w = Math.min(gui.field_146999_f, 176) - 4;
            area.x = (gui.field_146294_l - area.w) / 2;
            area.y = gui.field_146295_m - 20 - 2;
        } else if (NEIClientConfig.showItemQuantityWidget()) {
            area.w = ItemPanels.itemPanel.w - (int)Math.max(50.0f, (float)ItemPanels.itemPanel.w * 0.3f) - 1;
            area.x = ItemPanels.itemPanel.x;
            area.y = ItemPanels.itemPanel.y + ItemPanels.itemPanel.h - 20;
        } else {
            area.w = ItemPanels.itemPanel.w;
            area.x = ItemPanels.itemPanel.x;
            area.y = ItemPanels.itemPanel.y + ItemPanels.itemPanel.h - 20;
        }
        return area;
    }

    private Rectangle4i getQuantityFieldArea(VisiblityData visiblity) {
        Rectangle4i area = new Rectangle4i(0, 0, 0, 20);
        if (!visiblity.showSearchSection || NEIClientConfig.isSearchWidgetCentered()) {
            area.w = ItemPanels.itemPanel.w;
            area.x = ItemPanels.itemPanel.x;
        } else {
            area.w = (int)Math.max(50.0f, (float)ItemPanels.itemPanel.w * 0.3f);
            area.x = ItemPanels.itemPanel.x + ItemPanels.itemPanel.w - area.w;
        }
        area.y = ItemPanels.itemPanel.y + ItemPanels.itemPanel.h - 20;
        return area;
    }

    public void layoutButton(Button button) {
        button.h = 17;
        button.w = button.contentWidth() + 6;
        button.x = 2 + this.buttonCount % this.numButtons * (button.w + 2);
        button.y = 2 + this.buttonCount / this.numButtons * (button.h + 2);
        ++this.buttonCount;
    }

    @Override
    public void drawButton(Button b, int mousex, int mousey) {
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int tex = (b.state & 3) == 2 ? 0 : ((b.state & 4) == 0 && b.contains(mousex, mousey) || (b.state & 3) == 1 ? 2 : 1);
        LayoutManager.drawButtonBackground(b.x, b.y, b.w, b.h, true, tex);
        Image icon = b.getRenderIcon();
        if (icon == null) {
            int colour = tex == 2 ? 0xFFFFA0 : (tex == 0 ? 0x601010 : 0xE0E0E0);
            GuiDraw.drawStringC((String)b.getRenderLabel(), (int)(b.x + b.w / 2), (int)(b.y + (b.h - 8) / 2), (int)colour);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int iconX = b.x + (b.w - icon.width) / 2;
            int iconY = b.y + (b.h - icon.height) / 2;
            LayoutManager.drawIcon(iconX, iconY, icon);
        }
    }

    @Override
    public void drawSubsetTag(String text, int x, int y, int w, int h, int state, boolean mouseover) {
        if (state == 1) {
            GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        LayoutManager.drawButtonBackground(x, y, w, h, false, state == 0 ? 0 : 1);
        if (text != null) {
            GuiDraw.drawStringC((String)text, (int)x, (int)y, (int)w, (int)h, (int)(mouseover ? -96 : (state == 2 ? -2039584 : -6250336)));
        }
    }
}

