/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.search;

import codechicken.nei.ItemList;
import codechicken.nei.ItemStackMap;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.guihook.GuiContainerManager;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class TooltipFilter
implements ItemFilter {
    private static final ItemStackMap<String> itemSearchNames = new ItemStackMap();
    private static final ReentrantLock lock = new ReentrantLock();
    private final Pattern pattern;

    public TooltipFilter(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean matches(ItemStack itemStack) {
        return this.pattern.matcher(TooltipFilter.getSearchTooltip(itemStack)).find();
    }

    public static void populateSearchMap() {
        itemSearchNames.clear();
        new Thread(() -> ItemList.items.parallelStream().forEach(TooltipFilter::getSearchTooltip), "NEI populate Tooltip Filter").start();
    }

    protected static String getSearchTooltip(ItemStack stack) {
        lock.lock();
        try {
            String tooltip = itemSearchNames.get(stack);
            if (tooltip == null) {
                tooltip = TooltipFilter.getTooltip(stack.func_77946_l());
                itemSearchNames.put(stack, tooltip);
            }
            String string = tooltip;
            return string;
        }
        catch (Throwable th) {
            th.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    private static String getTooltip(ItemStack itemstack) {
        List<String> list = GuiContainerManager.itemDisplayNameMultiline(itemstack, null, true);
        return EnumChatFormatting.func_110646_a((String)String.join((CharSequence)"\n", list.subList(1, list.size())));
    }
}

