/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemPanels;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.BookmarkRecipeId;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.RecipeHandlerQuery;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.recipe.stackinfo.GTFluidStackStringifyHandler;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;

public class GuiCraftingRecipe
extends GuiRecipe<ICraftingHandler> {
    public static ArrayList<ICraftingHandler> craftinghandlers = new ArrayList();
    public static ArrayList<ICraftingHandler> serialCraftingHandlers = new ArrayList();

    public static boolean openRecipeGui(String outputId, Object ... results) {
        return GuiCraftingRecipe.createRecipeGui(outputId, true, results) != null;
    }

    public static GuiRecipe<?> createRecipeGui(String outputId, boolean open, Object ... results) {
        BookmarkRecipeId recipeId;
        Minecraft mc = NEIClientUtils.mc();
        if ("item".equals(outputId)) {
            results = Arrays.asList(results).stream().map(rslt -> GuiCraftingRecipe.normalizeItemStack((ItemStack)rslt)).toArray();
            recipeId = GuiCraftingRecipe.getRecipeId(mc.field_71462_r, (ItemStack)results[0]);
        } else {
            recipeId = "recipeId".equals(outputId) ? (BookmarkRecipeId)results[1] : GuiCraftingRecipe.getCurrentRecipe(mc.field_71462_r);
        }
        ArrayList<ICraftingHandler> handlers = GuiCraftingRecipe.getCraftingHandlers(outputId, results);
        if (!handlers.isEmpty()) {
            GuiCraftingRecipe gui = new GuiCraftingRecipe(handlers, "recipeId".equals(outputId));
            if (open) {
                mc.func_147108_a((GuiScreen)gui);
            }
            gui.openTargetRecipe(recipeId);
            return gui;
        }
        return null;
    }

    public static boolean overlayRecipe(ItemStack stack, BookmarkRecipeId recipeId, Boolean shift) {
        GuiCraftingRecipe gui;
        int recipe;
        if (stack == null || recipeId == null) {
            return false;
        }
        ArrayList<ICraftingHandler> handlers = GuiCraftingRecipe.getCraftingHandlers("recipeId", stack, recipeId);
        if (!handlers.isEmpty() && (recipe = (gui = new GuiCraftingRecipe(handlers, true)).openTargetRecipe(recipeId)) != -1) {
            gui.overlayRecipe(recipe, shift);
            return true;
        }
        return false;
    }

    public static ArrayList<ICraftingHandler> getCraftingHandlers(String outputId, Object ... results) {
        Function<ICraftingHandler, ICraftingHandler> recipeHandlerFunction;
        ArrayList<ICraftingHandler> craftinghandlers = GuiCraftingRecipe.craftinghandlers;
        ArrayList<ICraftingHandler> serialCraftingHandlers = GuiCraftingRecipe.serialCraftingHandlers;
        if ("recipeId".equals(outputId)) {
            ItemStack stack = (ItemStack)results[0];
            BookmarkRecipeId recipeId = (BookmarkRecipeId)results[1];
            craftinghandlers = GuiCraftingRecipe.filterByHandlerName(craftinghandlers, recipeId.handlerName);
            serialCraftingHandlers = GuiCraftingRecipe.filterByHandlerName(serialCraftingHandlers, recipeId.handlerName);
            recipeHandlerFunction = h -> h.getRecipeHandler("item", stack);
        } else {
            recipeHandlerFunction = h -> h.getRecipeHandler(outputId, results);
        }
        RecipeHandlerQuery<ICraftingHandler> recipeQuery = new RecipeHandlerQuery<ICraftingHandler>(recipeHandlerFunction, craftinghandlers, serialCraftingHandlers, "Error while looking up crafting recipe", "outputId: " + outputId, "results: " + Arrays.toString(results));
        return recipeQuery.runWithProfiling("recipe.concurrent.crafting");
    }

    private static ArrayList<ICraftingHandler> filterByHandlerName(ArrayList<ICraftingHandler> craftinghandlers, String handlerName) {
        return craftinghandlers.stream().filter(h -> GuiCraftingRecipe.getHandlerName(h).equals(handlerName)).collect(Collectors.toCollection(ArrayList::new));
    }

    private static String getHandlerName(ICraftingHandler handler) {
        return GuiRecipeTab.getHandlerInfo(handler).getHandlerName();
    }

    private static ItemStack normalizeItemStack(ItemStack stack) {
        GTFluidStackStringifyHandler.replaceAE2FCFluidDrop = true;
        stack = StackInfo.loadFromNBT(StackInfo.itemStackToNBT(stack));
        GTFluidStackStringifyHandler.replaceAE2FCFluidDrop = false;
        return stack;
    }

    protected static BookmarkRecipeId getRecipeId(GuiScreen gui, ItemStack stackover) {
        if (gui instanceof GuiRecipe) {
            List<PositionedStack> ingredients = ((GuiRecipe)gui).getFocusedRecipeIngredients();
            String handlerName = ((GuiRecipe)gui).getHandlerName();
            if (ingredients != null && !ingredients.isEmpty()) {
                return new BookmarkRecipeId(handlerName, ingredients);
            }
        }
        Point mouseover = GuiDraw.getMousePosition();
        ItemPanel.ItemPanelSlot panelSlot = ItemPanels.bookmarkPanel.getSlotMouseOver(mouseover.x, mouseover.y);
        if (panelSlot != null) {
            return ItemPanels.bookmarkPanel.getBookmarkRecipeId(panelSlot.slotIndex);
        }
        return ItemPanels.bookmarkPanel.getBookmarkRecipeId(stackover);
    }

    private GuiCraftingRecipe(ArrayList<ICraftingHandler> handlers, boolean limitToOneRecipe) {
        super(NEIClientUtils.mc().field_71462_r);
        this.limitToOneRecipe = limitToOneRecipe;
        this.currenthandlers = handlers;
    }

    public static void registerRecipeHandler(ICraftingHandler handler) {
        String handlerId = handler.getHandlerId();
        if (craftinghandlers.stream().anyMatch(h -> h.getHandlerId().equals(handlerId)) || serialCraftingHandlers.stream().anyMatch(h -> h.getHandlerId().equals(handlerId))) {
            return;
        }
        if (NEIClientConfig.serialHandlers.contains(handlerId)) {
            serialCraftingHandlers.add(handler);
        } else {
            craftinghandlers.add(handler);
        }
    }

    @Override
    public ArrayList<ICraftingHandler> getCurrentRecipeHandlers() {
        return this.currenthandlers;
    }
}

