/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CCUpdateChecker;
import codechicken.core.ClassDiscoverer;
import codechicken.core.ClientUtils;
import codechicken.core.CommonUtils;
import codechicken.lib.config.ConfigFile;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.ConfigTagParent;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemSorter;
import codechicken.nei.ItemStackSet;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIActions;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.NEIModContainer;
import codechicken.nei.PresetsWidget;
import codechicken.nei.SubsetWidget;
import codechicken.nei.api.API;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.api.NEIInfo;
import codechicken.nei.config.ConfigSet;
import codechicken.nei.config.GuiHighlightTips;
import codechicken.nei.config.GuiNEIOptionList;
import codechicken.nei.config.GuiOptionList;
import codechicken.nei.config.GuiPanelSettings;
import codechicken.nei.config.OptionCycled;
import codechicken.nei.config.OptionGamemodes;
import codechicken.nei.config.OptionList;
import codechicken.nei.config.OptionOpenGui;
import codechicken.nei.config.OptionTextField;
import codechicken.nei.config.OptionToggleButton;
import codechicken.nei.config.OptionToggleButtonBoubs;
import codechicken.nei.config.OptionUtilities;
import codechicken.nei.event.NEIConfigsLoadedEvent;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.obfuscator.ObfuscationRun;
import com.google.common.base.Objects;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.SaveFormatComparator;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

public class NEIClientConfig {
    private static boolean configLoaded;
    private static boolean enabledOverride;
    private static String worldPath;
    public static Logger logger;
    public static File configDir;
    public static ConfigSet global;
    public static ConfigSet world;
    public static final File handlerFile;
    public static final File catalystFile;
    public static final File serialHandlersFile;
    public static final File heightHackHandlersFile;
    public static final File handlerOrderingFile;
    @Deprecated
    public static File bookmarkFile;
    public static HashSet<String> serialHandlers;
    public static HashSet<Pattern> heightHackHandlerRegex;
    public static HashMap<String, Integer> handlerOrdering;
    public static final Function<IRecipeHandler, String> HANDLER_ID_FUNCTION;
    public static final Comparator<IRecipeHandler> HANDLER_COMPARATOR;
    public static ItemStack[] creativeInv;
    public static boolean hasSMPCounterpart;
    public static HashSet<String> permissableActions;
    public static HashSet<String> disabledActions;
    public static HashSet<String> enabledActions;
    public static ItemStackSet bannedBlocks;

    public static int getHandlerOrder(IRecipeHandler handler) {
        if (handlerOrdering.get(handler.getOverlayIdentifier()) != null) {
            return handlerOrdering.get(handler.getOverlayIdentifier());
        }
        if (handlerOrdering.get(handler.getHandlerId()) != null) {
            return handlerOrdering.get(handler.getHandlerId());
        }
        return 0;
    }

    private static void setDefaults() {
        ConfigTagParent tag = NEIClientConfig.global.config;
        tag.setComment("Main configuration of NEI.\nMost of these options can be changed ingame.\nDeleting any element will restore it to it's default value");
        tag.getTag("command").useBraces().setComment("Change these options if you have a different mod installed on the server that handles the commands differently, Eg. Bukkit Essentials");
        tag.setNewLineMode(1);
        tag.getTag("inventory.widgetsenabled").getBooleanValue(true);
        API.addOption(new OptionToggleButton("inventory.widgetsenabled"));
        tag.getTag("inventory.hidden").getBooleanValue(false);
        tag.getTag("inventory.cheatmode").getIntValue(2);
        tag.getTag("inventory.lockmode").setComment("For those who can't help themselves.\nSet this to a mode and you will be unable to change it ingame").getIntValue(-1);
        API.addOption(new OptionCycled("inventory.cheatmode", 3){

            @Override
            public boolean optionValid(int index) {
                return NEIClientConfig.getLockedMode() == -1 || NEIClientConfig.getLockedMode() == index && NEIInfo.isValidMode(index);
            }
        });
        NEIClientConfig.checkCheatMode();
        tag.getTag("inventory.utilities").setDefaultValue("delete, magnet");
        API.addOption(new OptionUtilities("inventory.utilities"));
        tag.getTag("inventory.gamemodes").setDefaultValue("creative, creative+, adventure");
        API.addOption(new OptionGamemodes("inventory.gamemodes"));
        ItemSorter.initConfig(tag);
        tag.getTag("inventory.itemIDs").getIntValue(1);
        API.addOption(new OptionCycled("inventory.itemIDs", 3, true));
        tag.getTag("inventory.searchmode").getIntValue(1);
        API.addOption(new OptionCycled("inventory.searchmode", 3, true));
        tag.getTag("world.highlight_tips").getBooleanValue(false);
        tag.getTag("world.highlight_tips.x").getIntValue(5000);
        tag.getTag("world.highlight_tips.y").getIntValue(100);
        API.addOption(new OptionOpenGui("world.highlight_tips", GuiHighlightTips.class));
        tag.getTag("world.panels.bookmarks.left").getIntValue(0);
        tag.getTag("world.panels.bookmarks.right").getIntValue(0);
        tag.getTag("world.panels.bookmarks.top").getIntValue(0);
        tag.getTag("world.panels.bookmarks.bottom").getIntValue(0);
        tag.getTag("world.panels.items.left").getIntValue(0);
        tag.getTag("world.panels.items.right").getIntValue(0);
        tag.getTag("world.panels.items.top").getIntValue(0);
        tag.getTag("world.panels.items.bottom").getIntValue(0);
        API.addOption(new OptionOpenGui("world.panels", GuiPanelSettings.class));
        tag.getTag("inventory.profileRecipes").getBooleanValue(false);
        API.addOption(new OptionToggleButton("inventory.profileRecipes", true));
        tag.getTag("inventory.disableMouseScrollTransfer").getBooleanValue(false);
        API.addOption(new OptionToggleButton("inventory.disableMouseScrollTransfer", true));
        tag.getTag("inventory.invertMouseScrollTransfer").getBooleanValue(false);
        API.addOption(new OptionToggleButton("inventory.invertMouseScrollTransfer", true){

            @Override
            public boolean isEnabled() {
                return NEIClientConfig.isMouseScrollTransferEnabled();
            }
        });
        tag.getTag("inventory.cacheItemRendering").getBooleanValue(false);
        API.addOption(new OptionToggleButton("inventory.cacheItemRendering", true));
        tag.getTag("itemLoadingTimeout").getIntValue(500);
        tag.getTag("command.creative").setDefaultValue("/gamemode {0} {1}");
        API.addOption(new OptionTextField("command.creative"));
        tag.getTag("command.item").setDefaultValue("/give {0} {1} {2} {3} {4}");
        API.addOption(new OptionTextField("command.item"));
        tag.getTag("command.time").setDefaultValue("/time set {0}");
        API.addOption(new OptionTextField("command.time"));
        tag.getTag("command.rain").setDefaultValue("/toggledownfall");
        API.addOption(new OptionTextField("command.rain"));
        tag.getTag("command.heal").setDefaultValue("");
        API.addOption(new OptionTextField("command.heal"));
        tag.getTag("inventory.worldSpecificBookmarks").setComment("Global or world specific bookmarks").getBooleanValue(false);
        API.addOption(new OptionToggleButton("inventory.worldSpecificBookmarks", true){

            @Override
            public boolean onClick(int button) {
                super.onClick(button);
                NEIClientConfig.initBookmarkFile(worldPath);
                return true;
            }
        });
        tag.getTag("inventory.worldSpecificPresets").setComment("Global or world specific presets").getBooleanValue(false);
        API.addOption(new OptionToggleButton("inventory.worldSpecificPresets", true){

            @Override
            public boolean onClick(int button) {
                super.onClick(button);
                NEIClientConfig.initPresetsFile(worldPath);
                return true;
            }
        });
        tag.getTag("inventory.bookmarksEnabled").setComment("Enable/disable bookmarks").getBooleanValue(true);
        API.addOption(new OptionToggleButton("inventory.bookmarksEnabled", true));
        tag.getTag("inventory.useNBTInBookmarks").setComment("Use NBT in Bookmarks").getBooleanValue(true);
        API.addOption(new OptionToggleButton("inventory.useNBTInBookmarks", true));
        tag.getTag("inventory.bookmarksAnimationEnabled").setComment("REI Style Animation in Bookmarks").getBooleanValue(true);
        API.addOption(new OptionToggleButton("inventory.bookmarksAnimationEnabled", true));
        tag.getTag("inventory.showRecipeMarker").setComment("Show Recipe Marker").getBooleanValue(false);
        API.addOption(new OptionToggleButton("inventory.showRecipeMarker", true));
        tag.getTag("inventory.showItemQuantityWidget").setComment("Show Item Quantity Widget").getBooleanValue(true);
        API.addOption(new OptionToggleButton("inventory.showItemQuantityWidget", true));
        tag.getTag("inventory.jei_style_tabs").setComment("Enable/disable JEI Style Tabs").getBooleanValue(true);
        API.addOption(new OptionToggleButtonBoubs("inventory.jei_style_tabs", true));
        tag.getTag("inventory.jei_style_item_presence_overlay").setComment("Enable/disable JEI Style item presence overlay on ?-hover").getBooleanValue(true);
        API.addOption(new OptionToggleButton("inventory.jei_style_item_presence_overlay", true));
        tag.getTag("inventory.jei_style_recipe_catalyst").setComment("Enable/disable JEI Style Recipe Catalysts").getBooleanValue(true);
        API.addOption(new OptionToggleButton("inventory.jei_style_recipe_catalyst", true));
        tag.getTag("inventory.creative_tab_style").setComment("Creative or JEI style tabs").getBooleanValue(false);
        API.addOption(new OptionToggleButton("inventory.creative_tab_style", true));
        tag.getTag("inventory.ignore_potion_overlap").setComment("Ignore overlap with potion effect HUD").getBooleanValue(false);
        API.addOption(new OptionToggleButton("inventory.ignore_potion_overlap", true));
        tag.getTag("inventory.optimize_gui_overlap_computation").setComment("Optimize computation for GUI overlap").getBooleanValue(false);
        API.addOption(new OptionToggleButton("inventory.optimize_gui_overlap_computation", true));
        tag.getTag("inventory.jei_style_cycled_ingredients").setComment("JEI styled cycled ingredients").getBooleanValue(true);
        API.addOption(new OptionToggleButton("inventory.jei_style_cycled_ingredients", true));
        tag.getTag("inventory.shift_overlay_recipe").setComment("Require holding shift to move items when overlaying recipe").getBooleanValue(true);
        API.addOption(new OptionToggleButton("inventory.shift_overlay_recipe", true));
        tag.getTag("tools.handler_load_from_config").setComment("ADVANCED: Load handlers from config").getBooleanValue(false);
        API.addOption(new OptionToggleButton("tools.handler_load_from_config", true){

            @Override
            public boolean onClick(int button) {
                super.onClick(button);
                GuiRecipeTab.loadHandlerInfo();
                return true;
            }
        });
        tag.getTag("tools.catalyst_load_from_config").setComment("ADVANCED: Load catalysts from config").getBooleanValue(false);
        API.addOption(new OptionToggleButton("tools.catalyst_load_from_config", true){

            @Override
            public boolean onClick(int button) {
                super.onClick(button);
                RecipeCatalysts.loadCatalystInfo();
                return true;
            }
        });
        NEIClientConfig.setDefaultKeyBindings();
    }

    private static void linkOptionList() {
        OptionList.setOptionList(new OptionList("nei.options"){

            @Override
            public ConfigSet globalConfigSet() {
                return global;
            }

            @Override
            public ConfigSet worldConfigSet() {
                return world;
            }

            @Override
            public OptionList configBase() {
                return this;
            }

            @Override
            public GuiOptionList getGui(GuiScreen parent, OptionList list, boolean world) {
                return new GuiNEIOptionList(parent, list, world);
            }
        });
    }

    private static void setDefaultKeyBindings() {
        API.addHashBind("gui.recipe", 19);
        API.addHashBind("gui.usage", 22);
        API.addKeyBind("gui.back", 14);
        API.addHashBind("gui.enchant", 45);
        API.addHashBind("gui.potion", 25);
        API.addKeyBind("gui.prev", 201);
        API.addKeyBind("gui.next", 209);
        API.addKeyBind("gui.prev_machine", 200);
        API.addKeyBind("gui.next_machine", 208);
        API.addKeyBind("gui.prev_recipe", 203);
        API.addKeyBind("gui.next_recipe", 205);
        API.addHashBind("gui.hide", 24);
        API.addHashBind("gui.search", 33);
        API.addHashBind("gui.bookmark", 30);
        API.addHashBind("gui.bookmark_recipe", 67108894);
        API.addHashBind("gui.bookmark_count", 33554462);
        API.addHashBind("gui.bookmark_recipe_count", 100663326);
        API.addHashBind("gui.overlay", 31);
        API.addHashBind("gui.overlay_use", 67108895);
        API.addHashBind("gui.overlay_hide", 33554463);
        API.addHashBind("gui.hide_bookmarks", 48);
        API.addKeyBind("gui.getprevioussearch", 200);
        API.addKeyBind("gui.getnextsearch", 208);
        API.addHashBind("gui.next_tooltip", 44);
        API.addKeyBind("world.chunkoverlay", 67);
        API.addKeyBind("world.moboverlay", 65);
        API.addKeyBind("world.highlight_tips", 82);
        API.addKeyBind("world.dawn", 0);
        API.addKeyBind("world.noon", 0);
        API.addKeyBind("world.dusk", 0);
        API.addKeyBind("world.midnight", 0);
        API.addKeyBind("world.rain", 0);
        API.addKeyBind("world.heal", 0);
        API.addKeyBind("world.creative", 0);
    }

    public static OptionList getOptionList() {
        return OptionList.getOptionList("nei.options");
    }

    public static void loadWorld(String worldPath) {
        boolean newWorld;
        NEIClientConfig.worldPath = worldPath;
        NEIClientConfig.setInternalEnabled(true);
        logger.debug("Loading " + (Minecraft.func_71410_x().func_71356_B() ? "Local" : "Remote") + " World");
        NEIClientConfig.bootNEI(ClientUtils.getWorld());
        File specificDir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/" + worldPath);
        boolean bl = newWorld = !specificDir.exists();
        if (newWorld) {
            specificDir.mkdirs();
        }
        NEIClientConfig.initBookmarkFile(worldPath);
        NEIClientConfig.initPresetsFile(worldPath);
        world = new ConfigSet(new File(specificDir, "NEI.dat"), (ConfigTagParent)new ConfigFile(new File(specificDir, "NEI.cfg")));
        NEIClientConfig.onWorldLoad(newWorld);
    }

    private static void onWorldLoad(boolean newWorld) {
        NEIClientConfig.world.config.setComment("World based configuration of NEI.\nMost of these options can be changed ingame.\nDeleting any element will restore it to it's default value");
        NEIClientConfig.setWorldDefaults();
        creativeInv = new ItemStack[54];
        LayoutManager.searchField.setText(NEIClientConfig.getSearchExpression());
        ItemPanels.itemPanel.quantity.setText(Integer.toString(NEIClientConfig.getItemQuantity()));
        SubsetWidget.loadHidden();
        if (newWorld && Minecraft.func_71410_x().func_71356_B()) {
            NEIClientConfig.world.config.getTag("inventory.cheatmode").setIntValue(NEIClientUtils.mc().field_71442_b.func_78758_h() ? 2 : 0);
        }
        NEIInfo.load(ClientUtils.getWorld());
    }

    private static void setWorldDefaults() {
        NBTTagCompound nbt = NEIClientConfig.world.nbt;
        if (!nbt.func_74764_b("search")) {
            nbt.func_74778_a("search", "");
        }
        if (!nbt.func_74764_b("quantity")) {
            nbt.func_74768_a("quantity", 0);
        }
        if (!nbt.func_74764_b("validateenchantments")) {
            nbt.func_74757_a("validateenchantments", false);
        }
        world.saveNBT();
    }

    public static int getKeyBinding(String string) {
        return NEIClientConfig.getSetting("keys." + string).getIntValue(0);
    }

    public static void setDefaultKeyBinding(String string, int key) {
        NEIClientConfig.getSetting("keys." + string).getIntValue(key);
    }

    public static boolean isKeyHashDown(String string) {
        int hash = NEIClientConfig.getKeyBinding(string);
        return hash != 0 && hash == NEIClientUtils.getKeyHash();
    }

    public static String getKeyName(int keyBind, boolean useHash) {
        return NEIClientConfig.getKeyName(keyBind, useHash, false);
    }

    public static String getKeyName(int keyBind, boolean useHash, boolean showOnlyHash) {
        String keyText = "";
        if (useHash) {
            String DELIMITER = " + ";
            if ((keyBind & 0x2000000) != 0) {
                keyText = keyText + NEIClientUtils.translate(Minecraft.field_142025_a ? "key.ctrl.mac" : "key.ctrl", new Object[0]) + " + ";
            }
            if ((keyBind & 0x4000000) != 0) {
                keyText = keyText + "SHIFT + ";
            }
            if ((keyBind & 0x8000000) != 0) {
                keyText = keyText + "ALT + ";
            }
        }
        if (!showOnlyHash) {
            keyText = keyText + Keyboard.getKeyName((int)NEIClientConfig.unHashKey(keyBind));
        }
        return keyText;
    }

    public static int unHashKey(int keyBind) {
        return keyBind & 0xF1FFFFFF;
    }

    public static void bootNEI(World world) {
        if (configLoaded) {
            return;
        }
        ItemInfo.load(world);
        GuiInfo.load();
        RecipeInfo.load();
        LayoutManager.load();
        NEIController.load();
        RecipeCatalysts.loadCatalystInfo();
        configLoaded = true;
        new Thread("NEI Plugin Loader"){

            @Override
            public void run() {
                ClassDiscoverer classDiscoverer = new ClassDiscoverer(test -> test.startsWith("NEI") && test.endsWith("Config.class"), new Class[]{IConfigureNEI.class});
                classDiscoverer.findClasses();
                for (Class clazz : classDiscoverer.classes) {
                    try {
                        IConfigureNEI config = (IConfigureNEI)clazz.newInstance();
                        config.loadConfig();
                        NEIModContainer.plugins.add(config);
                        logger.debug("Loaded " + clazz.getName());
                    }
                    catch (Exception e) {
                        logger.error("Failed to Load " + clazz.getName(), (Throwable)e);
                    }
                }
                MinecraftForge.EVENT_BUS.post((Event)new NEIConfigsLoadedEvent());
            }
        }.start();
        ItemSorter.loadConfig();
    }

    private static void initBookmarkFile(String worldPath) {
        if (!NEIClientConfig.global.config.getTag("inventory.worldSpecificBookmarks").getBooleanValue()) {
            worldPath = "global";
        }
        ItemPanels.bookmarkPanel.setBookmarkFile(worldPath);
    }

    private static void initPresetsFile(String worldPath) {
        if (!NEIClientConfig.global.config.getTag("inventory.worldSpecificPresets").getBooleanValue()) {
            worldPath = "global";
        }
        PresetsWidget.loadPresets(worldPath);
    }

    public static boolean isWorldSpecific(String setting) {
        if (world == null) {
            return false;
        }
        ConfigTag tag = NEIClientConfig.world.config.getTag(setting, false);
        return tag != null && tag.value != null;
    }

    public static ConfigTag getSetting(String s) {
        return NEIClientConfig.isWorldSpecific(s) ? NEIClientConfig.world.config.getTag(s) : NEIClientConfig.global.config.getTag(s);
    }

    public static boolean getBooleanSetting(String s) {
        return NEIClientConfig.getSetting(s).getBooleanValue();
    }

    public static boolean isHidden() {
        return !enabledOverride || NEIClientConfig.getBooleanSetting("inventory.hidden");
    }

    public static boolean isBookmarkPanelHidden() {
        return !NEIClientConfig.getBooleanSetting("inventory.bookmarksEnabled");
    }

    public static boolean useNBTInBookmarks() {
        return NEIClientConfig.getBooleanSetting("inventory.useNBTInBookmarks");
    }

    public static boolean areBookmarksAnimated() {
        return NEIClientConfig.getBooleanSetting("inventory.bookmarksAnimationEnabled");
    }

    public static boolean showRecipeMarker() {
        return NEIClientConfig.getBooleanSetting("inventory.showRecipeMarker");
    }

    public static boolean showItemQuantityWidget() {
        return NEIClientConfig.getBooleanSetting("inventory.showItemQuantityWidget");
    }

    public static boolean areJEIStyleTabsVisible() {
        return NEIClientConfig.getBooleanSetting("inventory.jei_style_tabs");
    }

    public static boolean isJEIStyleItemPresenceOverlayVisible() {
        return NEIClientConfig.getBooleanSetting("inventory.jei_style_item_presence_overlay");
    }

    public static boolean areJEIStyleRecipeCatalystsVisible() {
        return NEIClientConfig.getBooleanSetting("inventory.jei_style_recipe_catalyst");
    }

    public static boolean useCreativeTabStyle() {
        return NEIClientConfig.getBooleanSetting("inventory.creative_tab_style");
    }

    public static boolean ignorePotionOverlap() {
        return NEIClientConfig.getBooleanSetting("inventory.ignore_potion_overlap");
    }

    public static boolean optimizeGuiOverlapComputation() {
        return NEIClientConfig.getBooleanSetting("inventory.optimize_gui_overlap_computation");
    }

    public static boolean useJEIStyledCycledIngredients() {
        return NEIClientConfig.getBooleanSetting("inventory.jei_style_cycled_ingredients");
    }

    public static boolean requireShiftForOverlayRecipe() {
        return NEIClientConfig.getBooleanSetting("inventory.shift_overlay_recipe");
    }

    public static boolean isEnabled() {
        return enabledOverride && NEIClientConfig.getBooleanSetting("inventory.widgetsenabled");
    }

    public static boolean loadHandlersFromJar() {
        return !NEIClientConfig.getBooleanSetting("tools.handler_load_from_config");
    }

    public static boolean loadCatalystsFromJar() {
        return !NEIClientConfig.getBooleanSetting("tools.catalyst_load_from_config");
    }

    public static void setEnabled(boolean flag) {
        NEIClientConfig.getSetting("inventory.widgetsenabled").setBooleanValue(flag);
    }

    public static int getItemQuantity() {
        return NEIClientConfig.world.nbt.func_74762_e("quantity");
    }

    public static int getCheatMode() {
        return NEIClientConfig.getIntSetting("inventory.cheatmode");
    }

    private static void checkCheatMode() {
        if (NEIClientConfig.getLockedMode() != -1) {
            NEIClientConfig.setIntSetting("inventory.cheatmode", NEIClientConfig.getLockedMode());
        }
    }

    public static int getLockedMode() {
        return NEIClientConfig.getIntSetting("inventory.lockmode");
    }

    public static int getLayoutStyle() {
        return NEIClientConfig.getIntSetting("inventory.layoutstyle");
    }

    public static String getStringSetting(String s) {
        return NEIClientConfig.getSetting(s).getValue();
    }

    public static boolean showIDs() {
        int i = NEIClientConfig.getIntSetting("inventory.itemIDs");
        return i == 2 || i == 1 && NEIClientConfig.isEnabled() && !NEIClientConfig.isHidden();
    }

    public static int getItemLoadingTimeout() {
        return NEIClientConfig.getIntSetting("itemLoadingTimeout");
    }

    public static void toggleBooleanSetting(String setting) {
        ConfigTag tag;
        tag.setBooleanValue(!(tag = NEIClientConfig.getSetting(setting)).getBooleanValue());
    }

    public static void cycleSetting(String setting, int max) {
        ConfigTag tag = NEIClientConfig.getSetting(setting);
        tag.setIntValue((tag.getIntValue() + 1) % max);
    }

    public static int getIntSetting(String setting) {
        return NEIClientConfig.getSetting(setting).getIntValue();
    }

    public static void setIntSetting(String setting, int val) {
        NEIClientConfig.getSetting(setting).setIntValue(val);
    }

    public static String getSearchExpression() {
        return NEIClientConfig.world.nbt.func_74779_i("search");
    }

    public static void setSearchExpression(String expression) {
        NEIClientConfig.world.nbt.func_74778_a("search", expression);
        world.saveNBT();
    }

    public static boolean isMouseScrollTransferEnabled() {
        return !NEIClientConfig.getBooleanSetting("inventory.disableMouseScrollTransfer");
    }

    public static boolean shouldInvertMouseScrollTransfer() {
        return !NEIClientConfig.getBooleanSetting("inventory.invertMouseScrollTransfer");
    }

    public static boolean shouldCacheItemRendering() {
        return NEIClientConfig.getBooleanSetting("inventory.cacheItemRendering") && OpenGlHelper.field_148823_f;
    }

    public static boolean getMagnetMode() {
        return enabledActions.contains("magnet");
    }

    public static boolean invCreativeMode() {
        return enabledActions.contains("creative+") && NEIClientConfig.canPerformAction("creative+");
    }

    public static boolean areDamageVariantsShown() {
        return NEIClientConfig.hasSMPCounterPart() || NEIClientConfig.getSetting("command.item").getValue().contains("{3}");
    }

    public static boolean hasSMPCounterPart() {
        return hasSMPCounterpart;
    }

    public static void setHasSMPCounterPart(boolean flag) {
        hasSMPCounterpart = flag;
        permissableActions.clear();
        bannedBlocks.clear();
        disabledActions.clear();
        enabledActions.clear();
    }

    public static boolean canCheatItem(ItemStack stack) {
        return NEIClientConfig.canPerformAction("item") && !bannedBlocks.contains(stack);
    }

    public static boolean canPerformAction(String name) {
        if (!NEIClientConfig.isEnabled()) {
            return false;
        }
        if (!NEIClientConfig.modePermitsAction(name)) {
            return false;
        }
        String base = NEIActions.base(name);
        if (hasSMPCounterpart) {
            return permissableActions.contains(base);
        }
        if (NEIActions.smpRequired(name)) {
            return false;
        }
        String cmd = NEIClientConfig.getStringSetting("command." + base);
        return cmd != null && cmd.startsWith("/");
    }

    private static boolean modePermitsAction(String name) {
        String[] actions;
        if (NEIClientConfig.getCheatMode() == 0) {
            return false;
        }
        if (NEIClientConfig.getCheatMode() == 2) {
            return true;
        }
        for (String action : actions = NEIClientConfig.getStringArrSetting("inventory.utilities")) {
            if (!action.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static String[] getStringArrSetting(String s) {
        return NEIClientConfig.getStringSetting(s).replace(" ", "").split(",");
    }

    public static void setInternalEnabled(boolean b) {
        enabledOverride = b;
    }

    public static void reloadSaves() {
        List saves;
        File saveDir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/local");
        if (!saveDir.exists()) {
            return;
        }
        try {
            saves = Minecraft.func_71410_x().func_71359_d().func_75799_b();
        }
        catch (Exception e) {
            logger.error("Error loading saves", (Throwable)e);
            return;
        }
        HashSet<String> saveFileNames = new HashSet<String>();
        for (SaveFormatComparator save : saves) {
            saveFileNames.add(save.func_75786_a());
        }
        for (File file : saveDir.listFiles()) {
            if (!file.isDirectory() || saveFileNames.contains(file.getName())) continue;
            ObfuscationRun.deleteDir((File)file, (boolean)true);
        }
    }

    static {
        logger = LogManager.getLogger((String)"NotEnoughItems");
        configDir = new File(CommonUtils.getMinecraftDir(), "config/NEI/");
        global = new ConfigSet(new File("saves/NEI/client.dat"), (ConfigTagParent)new ConfigFile(new File(configDir, "client.cfg")));
        handlerFile = new File(configDir, "handlers.csv");
        catalystFile = new File(configDir, "catalysts.csv");
        serialHandlersFile = new File(configDir, "serialhandlers.cfg");
        heightHackHandlersFile = new File(configDir, "heighthackhandlers.cfg");
        handlerOrderingFile = new File(configDir, "handlerordering.csv");
        serialHandlers = new HashSet();
        heightHackHandlerRegex = new HashSet();
        handlerOrdering = new HashMap();
        HANDLER_ID_FUNCTION = handler -> (String)Objects.firstNonNull((Object)handler.getOverlayIdentifier(), (Object)handler.getHandlerId());
        HANDLER_COMPARATOR = Comparator.comparingInt(NEIClientConfig::getHandlerOrder);
        permissableActions = new HashSet();
        disabledActions = new HashSet();
        enabledActions = new HashSet();
        bannedBlocks = new ItemStackSet();
        if (NEIClientConfig.global.config.getTag("checkUpdates").getBooleanValue(true)) {
            CCUpdateChecker.updateCheck((String)"NotEnoughItems");
        }
        NEIClientConfig.linkOptionList();
        NEIClientConfig.setDefaults();
    }
}

