/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.RecipeInfo;
import com.google.common.base.Stopwatch;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import org.lwjgl.opengl.GL11;

public abstract class TemplateRecipeHandler
implements ICraftingHandler,
IUsageHandler {
    protected static ReentrantLock lock = new ReentrantLock();
    private static Set<Item> efuels;
    public int cycleticks = Math.abs((int)System.currentTimeMillis());
    public ArrayList<CachedRecipe> arecipes = new ArrayList();
    public LinkedList<RecipeTransferRect> transferRects = new LinkedList();

    public static void findFuelsOnce() {
        lock.lock();
        try {
            if (FurnaceRecipeHandler.afuels == null || FurnaceRecipeHandler.afuels.isEmpty()) {
                TemplateRecipeHandler.findFuels(false);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void findFuelsOnceParallel() {
        lock.lock();
        try {
            if (FurnaceRecipeHandler.afuels == null || FurnaceRecipeHandler.afuels.isEmpty()) {
                TemplateRecipeHandler.findFuels(true);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static void findFuels(boolean parallel) {
        efuels = new HashSet<Item>();
        efuels.add(Item.func_150898_a((Block)Blocks.field_150338_P));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150472_an));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150444_as));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150466_ao));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150447_bR));
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (parallel) {
            try {
                FurnaceRecipeHandler.afuels = (ArrayList)((ForkJoinTask)ItemList.forkJoinPool.submit(() -> ItemList.items.parallelStream().map(TemplateRecipeHandler::identifyFuel).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new)))).get();
            }
            catch (InterruptedException | ExecutionException e) {
                FurnaceRecipeHandler.afuels = new ArrayList();
                e.printStackTrace();
            }
        } else {
            FurnaceRecipeHandler.afuels = ItemList.items.stream().map(TemplateRecipeHandler::identifyFuel).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        }
        NEIClientConfig.logger.info("FindFuels took " + stopwatch.stop());
    }

    private static FurnaceRecipeHandler.FuelPair identifyFuel(ItemStack itemStack) {
        if (efuels.contains(itemStack.func_77973_b())) {
            return null;
        }
        int burnTime = TileEntityFurnace.func_145952_a((ItemStack)itemStack);
        if (burnTime <= 0) {
            return null;
        }
        return new FurnaceRecipeHandler.FuelPair(itemStack.func_77946_l(), burnTime);
    }

    public TemplateRecipeHandler() {
        this.loadTransferRects();
        RecipeTransferRectHandler.registerRectsToGuis(this.getRecipeTransferRectGuis(), this.transferRects);
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("item")) {
            this.loadCraftingRecipes((ItemStack)results[0]);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("item")) {
            this.loadUsageRecipes((ItemStack)ingredients[0]);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
    }

    public abstract String getGuiTexture();

    @Override
    public String getOverlayIdentifier() {
        return null;
    }

    public void drawExtras(int recipe) {
    }

    public void drawProgressBar(int x, int y, int tx, int ty, int w, int h, int ticks, int direction) {
        this.drawProgressBar(x, y, tx, ty, w, h, (float)(this.cycleticks % ticks) / (float)ticks, direction);
    }

    public void drawProgressBar(int x, int y, int tx, int ty, int w, int h, float completion, int direction) {
        if (direction > 3) {
            completion = 1.0f - completion;
            direction %= 4;
        }
        int var = (int)(completion * (float)(direction % 2 == 0 ? w : h));
        switch (direction) {
            case 0: {
                GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)tx, (int)ty, (int)var, (int)h);
                break;
            }
            case 1: {
                GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)tx, (int)ty, (int)w, (int)var);
                break;
            }
            case 2: {
                GuiDraw.drawTexturedModalRect((int)(x + w - var), (int)y, (int)(tx + w - var), (int)ty, (int)var, (int)h);
                break;
            }
            case 3: {
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + h - var), (int)tx, (int)(ty + h - var), (int)w, (int)var);
            }
        }
    }

    public List<Class<? extends GuiContainer>> getRecipeTransferRectGuis() {
        Class<? extends GuiContainer> clazz = this.getGuiClass();
        if (clazz != null) {
            LinkedList<Class<? extends GuiContainer>> list = new LinkedList<Class<? extends GuiContainer>>();
            list.add(clazz);
            return list;
        }
        return null;
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return null;
    }

    public TemplateRecipeHandler newInstance() {
        try {
            TemplateRecipeHandler.findFuelsOnce();
            return (TemplateRecipeHandler)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        TemplateRecipeHandler handler = this.newInstance();
        handler.loadCraftingRecipes(outputId, results);
        return handler;
    }

    @Override
    public IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        TemplateRecipeHandler handler = this.newInstance();
        handler.loadUsageRecipes(inputId, ingredients);
        return handler;
    }

    @Override
    public IUsageHandler getUsageAndCatalystHandler(String inputId, Object ... ingredients) {
        ItemStack candidate;
        TemplateRecipeHandler handler = this.newInstance();
        if (inputId.equals("item") && RecipeCatalysts.containsCatalyst(handler, candidate = (ItemStack)ingredients[0])) {
            for (RecipeTransferRect rect : this.transferRects) {
                if (this.specifyTransferRect() != null && !Objects.equals(rect.outputId, this.specifyTransferRect())) continue;
                handler.loadCraftingRecipes(rect.outputId, rect.results);
                return handler;
            }
            NEIClientConfig.logger.info("failed to load catalyst handler, implement `loadTransferRects` for your handler " + handler.getClass().getName());
        }
        return this.getUsageHandler(inputId, ingredients);
    }

    public String specifyTransferRect() {
        return null;
    }

    @Override
    public int numRecipes() {
        return this.arecipes.size();
    }

    @Override
    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)65);
    }

    @Override
    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        this.drawExtras(recipe);
    }

    @Override
    public List<PositionedStack> getIngredientStacks(int recipe) {
        return this.arecipes.get(recipe).getIngredients();
    }

    @Override
    public PositionedStack getResultStack(int recipe) {
        return this.arecipes.get(recipe).getResult();
    }

    @Override
    public List<PositionedStack> getOtherStacks(int recipe) {
        return this.arecipes.get(recipe).getOtherStacks();
    }

    @Override
    public void onUpdate() {
        if (!NEIClientUtils.shiftKey()) {
            ++this.cycleticks;
        }
    }

    @Override
    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return RecipeInfo.hasDefaultOverlay(gui, this.getOverlayIdentifier()) || RecipeInfo.hasOverlayHandler(gui, this.getOverlayIdentifier());
    }

    @Override
    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        IStackPositioner positioner = RecipeInfo.getStackPositioner(gui, this.getOverlayIdentifier());
        if (positioner == null) {
            return null;
        }
        return new DefaultOverlayRenderer(this.getIngredientStacks(recipe), positioner);
    }

    @Override
    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return RecipeInfo.getOverlayHandler(gui, this.getOverlayIdentifier());
    }

    @Override
    public int recipiesPerPage() {
        return 2;
    }

    @Override
    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip, int recipe) {
        if (GuiContainerManager.shouldShowTooltip(gui) && currenttip.size() == 0) {
            Point offset = gui.getRecipePosition(recipe);
            currenttip = TemplateRecipeHandler.transferRectTooltip(gui, this.transferRects, offset.x, offset.y, currenttip);
        }
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack stack, List<String> currenttip, int recipe) {
        return currenttip;
    }

    @Override
    public boolean keyTyped(GuiRecipe<?> gui, char keyChar, int keyCode, int recipe) {
        if (NEIClientConfig.isKeyHashDown("gui.recipe")) {
            return this.transferRect(gui, recipe, false);
        }
        if (NEIClientConfig.isKeyHashDown("gui.usage")) {
            return this.transferRect(gui, recipe, true);
        }
        return false;
    }

    @Override
    public boolean mouseClicked(GuiRecipe<?> gui, int button, int recipe) {
        if (button == 0) {
            return this.transferRect(gui, recipe, false);
        }
        if (button == 1) {
            return this.transferRect(gui, recipe, true);
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(GuiRecipe<?> gui, int scroll, int recipe) {
        if (!NEIClientUtils.shiftKey()) {
            return false;
        }
        Point offset = gui.getRecipePosition(recipe);
        Point pos = GuiDraw.getMousePosition();
        Point relMouse = new Point(pos.x - gui.field_147003_i - offset.x, pos.y - gui.field_147009_r - offset.y);
        for (PositionedStack pStack : this.getIngredientStacks(recipe)) {
            if (!new Rectangle4i(pStack.relx, pStack.rely, 18, 18).contains(relMouse.x, relMouse.y)) continue;
            int index = pStack.items.length + scroll;
            for (int i = 0; i < pStack.items.length; ++i) {
                if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT(pStack.items[i], pStack.item)) continue;
                index += i;
                break;
            }
            pStack.setPermutationToRender(index % pStack.items.length);
            return true;
        }
        return false;
    }

    private boolean transferRect(GuiRecipe<?> gui, int recipe, boolean usage) {
        Point offset = gui.getRecipePosition(recipe);
        return TemplateRecipeHandler.transferRect(gui, this.transferRects, offset.x, offset.y, usage);
    }

    private static boolean transferRect(GuiContainer gui, Collection<RecipeTransferRect> transferRects, int offsetx, int offsety, boolean usage) {
        Point pos = GuiDraw.getMousePosition();
        Point relMouse = new Point(pos.x - gui.field_147003_i - offsetx, pos.y - gui.field_147009_r - offsety);
        for (RecipeTransferRect rect : transferRects) {
            if (!rect.rect.contains(relMouse) || !(usage ? GuiUsageRecipe.openRecipeGui(rect.outputId, rect.results) : GuiCraftingRecipe.openRecipeGui(rect.outputId, rect.results))) continue;
            return true;
        }
        return false;
    }

    private static List<String> transferRectTooltip(GuiContainer gui, Collection<RecipeTransferRect> transferRects, int offsetx, int offsety, List<String> currenttip) {
        Point pos = GuiDraw.getMousePosition();
        Point relMouse = new Point(pos.x - gui.field_147003_i - offsetx, pos.y - gui.field_147009_r - offsety);
        for (RecipeTransferRect rect : transferRects) {
            if (!rect.rect.contains(relMouse)) continue;
            currenttip.add(NEIClientUtils.translate("recipe.tooltip", new Object[0]));
            break;
        }
        return currenttip;
    }

    static {
        GuiContainerManager.addInputHandler(new RecipeTransferRectHandler());
        GuiContainerManager.addTooltipHandler(new RecipeTransferRectHandler());
    }

    public static class RecipeTransferRectHandler
    implements IContainerInputHandler,
    IContainerTooltipHandler {
        private static final HashMap<Class<? extends GuiContainer>, HashSet<RecipeTransferRect>> guiMap = new HashMap();

        public static void registerRectsToGuis(List<Class<? extends GuiContainer>> classes, List<RecipeTransferRect> rects) {
            if (classes == null) {
                return;
            }
            for (Class<? extends GuiContainer> clazz : classes) {
                HashSet set = guiMap.computeIfAbsent(clazz, k -> new HashSet());
                set.addAll(rects);
            }
        }

        public boolean canHandle(GuiContainer gui) {
            return guiMap.containsKey(gui.getClass());
        }

        @Override
        public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
            if (!this.canHandle(gui)) {
                return false;
            }
            if (NEIClientConfig.isKeyHashDown("gui.recipe")) {
                return this.transferRect(gui, false);
            }
            if (NEIClientConfig.isKeyHashDown("gui.usage")) {
                return this.transferRect(gui, true);
            }
            return false;
        }

        @Override
        public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
            if (!this.canHandle(gui)) {
                return false;
            }
            if (button == 0) {
                return this.transferRect(gui, false);
            }
            if (button == 1) {
                return this.transferRect(gui, true);
            }
            return false;
        }

        private boolean transferRect(GuiContainer gui, boolean usage) {
            int[] offset = RecipeInfo.getGuiOffset(gui);
            return TemplateRecipeHandler.transferRect(gui, RecipeTransferRectHandler.guiMap.get(gui.getClass()), offset[0], offset[1], usage);
        }

        @Override
        public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        }

        @Override
        public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        }

        @Override
        public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
        }

        @Override
        public boolean keyTyped(GuiContainer gui, char keyChar, int keyID) {
            return false;
        }

        @Override
        public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
            return false;
        }

        @Override
        public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        }

        @Override
        public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
            if (!this.canHandle(gui)) {
                return currenttip;
            }
            if (GuiContainerManager.shouldShowTooltip(gui) && currenttip.size() == 0) {
                int[] offset = RecipeInfo.getGuiOffset(gui);
                currenttip = TemplateRecipeHandler.transferRectTooltip(gui, RecipeTransferRectHandler.guiMap.get(gui.getClass()), offset[0], offset[1], currenttip);
            }
            return currenttip;
        }

        @Override
        public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
            return currenttip;
        }

        @Override
        public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
            return currenttip;
        }

        @Override
        public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
        }
    }

    public static class RecipeTransferRect {
        Rectangle rect;
        String outputId;
        Object[] results;

        public RecipeTransferRect(Rectangle rectangle, String outputId, Object ... results) {
            this.rect = rectangle;
            this.outputId = outputId;
            this.results = results;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RecipeTransferRect)) {
                return false;
            }
            return this.rect.equals(((RecipeTransferRect)obj).rect);
        }

        public int hashCode() {
            return this.rect.hashCode();
        }
    }

    public abstract class CachedRecipe {
        final long offset = System.currentTimeMillis();

        public abstract PositionedStack getResult();

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            PositionedStack stack = this.getIngredient();
            if (stack != null) {
                stacks.add(stack);
            }
            return stacks;
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            try {
                PositionedStack stack = this.getOtherStack();
                if (stack != null) {
                    stacks.add(stack);
                }
            }
            catch (ArithmeticException e) {
                NEIClientConfig.logger.error("Error in getOtherStacks: " + e);
            }
            return stacks;
        }

        public PositionedStack getOtherStack() {
            return null;
        }

        public List<PositionedStack> getCycledIngredients(int cycle, List<PositionedStack> ingredients) {
            if (!NEIClientUtils.shiftKey()) {
                for (int itemIndex = 0; itemIndex < ingredients.size(); ++itemIndex) {
                    this.randomRenderPermutation(ingredients.get(itemIndex), cycle + itemIndex);
                }
            }
            return ingredients;
        }

        public void randomRenderPermutation(PositionedStack stack, long cycle) {
            Random rand = new Random(cycle + this.offset);
            stack.setPermutationToRender(Math.abs(rand.nextInt()) % stack.items.length);
        }

        public void setIngredientPermutation(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            block0: for (PositionedStack stack : ingredients) {
                for (int i = 0; i < stack.items.length; ++i) {
                    if (!NEIServerUtils.areStacksSameTypeCrafting(ingredient, stack.items[i])) continue;
                    stack.item = stack.items[i];
                    stack.item.func_77964_b(ingredient.func_77960_j());
                    if (ingredient.func_77942_o()) {
                        stack.item.func_77982_d((NBTTagCompound)ingredient.func_77978_p().func_74737_b());
                    }
                    stack.items = new ItemStack[]{stack.item};
                    stack.setPermutationToRender(0);
                    continue block0;
                }
            }
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            for (PositionedStack stack : ingredients) {
                if (!stack.contains(ingredient)) continue;
                return true;
            }
            return false;
        }

        public boolean containsWithNBT(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            for (PositionedStack stack : ingredients) {
                if (!stack.containsWithNBT(ingredient)) continue;
                return true;
            }
            return false;
        }

        public boolean contains(Collection<PositionedStack> ingredients, Item ingredient) {
            for (PositionedStack stack : ingredients) {
                if (!stack.contains(ingredient)) continue;
                return true;
            }
            return false;
        }
    }
}

