/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.TaskProfiler;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.recipe.FuelRecipeHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.ProfilerRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

class RecipeHandlerQuery<T extends IRecipeHandler> {
    private final Function<T, T> recipeHandlerFunction;
    private final List<T> recipeHandlers;
    private final List<T> serialRecipeHandlers;

    RecipeHandlerQuery(Function<T, T> recipeHandlerFunction, List<T> recipeHandlers, List<T> serialRecipeHandlers) {
        this.recipeHandlerFunction = recipeHandlerFunction;
        this.recipeHandlers = recipeHandlers;
        this.serialRecipeHandlers = serialRecipeHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<T> runWithProfiling(String profilerSection) {
        TaskProfiler profiler = ProfilerRecipeHandler.getProfiler();
        profiler.start(profilerSection);
        try {
            ArrayList<T> arrayList = this.getRecipeHandlersParallel();
            return arrayList;
        }
        catch (InterruptedException | ExecutionException e) {
            RecipeHandlerQuery.displayRecipeLookupError(e);
            ArrayList arrayList = new ArrayList(0);
            return arrayList;
        }
        finally {
            profiler.end();
        }
    }

    private ArrayList<T> getRecipeHandlersParallel() throws InterruptedException, ExecutionException {
        FuelRecipeHandler.findFuelsOnceParallel();
        ArrayList<T> handlers = this.getSerialHandlersWithRecipes();
        handlers.addAll(this.getHandlersWithRecipes());
        handlers.sort(NEIClientConfig.HANDLER_COMPARATOR);
        return handlers;
    }

    private ArrayList<T> getSerialHandlersWithRecipes() {
        return this.serialRecipeHandlers.stream().map(this.recipeHandlerFunction).filter(h -> h.numRecipes() > 0).collect(Collectors.toCollection(ArrayList::new));
    }

    private ArrayList<T> getHandlersWithRecipes() throws InterruptedException, ExecutionException {
        return (ArrayList)((ForkJoinTask)ItemList.forkJoinPool.submit(() -> this.recipeHandlers.parallelStream().map(this.recipeHandlerFunction).filter(h -> h.numRecipes() > 0).collect(Collectors.toCollection(ArrayList::new)))).get();
    }

    private static void displayRecipeLookupError(Exception e) {
        e.printStackTrace();
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            ChatComponentTranslation chat = new ChatComponentTranslation("nei.chat.recipe.error", new Object[0]);
            chat.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            player.func_146105_b((IChatComponent)chat);
        }
    }
}

