/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.GuiNEIButton;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.VisiblityData;
import codechicken.nei.api.IGuiContainerOverlay;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.TaggedInventoryArea;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.guihook.IGuiClientSide;
import codechicken.nei.guihook.IGuiHandleMouseWheel;
import codechicken.nei.recipe.BookmarkRecipeId;
import codechicken.nei.recipe.ContainerRecipe;
import codechicken.nei.recipe.GuiRecipeCatalyst;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.GuiRecipeTabs;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public abstract class GuiRecipe<H extends IRecipeHandler>
extends GuiContainer
implements IGuiContainerOverlay,
IGuiClientSide,
IGuiHandleMouseWheel,
IContainerTooltipHandler,
INEIGuiHandler {
    private static final int BG_TOP_HEIGHT = 6;
    private static final int BG_MIDDLE_HEIGHT = 154;
    private static final int BG_BOTTOM_HEIGHT = 6;
    private static final int BG_TOP_Y = 0;
    private static final int BG_MIDDLE_Y = 6;
    private static final int BG_BOTTOM_Y = 160;
    private static final int borderPadding = 6;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 12;
    final DrawableResource bgTop = new DrawableBuilder("nei:textures/gui/recipebg.png", 0, 0, 176, 6).build();
    final DrawableResource bgMiddle = new DrawableBuilder("nei:textures/gui/recipebg.png", 0, 6, 176, 154).build();
    final DrawableResource bgBottom = new DrawableBuilder("nei:textures/gui/recipebg.png", 0, 160, 176, 6).build();
    public ArrayList<H> currenthandlers = new ArrayList();
    public int page;
    public int recipetype;
    public BookmarkRecipeId recipeId;
    public ContainerRecipe slotcontainer;
    public GuiContainer firstGui;
    public GuiScreen firstGuiGeneral;
    public GuiScreen prevGui;
    public GuiButton nextpage;
    public GuiButton prevpage;
    private GuiButton nexttype;
    private GuiButton prevtype;
    private final int OVERLAY_BUTTON_ID_START = 4;
    private GuiButton[] overlayButtons;
    private final Rectangle area = new Rectangle();
    private final GuiRecipeTabs recipeTabs = new GuiRecipeTabs(this);
    private final GuiRecipeCatalyst guiRecipeCatalyst = new GuiRecipeCatalyst(this);
    private H handler;
    private HandlerInfo handlerInfo;
    private int yShift = 0;
    private int itemPresenceCacheRecipe = -1;
    private ArrayList<Boolean> itemPresenceCacheSlots;

    protected GuiRecipe(GuiScreen prevgui) {
        super((Container)new ContainerRecipe());
        this.slotcontainer = (ContainerRecipe)this.field_147002_h;
        this.prevGui = prevgui;
        this.firstGuiGeneral = prevgui;
        if (prevgui instanceof GuiContainer) {
            this.firstGui = (GuiContainer)prevgui;
        }
        if (prevgui instanceof IGuiContainerOverlay) {
            this.firstGui = ((IGuiContainerOverlay)prevgui).getFirstScreen();
            this.firstGuiGeneral = ((IGuiContainerOverlay)prevgui).getFirstScreenGeneral();
        }
    }

    public void func_73866_w_() {
        this.field_146999_f = 176;
        this.field_147000_g = Math.min(Math.max(this.field_146295_m - 68, 166), 370);
        super.func_73866_w_();
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2 + 10;
        this.currenthandlers = this.getCurrentRecipeHandlers();
        if (this.handler == null) {
            this.setRecipePage(this.recipetype);
        } else {
            this.initOverlayButtons();
        }
        this.checkYShift();
        int rightButtonX = this.field_147003_i + this.field_146999_f - 6 - 13;
        int leftButtonX = this.field_147003_i + 6;
        this.nexttype = new GuiNEIButton(0, leftButtonX, this.field_147009_r + 3, 13, 12, "<");
        this.prevtype = new GuiNEIButton(1, rightButtonX, this.field_147009_r + 3, 13, 12, ">");
        this.nextpage = new GuiNEIButton(2, leftButtonX, this.field_147009_r + 17, 13, 12, "<");
        this.prevpage = new GuiNEIButton(3, rightButtonX, this.field_147009_r + 17, 13, 12, ">");
        this.field_146292_n.addAll(Arrays.asList(this.nexttype, this.prevtype, this.nextpage, this.prevpage));
        if (this.currenthandlers.size() == 1) {
            this.nexttype.field_146125_m = false;
            this.prevtype.field_146125_m = false;
        }
        this.recipeTabs.initLayout();
        this.refreshPage();
    }

    private void initOverlayButtons() {
        if (this.overlayButtons != null) {
            this.field_146292_n.removeIf(Arrays.asList(this.overlayButtons)::contains);
        }
        int recipesPerPage = this.getRecipesPerPage();
        this.overlayButtons = new GuiButton[recipesPerPage];
        for (int i = 0; i < recipesPerPage; ++i) {
            this.overlayButtons[i] = new GuiNEIButton(4 + i, this.field_146294_l / 2 + 65, this.field_147009_r + 16 + this.handlerInfo.getHeight() * (i + 1) - 2, 13, 12, "?");
        }
        Collections.addAll(this.field_146292_n, this.overlayButtons);
        this.itemPresenceCacheRecipe = -1;
    }

    private void checkYShift() {
        this.yShift = this.handlerInfo == null ? 0 : this.handlerInfo.getYShift();
    }

    public void setRecipePage(int idx) {
        this.setRecipePage(idx, 0);
    }

    public void setRecipePage(int idx, int position) {
        this.recipetype = idx;
        if (this.recipetype < 0) {
            this.recipetype = this.currenthandlers.size() - 1;
        } else if (this.recipetype >= this.currenthandlers.size()) {
            this.recipetype = 0;
        }
        this.handler = (IRecipeHandler)this.currenthandlers.get(this.recipetype);
        this.handlerInfo = GuiRecipeTab.getHandlerInfo(this.handler);
        this.page = Math.min(Math.max(0, position), this.handler.numRecipes() - 1) / this.getRecipesPerPage();
        this.recipeTabs.calcPageNumber();
        this.checkYShift();
        this.initOverlayButtons();
    }

    public void openTargetRecipe(BookmarkRecipeId recipeId) {
        if (recipeId == null) {
            return;
        }
        if (recipeId.recipetype == -1 || recipeId.position == -1) {
            recipeId.recipetype = 0;
            recipeId.position = 0;
            if (recipeId.handlerName != null) {
                block0: for (int j = 0; j < this.currenthandlers.size(); ++j) {
                    IRecipeHandler localHandler = (IRecipeHandler)this.currenthandlers.get(j);
                    HandlerInfo localHandlerInfo = GuiRecipeTab.getHandlerInfo(localHandler);
                    if (!localHandlerInfo.getHandlerName().equals(recipeId.handlerName)) continue;
                    if (recipeId.ingredients.isEmpty()) break;
                    for (int i = 0; i < localHandler.numRecipes(); ++i) {
                        if (!recipeId.equalsIngredients(localHandler.getIngredientStacks(i))) continue;
                        recipeId.recipetype = j;
                        recipeId.position = i;
                        break block0;
                    }
                    break;
                }
            }
        }
        this.setRecipePage(recipeId.recipetype, recipeId.position);
    }

    public List<PositionedStack> getFocusedRecipeIngredients() {
        int recipesPerPage = this.getRecipesPerPage();
        for (int idx = this.page * recipesPerPage; idx < this.handler.numRecipes() && idx < (this.page + 1) * recipesPerPage; ++idx) {
            if (!this.recipeInFocus(idx)) continue;
            return this.handler.getIngredientStacks(idx);
        }
        return null;
    }

    protected boolean recipeInFocus(int idx) {
        PositionedStack result = this.handler.getResultStack(idx);
        if (result != null && this.isMouseOver(result, idx)) {
            return true;
        }
        List<PositionedStack> stacks = this.handler.getOtherStacks(idx);
        for (PositionedStack stack : stacks) {
            if (!this.isMouseOver(stack, idx)) continue;
            return true;
        }
        return false;
    }

    public String getHandlerName() {
        return this.handlerInfo.getHandlerName();
    }

    public H getHandler() {
        return this.handler;
    }

    public List<Integer> getRecipeIndices() {
        int recipesPerPage = this.getRecipesPerPage();
        int minIndex = this.page * recipesPerPage;
        int maxIndex = Math.min(this.handler.numRecipes(), (this.page + 1) * recipesPerPage);
        return IntStream.range(minIndex, maxIndex).boxed().collect(Collectors.toList());
    }

    public void func_73869_a(char c, int i) {
        if (i == 1) {
            this.field_146297_k.func_147108_a(this.firstGuiGeneral);
            return;
        }
        if (GuiContainerManager.getManager(this).lastKeyTyped(i, c)) {
            return;
        }
        try (HeightHack heightHack = new HeightHack();){
            for (int recipe : this.getRecipeIndices()) {
                if (!this.handler.keyTyped(this, c, i, recipe)) continue;
                return;
            }
        }
        if (i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.func_147108_a(this.firstGuiGeneral);
        } else if (NEIClientConfig.isKeyHashDown("gui.back")) {
            this.field_146297_k.func_147108_a(this.prevGui);
        } else if (NEIClientConfig.isKeyHashDown("gui.prev_machine")) {
            this.prevType();
        } else if (NEIClientConfig.isKeyHashDown("gui.next_machine")) {
            this.nextType();
        } else if (NEIClientConfig.isKeyHashDown("gui.prev_recipe")) {
            this.prevPage();
        } else if (NEIClientConfig.isKeyHashDown("gui.next_recipe")) {
            this.nextPage();
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        try (HeightHack heightHack = new HeightHack();){
            for (int recipe : this.getRecipeIndices()) {
                if (!this.handler.mouseClicked(this, button, recipe)) continue;
                return;
            }
        }
        if (this.recipeTabs.mouseClicked(x, y, button)) {
            return;
        }
        super.func_73864_a(x, y, button);
    }

    @Override
    public void mouseScrolled(int i) {
        for (int recipe : this.getRecipeIndices()) {
            if (!this.handler.mouseScrolled(this, i, recipe)) continue;
            return;
        }
        if (new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g).contains(GuiDraw.getMousePosition())) {
            if (i > 0) {
                this.prevPage();
            } else {
                this.nextPage();
            }
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        super.func_146284_a(guibutton);
        switch (guibutton.field_146127_k) {
            case 0: {
                this.prevType();
                return;
            }
            case 1: {
                this.nextType();
                return;
            }
            case 2: {
                this.prevPage();
                return;
            }
            case 3: {
                this.nextPage();
                return;
            }
        }
        if (this.overlayButtons != null && guibutton.field_146127_k >= 4 && guibutton.field_146127_k < 4 + this.overlayButtons.length) {
            this.overlayRecipe(this.page * this.getRecipesPerPage() + guibutton.field_146127_k - 4, NEIClientUtils.shiftKey());
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.handler.onUpdate();
        this.refreshPage();
    }

    @Override
    public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
        try (HeightHack heightHack = new HeightHack();){
            for (int i : this.getRecipeIndices()) {
                currenttip = this.handler.handleTooltip(this, currenttip, i);
            }
        }
        this.recipeTabs.handleTooltip(mousex, mousey, currenttip);
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(GuiContainer gui, ItemStack stack, int mousex, int mousey, List<String> currenttip) {
        for (int i : this.getRecipeIndices()) {
            currenttip = this.handler.handleItemTooltip(this, stack, currenttip, i);
        }
        return currenttip;
    }

    @Override
    public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
        return currenttip;
    }

    private void nextPage() {
        ++this.page;
        if (this.page > (this.handler.numRecipes() - 1) / this.getRecipesPerPage()) {
            this.page = 0;
        }
    }

    private void prevPage() {
        --this.page;
        if (this.page < 0) {
            this.page = (this.handler.numRecipes() - 1) / this.getRecipesPerPage();
        }
    }

    private void nextType() {
        this.setRecipePage(++this.recipetype);
    }

    private void prevType() {
        this.setRecipePage(--this.recipetype);
    }

    protected void overlayRecipe(int recipe, boolean shift) {
        if (this.handler == null || !this.handler.hasOverlay(this.firstGui, this.firstGui.field_147002_h, recipe)) {
            this.field_146297_k.func_147108_a((GuiScreen)this.firstGui);
            return;
        }
        IRecipeOverlayRenderer renderer = this.handler.getOverlayRenderer(this.firstGui, recipe);
        IOverlayHandler overlayHandler = this.handler.getOverlayHandler(this.firstGui, recipe);
        this.field_146297_k.func_147108_a((GuiScreen)this.firstGui);
        if (renderer == null || shift) {
            overlayHandler.overlayRecipe(this.firstGui, (IRecipeHandler)this.currenthandlers.get(this.recipetype), recipe, shift);
        } else {
            LayoutManager.overlayRenderer = renderer;
        }
    }

    public void refreshPage() {
        RecipeCatalysts.updatePosition(this.field_147000_g - 6 - 12);
        this.refreshSlots();
        int recipesPerPage = this.getRecipesPerPage();
        boolean multiplepages = this.handler.numRecipes() > recipesPerPage;
        int numRecipes = Math.min(this.handler.numRecipes() - this.page * recipesPerPage, recipesPerPage);
        this.area.width = this.handlerInfo.getWidth();
        this.area.height = this.handlerInfo.getHeight() * numRecipes;
        this.area.x = this.field_147003_i - 2;
        this.area.y = this.field_147009_r - 4 + this.yShift;
        this.checkYShift();
        this.nextpage.field_146124_l = this.prevpage.field_146124_l = multiplepages;
        if (this.firstGui == null) {
            for (GuiButton overlay : this.overlayButtons) {
                overlay.field_146125_m = false;
            }
        } else {
            for (int i = 0; i < this.overlayButtons.length; ++i) {
                if (i >= numRecipes) {
                    this.overlayButtons[i].field_146125_m = false;
                    continue;
                }
                int curRecipe = this.page * recipesPerPage + i;
                this.overlayButtons[i].field_146125_m = this.handler.hasOverlay(this.firstGui, this.firstGui.field_147002_h, curRecipe);
            }
        }
        this.recipeTabs.refreshPage();
    }

    private void refreshSlots() {
        this.slotcontainer.field_75151_b.clear();
        int recipesPerPage = this.getRecipesPerPage();
        for (int i = this.page * recipesPerPage; i < this.handler.numRecipes() && i < (this.page + 1) * recipesPerPage; ++i) {
            Point p = this.getRecipePosition(i);
            List<PositionedStack> stacks = this.handler.getIngredientStacks(i);
            for (PositionedStack stack : stacks) {
                this.slotcontainer.addSlot(stack, p.x, p.y);
            }
            stacks = this.handler.getOtherStacks(i);
            for (PositionedStack stack : stacks) {
                this.slotcontainer.addSlot(stack, p.x, p.y);
            }
            PositionedStack result = this.handler.getResultStack(i);
            if (result != null) {
                this.slotcontainer.addSlot(result, p.x, p.y);
            }
            List<PositionedStack> catalysts = RecipeCatalysts.getRecipeCatalysts(this.handler);
            for (PositionedStack catalyst : catalysts) {
                int xOffset = -15;
                int yOffset = 6;
                this.slotcontainer.addSlot(catalyst, xOffset, yOffset);
            }
        }
    }

    private void updateItemPresenceCache(int recipe) {
        if (this.itemPresenceCacheSlots == null) {
            this.itemPresenceCacheSlots = new ArrayList();
        }
        this.itemPresenceCacheRecipe = recipe;
        this.itemPresenceCacheSlots.clear();
        List<PositionedStack> ingredients = this.handler.getIngredientStacks(recipe);
        ArrayList invStacks = this.firstGui.field_147002_h.field_75151_b.stream().filter(s -> s != null && s.func_75211_c() != null && s.func_75211_c().field_77994_a > 0 && s.func_75214_a(s.func_75211_c()) && s.func_82869_a((EntityPlayer)this.field_146297_k.field_71439_g)).map(s -> s.func_75211_c().func_77946_l()).collect(Collectors.toCollection(ArrayList::new));
        for (PositionedStack stack : ingredients) {
            Optional<ItemStack> used = invStacks.stream().filter(is -> is.field_77994_a > 0 && stack.contains((ItemStack)is)).findFirst();
            this.itemPresenceCacheSlots.add(used.isPresent());
            if (!used.isPresent()) continue;
            ItemStack is2 = used.get();
            --is2.field_77994_a;
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GuiContainerManager.enable2DRender();
        int recipesPerPage = this.getRecipesPerPage();
        String s = this.handler.getRecipeName().trim();
        this.field_146289_q.func_78261_a(s, (this.field_146999_f - this.field_146289_q.func_78256_a(s)) / 2, 5, 0xFFFFFF);
        s = NEIClientUtils.translate("recipe.page", this.page + 1, (this.handler.numRecipes() - 1) / recipesPerPage + 1);
        this.field_146289_q.func_78261_a(s, (this.field_146999_f - this.field_146289_q.func_78256_a(s)) / 2, 19, 0xFFFFFF);
        boolean drawItemPresence = NEIClientConfig.isJEIStyleItemPresenceOverlayVisible();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)5.0f, (float)(32 + this.yShift), (float)0.0f);
        try (HeightHack heightHack = new HeightHack();){
            for (int i = this.page * recipesPerPage; i < this.handler.numRecipes() && i < (this.page + 1) * recipesPerPage; ++i) {
                this.handler.drawForeground(i);
                if (drawItemPresence && this.isMouseOverOverlayButton(i - this.page * recipesPerPage) && this.firstGui.field_147002_h != null) {
                    List<PositionedStack> ingredients = this.handler.getIngredientStacks(i);
                    if (this.itemPresenceCacheRecipe != i || this.itemPresenceCacheSlots == null || this.itemPresenceCacheSlots.size() != ingredients.size()) {
                        this.updateItemPresenceCache(i);
                    }
                    for (int j = 0; j < ingredients.size(); ++j) {
                        PositionedStack stack = ingredients.get(j);
                        boolean isPresent = this.itemPresenceCacheSlots.get(j);
                        LayoutManager.drawItemPresenceOverlay(stack.relx, stack.rely, isPresent);
                    }
                }
                GL11.glTranslatef((float)0.0f, (float)this.handlerInfo.getHeight(), (float)0.0f);
            }
        }
        GL11.glPopMatrix();
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        int recipesPerPage = this.getRecipesPerPage();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = this.field_147009_r;
        this.drawBackgroundTiled(j, k);
        GuiRecipe.func_73734_a((int)(this.field_147003_i + 6 + 13 - 1), (int)this.nexttype.field_146129_i, (int)(this.field_147003_i + this.field_146999_f - 6 - 13), (int)(this.nexttype.field_146129_i + 12), (int)0x30000000);
        GuiRecipe.func_73734_a((int)(this.field_147003_i + 6 + 13 - 1), (int)this.nextpage.field_146129_i, (int)(this.field_147003_i + this.field_146999_f - 6 - 13), (int)(this.nextpage.field_146129_i + 12), (int)0x30000000);
        if (NEIClientConfig.areJEIStyleTabsVisible()) {
            RenderHelper.func_74520_c();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            this.recipeTabs.draw(mouseX, mouseY);
            if (NEIClientConfig.areJEIStyleRecipeCatalystsVisible()) {
                this.guiRecipeCatalyst.draw();
            }
            RenderHelper.func_74518_a();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(j + 5), (float)(k + 32 + this.yShift), (float)0.0f);
        try (HeightHack heightHack = new HeightHack();){
            for (int i = this.page * recipesPerPage; i < this.handler.numRecipes() && i < (this.page + 1) * recipesPerPage; ++i) {
                this.handler.drawBackground(i);
                GL11.glTranslatef((float)0.0f, (float)this.handlerInfo.getHeight(), (float)0.0f);
            }
        }
        GL11.glPopMatrix();
    }

    private void drawBackgroundTiled(int j, int k) {
        this.bgTop.draw(j, k + 0);
        int tiledHeight = this.field_147000_g - 6 - 6;
        if (tiledHeight > 0) {
            int yTileCount = tiledHeight / 154;
            int yRemainder = tiledHeight - yTileCount * 154;
            int yStart = k + 6 + tiledHeight;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int tileHeight = yTile == yTileCount ? yRemainder : 154;
                int y = yStart - (yTile + 1) * 154;
                if (tileHeight <= 0) continue;
                this.bgMiddle.draw(j, y, 154 - tileHeight, 0, 0, 0);
            }
        }
        this.bgBottom.draw(j, k + this.field_147000_g - 6);
    }

    @Override
    public GuiContainer getFirstScreen() {
        return this.firstGui;
    }

    @Override
    public GuiScreen getFirstScreenGeneral() {
        return this.firstGuiGeneral;
    }

    public boolean isMouseOver(PositionedStack stack, int recipe) {
        Slot stackSlot = this.slotcontainer.getSlotWithStack(stack, this.getRecipePosition((int)recipe).x, this.getRecipePosition((int)recipe).y);
        Point mousepos = GuiDraw.getMousePosition();
        Slot mouseoverSlot = this.func_146975_c(mousepos.x, mousepos.y);
        return stackSlot == mouseoverSlot;
    }

    private boolean isMouseOverOverlayButton(int buttonId) {
        if (buttonId >= 0 && buttonId < this.overlayButtons.length) {
            GuiButton button = this.overlayButtons[buttonId];
            Point mousePos = GuiDraw.getMousePosition();
            return button.field_146125_m && mousePos.x >= button.field_146128_h && mousePos.y >= button.field_146129_i && mousePos.x < button.field_146128_h + button.field_146120_f && mousePos.y < button.field_146129_i + button.field_146121_g;
        }
        return false;
    }

    private int getRecipesPerPage() {
        return this.getRecipesPerPage(this.handlerInfo);
    }

    private int getRecipesPerPage(HandlerInfo handlerInfo) {
        if (handlerInfo != null) {
            return Math.max(Math.min((this.field_147000_g - 36) / handlerInfo.getHeight(), handlerInfo.getMaxRecipesPerPage()), 1);
        }
        return this.handler.recipiesPerPage();
    }

    public Point getRecipePosition(int recipe) {
        return new Point(5, 32 + this.yShift + recipe % this.getRecipesPerPage() * this.handlerInfo.getHeight());
    }

    public abstract ArrayList<H> getCurrentRecipeHandlers();

    @Override
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return currentVisibility;
    }

    @Override
    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return Collections.emptyList();
    }

    @Override
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return null;
    }

    @Override
    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    @Override
    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        return this.area.intersects(x, y, w, h);
    }

    protected static BookmarkRecipeId getCurrentRecipe(GuiScreen gui) {
        if (gui instanceof GuiRecipe) {
            GuiRecipe gRecipe = (GuiRecipe)gui;
            return new BookmarkRecipeId(gRecipe.handlerInfo.getHandlerName(), gRecipe.getHandler().getIngredientStacks(gRecipe.page * gRecipe.getRecipesPerPage()));
        }
        return null;
    }

    private class HeightHack
    implements AutoCloseable {
        private final int trueHeight;

        private HeightHack() {
            this.trueHeight = GuiRecipe.this.field_146295_m;
            boolean applyHeightHack = NEIClientConfig.heightHackHandlerRegex.stream().map(pattern -> pattern.matcher(GuiRecipe.this.handler.getHandlerId())).anyMatch(Matcher::matches);
            if (applyHeightHack) {
                GuiRecipe.this.field_146295_m = 2 * GuiRecipe.this.field_147009_r + 166;
            }
        }

        @Override
        public void close() {
            GuiRecipe.this.field_146295_m = this.trueHeight;
        }
    }
}

