/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemPanels;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.BookmarkRecipeId;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.RecipeHandlerQuery;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;

public class GuiCraftingRecipe
extends GuiRecipe<ICraftingHandler> {
    public static ArrayList<ICraftingHandler> craftinghandlers = new ArrayList();
    public static ArrayList<ICraftingHandler> serialCraftingHandlers = new ArrayList();

    public static boolean openRecipeGui(String outputId, Object ... results) {
        return GuiCraftingRecipe.openRecipeGui(outputId, false, false, results);
    }

    public static boolean openRecipeGui(String outputId, Boolean overlay, Boolean shift, Object ... results) {
        BookmarkRecipeId recipeId;
        Minecraft mc = NEIClientUtils.mc();
        BookmarkRecipeId bookmarkRecipeId = recipeId = "item".equals(outputId) ? GuiCraftingRecipe.getRecipeId(mc.field_71462_r, (ItemStack)results[0]) : GuiCraftingRecipe.getCurrentRecipe(mc.field_71462_r);
        if (overlay.booleanValue() && recipeId == null) {
            return false;
        }
        RecipeHandlerQuery<ICraftingHandler> recipeQuery = new RecipeHandlerQuery<ICraftingHandler>(h -> h.getRecipeHandler(outputId, results), craftinghandlers, serialCraftingHandlers);
        ArrayList<ICraftingHandler> handlers = recipeQuery.runWithProfiling("recipe.concurrent.crafting");
        if (!handlers.isEmpty()) {
            GuiCraftingRecipe gui = new GuiCraftingRecipe(handlers, recipeId);
            mc.func_147108_a((GuiScreen)gui);
            if (recipeId != null) {
                gui.openTargetRecipe(gui.recipeId);
            }
            if (overlay.booleanValue()) {
                gui.overlayRecipe(gui.recipeId.position, shift);
            }
            return true;
        }
        return false;
    }

    protected static BookmarkRecipeId getRecipeId(GuiScreen gui, ItemStack stackover) {
        if (gui instanceof GuiRecipe) {
            List<PositionedStack> ingredients = ((GuiRecipe)gui).getFocusedRecipeIngredients();
            String handlerName = ((GuiRecipe)gui).getHandlerName();
            if (ingredients != null && !ingredients.isEmpty()) {
                return new BookmarkRecipeId(handlerName, ingredients);
            }
        }
        Point mouseover = GuiDraw.getMousePosition();
        ItemPanel.ItemPanelSlot panelSlot = ItemPanels.bookmarkPanel.getSlotMouseOver(mouseover.x, mouseover.y);
        if (panelSlot != null) {
            return ItemPanels.bookmarkPanel.getBookmarkRecipeId(panelSlot.slotIndex);
        }
        return ItemPanels.bookmarkPanel.getBookmarkRecipeId(stackover);
    }

    private GuiCraftingRecipe(ArrayList<ICraftingHandler> handlers, BookmarkRecipeId recipeId) {
        super(NEIClientUtils.mc().field_71462_r);
        this.currenthandlers = handlers;
        this.recipeId = recipeId;
    }

    public static void registerRecipeHandler(ICraftingHandler handler) {
        String handlerId = handler.getHandlerId();
        if (craftinghandlers.stream().anyMatch(h -> h.getHandlerId().equals(handlerId)) || serialCraftingHandlers.stream().anyMatch(h -> h.getHandlerId().equals(handlerId))) {
            return;
        }
        if (NEIClientConfig.serialHandlers.contains(handlerId)) {
            serialCraftingHandlers.add(handler);
        } else {
            craftinghandlers.add(handler);
        }
    }

    @Override
    public ArrayList<ICraftingHandler> getCurrentRecipeHandlers() {
        return this.currenthandlers;
    }
}

