/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.config.Option;
import codechicken.nei.config.OptionButton;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;

public class OptionKeyBind
extends OptionButton {
    private boolean editing = false;
    private boolean useHash = false;
    private int keyboard = 0;

    public OptionKeyBind(String name) {
        this(name, false);
    }

    public OptionKeyBind(String name, boolean useHash) {
        super("keys." + name);
        this.useHash = useHash;
    }

    @Override
    public void onMouseClicked(int mousex, int mousey, int button) {
        if (this.editing) {
            this.resetChanges();
        }
    }

    @Override
    public void keyTyped(char c, int keycode) {
        if (!this.editing) {
            return;
        }
        if (keycode == 28) {
            this.applyChanges();
            return;
        }
        int n = this.keyboard = this.useHash ? NEIClientUtils.getKeyHash() : keycode;
        if (this.keyboard != 0) {
            this.applyChanges();
        }
    }

    @Override
    public boolean onClick(int btn) {
        if (this.editing) {
            return true;
        }
        if (btn == 0) {
            this.editing = true;
            return true;
        }
        if (btn == 1) {
            this.keyboard = 0;
            this.applyChanges();
            return true;
        }
        return false;
    }

    protected void applyChanges() {
        this.setValue(this.keyboard);
        this.resetChanges();
    }

    protected void resetChanges() {
        this.editing = false;
        this.keyboard = 0;
    }

    public boolean conflicted() {
        int keyboard = this.getValue();
        if (keyboard <= 0) {
            return false;
        }
        for (Option o : this.slot.options) {
            if (!(o instanceof OptionKeyBind) || o == this || ((OptionKeyBind)o).getValue() != keyboard) continue;
            return true;
        }
        return false;
    }

    public void setValue(int keycode) {
        this.getTag().setIntValue(keycode);
    }

    public int getValue() {
        return this.renderTag().getIntValue();
    }

    @Override
    public String getPrefix() {
        return this.translateN(this.name, new Object[0]);
    }

    @Override
    public void drawButton(int mx, int my) {
        if (this.editing) {
            Rectangle b = this.buttonSize();
            GuiDraw.drawRect((int)b.x, (int)b.y, (int)b.width, (int)b.height, (int)-6250336);
            GuiDraw.drawRect((int)(b.x + 1), (int)(b.y + 1), (int)(b.width - 2), (int)(b.height - 2), (int)-16777216);
            GuiDraw.drawStringC((String)this.getButtonText(), (int)b.x, (int)b.y, (int)b.width, (int)b.height, (int)this.getTextColour(mx, my));
        } else {
            super.drawButton(mx, my);
        }
    }

    @Override
    public String getButtonText() {
        String keyText = "";
        if (this.useHash) {
            int metahash = Math.max(this.editing ? NEIClientUtils.getMetaHash() : this.getValue(), 0);
            String DELIMITER = EnumChatFormatting.GRAY + " + " + EnumChatFormatting.RESET;
            if ((metahash & 0x2000000) == 0x2000000) {
                keyText = keyText + NEIClientUtils.translate(Minecraft.field_142025_a ? "key.ctrl.mac" : "key.ctrl", new Object[0]) + DELIMITER;
            }
            if ((metahash & 0x4000000) == 0x4000000) {
                keyText = keyText + "SHIFT" + DELIMITER;
            }
            if ((metahash & 0x8000000) == 0x8000000) {
                keyText = keyText + "ALT" + DELIMITER;
            }
        }
        if (!this.editing) {
            keyText = keyText + Keyboard.getKeyName((int)(this.getValue() & 0xF1FFFFFF));
        }
        return keyText;
    }

    @Override
    public int getTextColour(int mousex, int mousey) {
        return !this.editing && this.conflicted() ? -39322 : -1;
    }
}

