/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.guihook.GuiContainerManager;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class AnimatedItemStack {
    private static final int steep = 10;
    private static final float scaleSpeed = 0.1f;
    private int lastPosX = -1;
    private int lastPosY = -1;
    private float currentScale = 0.0f;
    private final boolean doMoveAnim;
    private final boolean doPopAnim;
    public ItemStack itemStack;

    public AnimatedItemStack(ItemStack itemStack, boolean doMoveAnim, boolean doPopAnim) {
        this.itemStack = itemStack;
        this.doMoveAnim = doMoveAnim;
        this.doPopAnim = doPopAnim;
    }

    public void drawItem(int x, int y) {
        this.drawItem(x, y, false, null, false);
    }

    public void drawItem(int x, int y, boolean smallAmount, String stackSize, boolean blockMoveAnimOnce) {
        if (NEIClientConfig.areBookmarksAnimated()) {
            if (this.doPopAnim && this.currentScale < 1.0f) {
                this.drawPoppingItem(x, y, smallAmount, stackSize);
                return;
            }
            if (this.doMoveAnim && (this.lastPosX != x || this.lastPosY != y) && !blockMoveAnimOnce) {
                this.drawMovingItem(x, y, smallAmount, stackSize);
                return;
            }
        }
        this.currentScale = 1.0f;
        this.lastPosX = x;
        this.lastPosY = y;
        GuiContainerManager.drawItem(x, y, this.itemStack, smallAmount, stackSize);
    }

    private void drawPoppingItem(int x, int y, boolean smallAmount, String stackSize) {
        this.currentScale += 0.1f;
        GL11.glScalef((float)this.currentScale, (float)this.currentScale, (float)this.currentScale);
        GuiContainerManager.drawItem((int)(((float)x + (9.0f - this.currentScale * 18.0f / 2.0f)) / this.currentScale), (int)(((float)y + (9.0f - this.currentScale * 18.0f / 2.0f)) / this.currentScale), this.itemStack, smallAmount, stackSize);
        GL11.glScalef((float)(1.0f / this.currentScale), (float)(1.0f / this.currentScale), (float)(1.0f / this.currentScale));
    }

    private void drawMovingItem(int x, int y, boolean smallAmount, String stackSize) {
        if (this.lastPosX != -1 && this.lastPosY != -1) {
            int xDiff = x - this.lastPosX;
            int yDiff = y - this.lastPosY;
            int moveX = xDiff / 10 + (xDiff % 10 == 0 ? 0 : (xDiff > 0 ? 1 : -1));
            int moveY = yDiff / 10 + (yDiff % 10 == 0 ? 0 : (yDiff > 0 ? 1 : -1));
            GuiContainerManager.drawItem(this.lastPosX + moveX, this.lastPosY + moveY, this.itemStack, smallAmount, stackSize);
            this.lastPosX += moveX;
            this.lastPosY += moveY;
        } else {
            this.lastPosX = x;
            this.lastPosY = y;
            GuiContainerManager.drawItem(x, y, this.itemStack, smallAmount, stackSize);
        }
    }
}

