/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.TaskProfiler;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.FuelRecipeHandler;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.ProfilerRecipeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;

public class GuiUsageRecipe
extends GuiRecipe {
    public ArrayList<IUsageHandler> currenthandlers;
    public static ArrayList<IUsageHandler> usagehandlers = new ArrayList();
    public static ArrayList<IUsageHandler> serialUsageHandlers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean openRecipeGui(String inputId, Object ... ingredients) {
        ArrayList handlers;
        Minecraft mc = NEIClientUtils.mc();
        GuiContainer prevscreen = mc.field_71462_r instanceof GuiContainer ? (GuiContainer)mc.field_71462_r : null;
        TaskProfiler profiler = ProfilerRecipeHandler.getProfiler();
        FuelRecipeHandler.findFuelsOnceParallel();
        profiler.start("recipe.concurrent.usage");
        try {
            handlers = serialUsageHandlers.stream().map(h -> GuiUsageRecipe.getUsageOrCatalystHandler(h, inputId, ingredients)).filter(h -> h.numRecipes() > 0).collect(Collectors.toCollection(ArrayList::new));
            handlers.addAll((Collection)((ForkJoinTask)ItemList.forkJoinPool.submit(() -> usagehandlers.parallelStream().map(h -> GuiUsageRecipe.getUsageOrCatalystHandler(h, inputId, ingredients)).filter(h -> h.numRecipes() > 0).collect(Collectors.toCollection(ArrayList::new)))).get());
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            profiler.end();
        }
        if (handlers.isEmpty()) {
            return false;
        }
        handlers.sort(NEIClientConfig.HANDLER_COMPARATOR);
        mc.func_147108_a((GuiScreen)new GuiUsageRecipe(prevscreen, handlers));
        return true;
    }

    private GuiUsageRecipe(GuiContainer prevgui, ArrayList<IUsageHandler> handlers) {
        super((GuiScreen)prevgui);
        this.currenthandlers = handlers;
    }

    public static void registerUsageHandler(IUsageHandler handler) {
        String handlerId = handler.getHandlerId();
        if (usagehandlers.stream().anyMatch(h -> h.getHandlerId().equals(handlerId)) || serialUsageHandlers.stream().anyMatch(h -> h.getHandlerId().equals(handlerId))) {
            return;
        }
        if (NEIClientConfig.serialHandlers.contains(handlerId)) {
            serialUsageHandlers.add(handler);
        } else {
            usagehandlers.add(handler);
        }
    }

    @Override
    public ArrayList<? extends IRecipeHandler> getCurrentRecipeHandlers() {
        return this.currenthandlers;
    }

    private static IUsageHandler getUsageOrCatalystHandler(IUsageHandler handler, String inputId, Object ... ingredients) {
        boolean skipCatalyst = NEIClientUtils.controlKey();
        if (NEIClientConfig.areJEIStyleRecipeCatalystsVisible() && !skipCatalyst) {
            return handler.getUsageAndCatalystHandler(inputId, ingredients);
        }
        return handler.getUsageHandler(inputId, ingredients);
    }
}

