/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.api.INEIGuiAdapter;
import codechicken.nei.drawable.GuiElementDuex;
import codechicken.nei.drawable.GuiElementScalable;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.RecipeCatalysts;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

public class GuiRecipeCatalyst
extends INEIGuiAdapter {
    private GuiRecipe guiRecipe;
    public static final int ingredientSize = 16;
    public static final int ingredientBorder = 1;
    public static final int tabBorder = 5;
    public static final int fullBorder = 6;
    private static final Rectangle catalystRect = new Rectangle();
    private static final Rectangle targetRect = new Rectangle();

    public GuiRecipeCatalyst(GuiRecipe guiRecipe) {
        this.guiRecipe = guiRecipe;
    }

    public void draw() {
        if (this.guiRecipe == null) {
            return;
        }
        int catalystsSize = RecipeCatalysts.getRecipeCatalysts(this.guiRecipe.getHandler()).size();
        if (catalystsSize == 0) {
            return;
        }
        int availableHeight = RecipeCatalysts.getHeight();
        int columnCount = RecipeCatalysts.getColumnCount(availableHeight, catalystsSize);
        int rowCount = RecipeCatalysts.getRowCount(availableHeight, catalystsSize);
        int width = 12 + columnCount * 16;
        int height = 12 + rowCount * 16;
        int xPos = this.guiRecipe.field_147003_i - width + 5 + 1;
        int yPos = this.guiRecipe.field_147009_r;
        this.drawBordered("nei:textures/catalyst_tab.png", xPos, yPos, width, height, 28, 28, 6, 6, 6, 6);
        width = 2 + columnCount * 16;
        height = 2 + rowCount * 16;
        xPos = this.guiRecipe.field_147003_i - width + 1 + 1;
        yPos = this.guiRecipe.field_147009_r + 6 - 1;
        this.drawBordered("nei:textures/slot.png", xPos, yPos, width, height, 18, 18, 1, 1, 1, 1);
    }

    @Override
    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        if (!(gui instanceof GuiRecipe)) {
            return false;
        }
        this.guiRecipe = (GuiRecipe)gui;
        int catalystsSize = RecipeCatalysts.getRecipeCatalysts(this.guiRecipe.getHandler()).size();
        if (catalystsSize == 0) {
            return false;
        }
        int availableHeight = RecipeCatalysts.getHeight();
        int columnCount = RecipeCatalysts.getColumnCount(availableHeight, catalystsSize);
        int rowCount = RecipeCatalysts.getRowCount(availableHeight, catalystsSize);
        int margin = 4;
        int width = 12 + columnCount * 16 + margin;
        int height = 12 + rowCount * 16 + margin;
        int xOffset = this.guiRecipe.field_147003_i - width + 5;
        int yOffset = this.guiRecipe.field_147009_r;
        catalystRect.setBounds(xOffset, yOffset, width, height);
        targetRect.setBounds(x, y, w, h);
        return targetRect.intersects((ReadableRectangle)catalystRect);
    }

    private void drawBordered(String location, int xPos, int yPos, int width, int height, int texWidth, int texHeight, int sliceLeft, int sliceRight, int sliceTop, int sliceBottom) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(location));
        GuiElementDuex cornerTopLeft = new GuiElementDuex(0, 0, sliceLeft, sliceTop, texWidth, texHeight);
        GuiElementDuex cornerTopRight = new GuiElementDuex(texWidth - sliceRight, 0, sliceRight, sliceTop, texWidth, texHeight);
        GuiElementDuex cornerBottomLeft = new GuiElementDuex(0, texHeight - sliceBottom, sliceLeft, sliceBottom, texWidth, texHeight);
        GuiElementDuex cornerBottomRight = new GuiElementDuex(texWidth - sliceRight, texHeight - sliceBottom, sliceRight, sliceBottom, texWidth, texHeight);
        GuiElementScalable borderTop = new GuiElementScalable(sliceLeft, 0, texWidth - sliceLeft - sliceRight, sliceTop, texWidth, texHeight);
        GuiElementScalable borderBottom = new GuiElementScalable(sliceLeft, texHeight - sliceBottom, texWidth - sliceLeft - sliceRight, sliceBottom, texWidth, texHeight);
        GuiElementScalable borderLeft = new GuiElementScalable(0, sliceTop, sliceLeft, texHeight - sliceTop - sliceBottom, texWidth, texHeight);
        GuiElementScalable borderRight = new GuiElementScalable(texWidth - sliceRight, sliceTop, sliceRight, texHeight - sliceTop - sliceBottom, texWidth, texHeight);
        GuiElementScalable center = new GuiElementScalable(sliceLeft, sliceTop, texWidth - sliceLeft - sliceRight, texHeight - sliceTop - sliceBottom, texWidth, texHeight);
        int midW = width - borderLeft.w - borderRight.w;
        int midH = height - borderTop.h - borderBottom.h;
        int x = xPos;
        int y = yPos;
        x += cornerTopLeft.draw(x, y);
        x += borderTop.drawScaledX(x, y, midW);
        cornerTopRight.draw(x, y);
        x = xPos;
        x += borderLeft.drawScaledY(x, y += borderTop.h, midH);
        x += center.drawScaled(x, y, midW, midH);
        borderRight.drawScaledY(x, y, midH);
        x = xPos;
        x += cornerBottomLeft.draw(x, y += midH);
        x += borderBottom.drawScaledX(x, y, midW);
        cornerBottomRight.draw(x, y);
    }
}

