/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.NBTJson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class BookmarkRecipeId {
    public int position = -1;
    public int recipetype = -1;
    public String handlerName = null;
    public List<NBTTagCompound> ingredients = new ArrayList<NBTTagCompound>();

    public BookmarkRecipeId(String handlerName, List<PositionedStack> stacks) {
        this.handlerName = handlerName;
        for (PositionedStack pos : stacks) {
            NBTTagCompound nbt = StackInfo.itemStackToNBT(this.getItemStackWithMinimumDamage(pos.items));
            if (nbt == null) continue;
            this.ingredients.add(nbt);
        }
    }

    public BookmarkRecipeId(JsonObject json) {
        JsonArray arr;
        List<NBTTagCompound> ingredients;
        if (json.get("handlerName") != null) {
            this.handlerName = json.get("handlerName").getAsString();
        }
        if (json.get("ingredients") != null && (ingredients = this.convertJsonArrayToIngredients(arr = (JsonArray)json.get("ingredients"))) != null) {
            this.ingredients = ingredients;
        }
    }

    public boolean equalsIngredients(List<PositionedStack> stacks) {
        if (this.ingredients.size() != stacks.size()) {
            return false;
        }
        Short idx = 0;
        for (PositionedStack pStack : stacks) {
            NBTTagCompound tagCompoundA = StackInfo.itemStackToNBT(this.getItemStackWithMinimumDamage(pStack.items));
            NBTTagCompound tagCompoundB = this.ingredients.get(idx.shortValue());
            if (tagCompoundB == null || !tagCompoundA.equals((Object)tagCompoundB)) {
                return false;
            }
            Short s = idx;
            Short s2 = idx = Short.valueOf((short)(idx + 1));
        }
        return true;
    }

    public ItemStack getItemStackWithMinimumDamage(ItemStack[] stacks) {
        int damage = Short.MAX_VALUE;
        ItemStack result = stacks[0];
        if (stacks.length > 1) {
            for (ItemStack stack : stacks) {
                if (stack.func_77960_j() >= damage) continue;
                damage = stack.func_77960_j();
                result = stack;
            }
        }
        return result.func_77946_l();
    }

    public JsonObject toJsonObject() {
        JsonObject json = new JsonObject();
        if (this.handlerName != null) {
            json.add("handlerName", (JsonElement)new JsonPrimitive(this.handlerName));
            json.add("ingredients", (JsonElement)this.convertIngredientsToJsonArray(this.ingredients));
        }
        return json;
    }

    protected List<NBTTagCompound> convertJsonArrayToIngredients(JsonArray arr) {
        ArrayList<NBTTagCompound> ingredients = new ArrayList<NBTTagCompound>();
        for (JsonElement elem : arr) {
            NBTTagCompound nbt = (NBTTagCompound)NBTJson.toNbt(elem);
            if (nbt == null) {
                return null;
            }
            ingredients.add(nbt);
        }
        return ingredients;
    }

    protected JsonArray convertIngredientsToJsonArray(List<NBTTagCompound> ingredients) {
        JsonArray arr = new JsonArray();
        for (NBTTagCompound nbTag : ingredients) {
            arr.add(NBTJson.toJsonObject((NBTBase)nbTag));
        }
        return arr;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof BookmarkRecipeId) {
            BookmarkRecipeId anRecipeId = (BookmarkRecipeId)anObject;
            if (!this.handlerName.equals(anRecipeId.handlerName)) {
                return false;
            }
            if (this.ingredients.size() != anRecipeId.ingredients.size()) {
                return false;
            }
            for (int idx = 0; idx < this.ingredients.size(); ++idx) {
                if (this.ingredients.get(idx).equals((Object)anRecipeId.ingredients.get(idx))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

