/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.guihook;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.guihook.DefaultSlotClickHandler;
import codechicken.nei.guihook.HideousLinkedList;
import codechicken.nei.guihook.IContainerDrawHandler;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerObjectHandler;
import codechicken.nei.guihook.IContainerSlotClickHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.guihook.IGuiClientSide;
import codechicken.nei.guihook.IGuiHandleMouseWheel;
import codechicken.nei.guihook.IGuiSlotDraw;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiContainerManager {
    public GuiContainer window;
    public static RenderItem drawItems = new RenderItem();
    public static final LinkedList<IContainerTooltipHandler> tooltipHandlers = new HideousLinkedList<IContainerTooltipHandler>(new CopyOnWriteArrayList());
    public static final LinkedList<IContainerInputHandler> inputHandlers = new HideousLinkedList<IContainerInputHandler>(new CopyOnWriteArrayList());
    public static final LinkedList<IContainerDrawHandler> drawHandlers = new HideousLinkedList<IContainerDrawHandler>(new CopyOnWriteArrayList());
    public static final LinkedList<IContainerObjectHandler> objectHandlers = new HideousLinkedList<IContainerObjectHandler>(new CopyOnWriteArrayList());
    public static final LinkedList<IContainerSlotClickHandler> slotClickHandlers = new HideousLinkedList<IContainerSlotClickHandler>(new CopyOnWriteArrayList());
    private static int modelviewDepth;
    private static final HashSet<String> stackTraces;
    private int clickHandled = 0;
    private final List<IContainerTooltipHandler> instanceTooltipHandlers;

    public static GuiContainerManager getManager() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        return gui instanceof GuiContainer ? GuiContainerManager.getManager((GuiContainer)gui) : null;
    }

    public static GuiContainerManager getManager(GuiContainer gui) {
        return null;
    }

    public static void addTooltipHandler(IContainerTooltipHandler handler) {
        tooltipHandlers.add(handler);
    }

    public static void addInputHandler(IContainerInputHandler handler) {
        inputHandlers.add(handler);
    }

    public static void addDrawHandler(IContainerDrawHandler handler) {
        drawHandlers.add(handler);
    }

    public static void addObjectHandler(IContainerObjectHandler handler) {
        objectHandlers.add(handler);
    }

    public static void addSlotClickHandler(IContainerSlotClickHandler handler) {
        slotClickHandlers.addFirst(handler);
    }

    public static FontRenderer getFontRenderer(ItemStack stack) {
        FontRenderer f;
        if (stack != null && stack.func_77973_b() != null && (f = stack.func_77973_b().getFontRenderer(stack)) != null) {
            return f;
        }
        return GuiDraw.fontRenderer;
    }

    public static List<String> itemDisplayNameMultiline(ItemStack stack, GuiContainer gui, boolean includeHandlers) {
        List<String> namelist = null;
        try {
            namelist = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, includeHandlers && Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<String>();
        }
        if (namelist.size() == 0) {
            namelist.add("Unnamed");
        }
        if (namelist.get(0) == null || ((String)namelist.get(0)).equals("")) {
            namelist.set(0, "Unnamed");
        }
        if (includeHandlers) {
            for (IContainerTooltipHandler handler : tooltipHandlers) {
                namelist = handler.handleItemDisplayName(gui, stack, namelist);
            }
        }
        namelist.set(0, stack.func_77953_t().field_77937_e.toString() + (String)namelist.get(0));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, "\u00a77" + namelist.get(i));
        }
        return namelist;
    }

    public static String itemDisplayNameShort(ItemStack itemstack) {
        List<String> list = GuiContainerManager.itemDisplayNameMultiline(itemstack, null, false);
        return list.get(0);
    }

    public static String concatenatedDisplayName(ItemStack itemstack, boolean includeHandlers) {
        List<String> list = GuiContainerManager.itemDisplayNameMultiline(itemstack, null, includeHandlers);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String name : list) {
            if (first) {
                first = false;
            } else {
                sb.append("#");
            }
            sb.append(name);
        }
        return EnumChatFormatting.func_110646_a((String)sb.toString());
    }

    public static void drawItem(int i, int j, ItemStack itemstack) {
        GuiContainerManager.drawItem(i, j, itemstack, GuiContainerManager.getFontRenderer(itemstack));
    }

    public static void drawItem(int i, int j, ItemStack itemstack, boolean smallAmount) {
        GuiContainerManager.drawItem(i, j, itemstack, GuiContainerManager.getFontRenderer(itemstack), smallAmount);
    }

    public static void drawItem(int i, int j, ItemStack itemstack, FontRenderer fontRenderer) {
        GuiContainerManager.drawItem(i, j, itemstack, fontRenderer, false);
    }

    public static void drawItem(int i, int j, ItemStack itemstack, FontRenderer fontRenderer, boolean smallAmount) {
        GuiContainerManager.enable3DRender();
        float zLevel = GuiContainerManager.drawItems.field_77023_b += 100.0f;
        try {
            drawItems.func_82406_b(fontRenderer, GuiDraw.renderEngine, itemstack, i, j);
            if (!smallAmount) {
                drawItems.func_77021_b(fontRenderer, GuiDraw.renderEngine, itemstack, i, j);
            } else if (itemstack.field_77994_a > 1) {
                GuiContainerManager.drawBigStackSize(i, j, itemstack.field_77994_a);
            }
            if (!GuiContainerManager.checkMatrixStack()) {
                throw new IllegalStateException("Modelview matrix stack too deep");
            }
            if (Tessellator.field_78398_a.field_78415_z) {
                throw new IllegalStateException("Still drawing");
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stackTrace = itemstack + sw.toString();
            if (!stackTraces.contains(stackTrace)) {
                System.err.println("Error while rendering: " + itemstack);
                e.printStackTrace();
                stackTraces.add(stackTrace);
            }
            GuiContainerManager.restoreMatrixStack();
            if (Tessellator.field_78398_a.field_78415_z) {
                Tessellator.field_78398_a.func_78381_a();
            }
            GuiContainerManager.drawItems.field_77023_b = zLevel;
            drawItems.func_77015_a(fontRenderer, GuiDraw.renderEngine, new ItemStack((Block)Blocks.field_150480_ab), i, j);
        }
        GuiContainerManager.enable2DRender();
        GuiContainerManager.drawItems.field_77023_b = zLevel - 100.0f;
    }

    protected static void drawBigStackSize(int offsetX, int offsetY, int amount) {
        float scaleFactor = GuiDraw.fontRenderer.func_82883_a() ? 0.85f : 0.5f;
        float inverseScaleFactor = 1.0f / scaleFactor;
        String stackSize = String.valueOf(amount);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glScaled((double)scaleFactor, (double)scaleFactor, (double)scaleFactor);
        int X = (int)(((float)offsetX + 16.0f - (float)GuiDraw.fontRenderer.func_78256_a(stackSize) * scaleFactor) * inverseScaleFactor);
        int Y = (int)(((float)offsetY + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
        GuiDraw.fontRenderer.func_78261_a(stackSize, X, Y, 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public static void enableMatrixStackLogging() {
        modelviewDepth = GL11.glGetInteger((int)2979);
    }

    public static void disableMatrixStackLogging() {
        modelviewDepth = -1;
    }

    public static boolean checkMatrixStack() {
        return modelviewDepth < 0 || GL11.glGetInteger((int)2979) == modelviewDepth;
    }

    public static void restoreMatrixStack() {
        if (modelviewDepth >= 0) {
            for (int i = GL11.glGetInteger((int)2979); i > modelviewDepth; --i) {
                GL11.glPopMatrix();
            }
        }
    }

    public static void setColouredItemRender(boolean enable) {
        GuiContainerManager.drawItems.field_77024_a = !enable;
    }

    public static void enable3DRender() {
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public static void enable2DRender() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    public GuiContainerManager(GuiContainer screen) {
        this.window = screen;
        if (screen instanceof IContainerTooltipHandler) {
            this.instanceTooltipHandlers = Collections.synchronizedList(new LinkedList());
            this.instanceTooltipHandlers.add((IContainerTooltipHandler)screen);
            this.instanceTooltipHandlers.addAll(tooltipHandlers);
        } else {
            this.instanceTooltipHandlers = tooltipHandlers;
        }
    }

    public static ItemStack getStackMouseOver(GuiContainer window) {
        Point mousePos = GuiDraw.getMousePosition();
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            ItemStack item = objectHandler.getStackUnderMouse(window, mousePos.x, mousePos.y);
            if (item == null) continue;
            return item;
        }
        Slot slot = GuiContainerManager.getSlotMouseOver(window);
        if (slot != null) {
            return slot.func_75211_c();
        }
        return null;
    }

    public static Slot getSlotMouseOver(GuiContainer window) {
        Point mousePos = GuiDraw.getMousePosition();
        if (GuiContainerManager.getManager(window).objectUnderMouse(mousePos.x, mousePos.y)) {
            return null;
        }
        return window.func_146975_c(mousePos.x, mousePos.y);
    }

    public void load() {
        this.clickHandled = 0;
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            objectHandler.load(this.window);
        }
    }

    public void updateScreen() {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            objectHandler.guiTick(this.window);
        }
    }

    public boolean lastKeyTyped(int keyID, char keyChar) {
        if (keyID == 1) {
            return false;
        }
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.lastKeyTyped(this.window, keyChar, keyID)) continue;
            return true;
        }
        return false;
    }

    public boolean firstKeyTyped(char keyChar, int keyID) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onKeyTyped(this.window, keyChar, keyID);
        }
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.keyTyped(this.window, keyChar, keyID)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(int mousex, int mousey, int button) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseClicked(this.window, mousex, mousey, button);
        }
        for (IContainerInputHandler inputhander : inputHandlers) {
            if (!inputhander.mouseClicked(this.window, mousex, mousey, button)) continue;
            this.clickHandled |= 1 << button;
            return true;
        }
        return false;
    }

    public void mouseScrolled(int scrolled) {
        Point mousepos = GuiDraw.getMousePosition();
        for (IContainerInputHandler inputHandler : inputHandlers) {
            inputHandler.onMouseScrolled(this.window, mousepos.x, mousepos.y, scrolled);
        }
        for (IContainerInputHandler inputHandler : inputHandlers) {
            if (!inputHandler.mouseScrolled(this.window, mousepos.x, mousepos.y, scrolled)) continue;
            return;
        }
        if (this.window instanceof IGuiHandleMouseWheel) {
            ((IGuiHandleMouseWheel)this.window).mouseScrolled(scrolled);
        }
    }

    public boolean overrideMouseUp(int mousex, int mousey, int button) {
        if (button >= 0 && (this.clickHandled & 1 << button) != 0) {
            this.clickHandled &= ~(1 << button);
            this.mouseUp(mousex, mousey, button);
            return true;
        }
        return false;
    }

    public void mouseUp(int mousex, int mousey, int button) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseUp(this.window, mousex, mousey, button);
        }
    }

    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        for (IContainerInputHandler inputhander : inputHandlers) {
            inputhander.onMouseDragged(this.window, mousex, mousey, button, heldTime);
        }
    }

    public void preDraw() {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.onPreDraw(this.window);
        }
    }

    public void renderObjects(int mousex, int mousey) {
        GL11.glTranslatef((float)(-this.window.field_147003_i), (float)(-this.window.field_147009_r), (float)200.0f);
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderObjects(this.window, mousex, mousey);
        }
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.postRenderObjects(this.window, mousex, mousey);
        }
        GL11.glTranslatef((float)this.window.field_147003_i, (float)this.window.field_147009_r, (float)-200.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderToolTips(int mousex, int mousey) {
        List<String> tooltip = new LinkedList<String>();
        FontRenderer font = GuiDraw.fontRenderer;
        List<IContainerTooltipHandler> list = this.instanceTooltipHandlers;
        synchronized (list) {
            for (IContainerTooltipHandler handler : this.instanceTooltipHandlers) {
                tooltip = handler.handleTooltip(this.window, mousex, mousey, tooltip);
            }
        }
        if (tooltip.isEmpty() && GuiContainerManager.shouldShowTooltip(this.window)) {
            ItemStack stack = GuiContainerManager.getStackMouseOver(this.window);
            font = GuiContainerManager.getFontRenderer(stack);
            if (stack != null) {
                tooltip = GuiContainerManager.itemDisplayNameMultiline(stack, this.window, true);
            }
            List<IContainerTooltipHandler> list2 = this.instanceTooltipHandlers;
            synchronized (list2) {
                for (IContainerTooltipHandler handler : this.instanceTooltipHandlers) {
                    tooltip = handler.handleItemTooltip(this.window, stack, mousex, mousey, tooltip);
                }
            }
        }
        if (tooltip.size() > 0) {
            tooltip.set(0, tooltip.get(0) + "\u00a7h");
        }
        GuiDraw.drawMultilineTip((FontRenderer)font, (int)(mousex + 12), (int)(mousey - 12), tooltip);
    }

    public static boolean shouldShowTooltip(GuiContainer window) {
        for (IContainerObjectHandler handler : objectHandlers) {
            if (handler.shouldShowTooltip(window)) continue;
            return false;
        }
        return window.field_146297_k.field_71439_g.field_71071_by.func_70445_o() == null;
    }

    public void renderSlotUnderlay(Slot slot) {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderSlotUnderlay(this.window, slot);
        }
    }

    public void renderSlotOverlay(Slot slot) {
        for (IContainerDrawHandler drawHandler : drawHandlers) {
            drawHandler.renderSlotOverlay(this.window, slot);
        }
        GL11.glEnable((int)3008);
    }

    public boolean objectUnderMouse(int mousex, int mousey) {
        for (IContainerObjectHandler objectHandler : objectHandlers) {
            if (!objectHandler.objectUnderMouse(this.window, mousex, mousey)) continue;
            return true;
        }
        return false;
    }

    public void handleMouseClick(Slot slot, int slotIndex, int button, int modifier) {
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            handler.beforeSlotClick(this.window, slotIndex, button, slot, modifier);
        }
        boolean eventHandled = false;
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            eventHandled = handler.handleSlotClick(this.window, slotIndex, button, slot, modifier, eventHandled);
        }
        for (IContainerSlotClickHandler handler : slotClickHandlers) {
            handler.afterSlotClick(this.window, slotIndex, button, slot, modifier);
        }
    }

    public void handleKeyboardInput() {
        int k = Keyboard.getEventKey();
        char c = Keyboard.getEventCharacter();
        if (Keyboard.getEventKeyState() || k == 0 && Character.isDefined(c)) {
            try {
                this.keyTyped(c, k);
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println("Caught out of bounds exception pressing " + c + " " + k);
                e.printStackTrace();
            }
        }
        this.window.field_146297_k.func_152348_aa();
    }

    public void keyTyped(char c, int k) {
        if (this.firstKeyTyped(c, k)) {
            return;
        }
        GuiContainerManager.callKeyTyped(this.window, c, k);
    }

    private static void callKeyTyped(GuiContainer window, char c, int k) {
    }

    public void drawSlotItem(Slot slot, ItemStack stack, int x, int y, String quantity) {
        if (this.window instanceof IGuiSlotDraw) {
            ((IGuiSlotDraw)this.window).drawSlotItem(slot, stack, x, y, quantity);
        } else {
            drawItems.func_82406_b(GuiDraw.fontRenderer, this.window.field_146297_k.func_110434_K(), stack, x, y);
            drawItems.func_94148_a(GuiDraw.fontRenderer, this.window.field_146297_k.func_110434_K(), stack, x, y, quantity);
        }
    }

    public void handleSlotClick(int slotIndex, int button, int modifiers) {
        if (slotIndex == -1) {
            return;
        }
        if (this.window instanceof IGuiClientSide) {
            this.window.field_146297_k.field_71439_g.field_71070_bA.func_75144_a(slotIndex, button, modifiers, (EntityPlayer)this.window.field_146297_k.field_71439_g);
        } else {
            this.window.field_146297_k.field_71442_b.func_78753_a(this.window.field_147002_h.field_75152_c, slotIndex, button, modifiers, (EntityPlayer)this.window.field_146297_k.field_71439_g);
        }
    }

    public void handleMouseWheel() {
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            this.mouseScrolled(i > 0 ? 1 : -1);
        }
    }

    static {
        GuiContainerManager.addSlotClickHandler(new DefaultSlotClickHandler());
        modelviewDepth = -1;
        stackTraces = new HashSet();
    }
}

