/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.nei.NEIChestGuiHandler;
import codechicken.nei.NEICreativeGuiHandler;
import codechicken.nei.NEIDummySlotHandler;
import codechicken.nei.api.API;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.recipe.GuiRecipeCatalyst;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;

public class GuiInfo {
    public static final LinkedList<INEIGuiHandler> guiHandlers = new LinkedList();
    public static final HashSet<Class<? extends GuiContainer>> customSlotGuis = new HashSet();
    public static ReentrantReadWriteLock guiHandlersLock = new ReentrantReadWriteLock();
    public static Lock writeLock = guiHandlersLock.writeLock();
    public static Lock readLock = guiHandlersLock.readLock();

    public static void load() {
        API.registerNEIGuiHandler(new NEICreativeGuiHandler());
        API.registerNEIGuiHandler(new NEIChestGuiHandler());
        API.registerNEIGuiHandler(new NEIDummySlotHandler());
        API.registerNEIGuiHandler(new GuiRecipeCatalyst(null));
        customSlotGuis.add(GuiContainerCreative.class);
    }

    public static void clearGuiHandlers() {
        try {
            writeLock.lock();
            guiHandlers.removeIf(ineiGuiHandler -> ineiGuiHandler instanceof GuiContainer);
        }
        finally {
            writeLock.unlock();
        }
    }

    public static boolean hasCustomSlots(GuiContainer gui) {
        return customSlotGuis.contains(gui.getClass());
    }
}

