/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.ItemPanel;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.StackInfo;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class ItemsGrid {
    public static final int SLOT_SIZE = 18;
    protected int width;
    protected int height;
    protected int marginLeft;
    protected int marginTop;
    protected ArrayList<ItemStack> realItems = new ArrayList();
    protected int page;
    protected int perPage;
    protected int firstIndex;
    protected int numPages;
    protected int rows;
    protected int columns;
    protected boolean[] validSlotMap;
    protected boolean[] invalidSlotMap;

    public ArrayList<ItemStack> getItems() {
        return this.realItems;
    }

    public ItemStack getItem(int idx) {
        return this.realItems.get(idx);
    }

    public int size() {
        return this.realItems.size();
    }

    public int indexOf(ItemStack stackA, boolean useNBT) {
        for (int idx = 0; idx < this.realItems.size(); ++idx) {
            if (!StackInfo.equalItemAndNBT(stackA, this.realItems.get(idx), useNBT)) continue;
            return idx;
        }
        return -1;
    }

    public int getPage() {
        return this.page + 1;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public int getNumPages() {
        return this.numPages;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setGridSize(int mleft, int mtop, int w, int h) {
        this.marginLeft = mleft;
        this.marginTop = mtop;
        this.width = Math.max(0, w);
        this.height = Math.max(0, h);
        this.columns = this.width / 18;
        this.rows = this.height / 18;
    }

    public void shiftPage(int shift) {
        if (this.perPage == 0) {
            this.numPages = 0;
            this.page = 0;
            return;
        }
        this.numPages = (int)Math.ceil((float)this.realItems.size() / (float)this.perPage);
        this.page += shift;
        if (this.page >= this.numPages) {
            this.page -= this.numPages;
        }
        if (this.page < 0) {
            this.page = this.numPages + this.page;
        }
        this.page = Math.max(0, Math.min(this.page, this.numPages - 1));
    }

    public void refresh(GuiContainer gui) {
        this.updateGuiOverlapSlots(gui);
        this.shiftPage(0);
    }

    private void updateGuiOverlapSlots(GuiContainer gui) {
        this.invalidSlotMap = new boolean[this.rows * this.columns];
        this.perPage = this.columns * this.rows;
        this.checkGuiOverlap(gui, 0, this.columns - 2, 1);
        this.checkGuiOverlap(gui, this.columns - 1, 1, -1);
    }

    private void checkGuiOverlap(GuiContainer gui, int start, int end, int dir) {
        boolean validColumn = false;
        for (int c = start; c != end && !validColumn; c += dir) {
            validColumn = true;
            for (int r = 0; r < this.rows; ++r) {
                int idx = this.columns * r + c;
                if (this.slotValid(gui, r, c) || idx < 0 || idx >= this.invalidSlotMap.length || this.invalidSlotMap[idx]) continue;
                this.invalidSlotMap[idx] = true;
                validColumn = false;
                --this.perPage;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean slotValid(GuiContainer gui, int row, int column) {
        Rectangle4i rect = this.getSlotRect(row, column);
        try {
            GuiInfo.readLock.lock();
            if (GuiInfo.guiHandlers.stream().anyMatch(handler -> handler.hideItemPanelSlot(gui, rect.x, rect.y, rect.w, rect.h))) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            GuiInfo.readLock.unlock();
        }
        return true;
    }

    public Rectangle4i getSlotRect(int i) {
        return this.getSlotRect(i / this.columns, i % this.columns);
    }

    public Rectangle4i getSlotRect(int row, int column) {
        return new Rectangle4i(this.marginLeft + this.width % 18 / 2 + column * 18, this.marginTop + row * 18, 18, 18);
    }

    public boolean isInvalidSlot(int idx) {
        return this.invalidSlotMap[idx];
    }

    public void draw(int mousex, int mousey) {
        if (this.getPerPage() == 0) {
            return;
        }
        ItemPanel.ItemPanelSlot slot = this.getSlotMouseOver(mousex, mousey);
        GuiContainerManager.enableMatrixStackLogging();
        int idx = this.page * this.perPage;
        for (int i = 0; i < this.rows * this.columns && idx < this.size(); ++i) {
            if (this.invalidSlotMap[i]) continue;
            this.drawItem(this.getSlotRect(i), idx, slot);
            ++idx;
        }
        GuiContainerManager.disableMatrixStackLogging();
    }

    protected void drawItem(Rectangle4i rect, int idx, ItemPanel.ItemPanelSlot focus) {
        if (focus != null && focus.slotIndex == idx) {
            GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
        }
        GuiContainerManager.drawItem(rect.x + 1, rect.y + 1, this.getItem(idx));
    }

    public ItemPanel.ItemPanelSlot getSlotMouseOver(int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            return null;
        }
        int overRow = (mousey - this.marginTop) / 18;
        int overColumn = (mousex - this.marginLeft - this.width % 18 / 2) / 18;
        int slt = this.columns * overRow + overColumn;
        int idx = this.page * this.perPage + slt;
        if (overRow >= this.rows || overColumn >= this.columns) {
            return null;
        }
        for (int i = 0; i < slt; ++i) {
            if (!this.invalidSlotMap[i]) continue;
            --idx;
        }
        return idx < this.size() ? new ItemPanel.ItemPanelSlot(idx, this.realItems.get(idx)) : null;
    }

    public boolean contains(int px, int py) {
        if (!new Rectangle4i(this.marginLeft, this.marginTop, this.width, this.height).contains(px, py)) {
            return false;
        }
        int r = (py - this.marginTop) / 18;
        int c = (px - this.marginLeft - this.width % 18 / 2) / 18;
        int slt = this.columns * r + c;
        return r >= this.rows || c >= this.columns || !this.invalidSlotMap[slt];
    }
}

