/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.TextField;

public class ItemQuantityField
extends TextField {
    public ItemQuantityField(String ident) {
        super(ident);
        this.centered = true;
    }

    public int intValue() {
        return this.intValue(this.text());
    }

    public int intValue(String s) {
        try {
            return Math.max(0, Integer.parseInt(s));
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    @Override
    public void gainFocus() {
        if (this.text().equals("0")) {
            this.setText("");
        }
    }

    @Override
    public void loseFocus() {
        this.setText(Integer.toString(NEIClientConfig.getItemQuantity()));
    }

    @Override
    public void onTextChange(String oldText) {
        NEIClientUtils.setItemQuantity(this.intValue());
    }
}

