/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemsGrid;
import codechicken.nei.Label;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PresetsWidget;
import codechicken.nei.Widget;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.StackInfo;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemPanel
extends Widget {
    public ItemStack draggedStack;
    public int mouseDownSlot = -1;
    public Button pagePrev;
    public Button pageNext;
    public Label pageLabel;
    @Deprecated
    private int itemsPerPage = 0;
    @Deprecated
    public static ArrayList<ItemStack> items = new ArrayList();
    @Deprecated
    public ArrayList<ItemStack> realItems = new ArrayList();
    protected Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");
    protected ItemsGrid grid = new ItemPanelGrid();

    public ArrayList<ItemStack> getItems() {
        return this.grid.getItems();
    }

    public static void updateItemList(ArrayList<ItemStack> newItems) {
        ((ItemPanelGrid)ItemPanels.itemPanel.getGrid()).setItems(newItems);
        ItemPanels.itemPanel.realItems = newItems;
    }

    @Deprecated
    public void scroll(int i) {
        this.grid.shiftPage(i);
    }

    public ItemsGrid getGrid() {
        return this.grid;
    }

    public void init() {
        this.pageLabel = new Label("(0/0)", true);
        this.pagePrev = new Button("Prev"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    ItemPanel.this.grid.shiftPage(-1);
                    return true;
                }
                return false;
            }

            @Override
            public String getRenderLabel() {
                return "<";
            }
        };
        this.pageNext = new Button("Next"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    ItemPanel.this.grid.shiftPage(1);
                    return true;
                }
                return false;
            }

            @Override
            public String getRenderLabel() {
                return ">";
            }
        };
    }

    public int getMarginLeft(GuiContainer gui) {
        if (gui instanceof GuiContainerCreative && NEIClientUtils.getGamemode() == 2) {
            return (gui.field_146294_l + 176) / 2 + 2;
        }
        return (gui.field_146294_l + gui.field_146999_f) / 2 + 2;
    }

    public int getMarginTop(GuiContainer gui) {
        return 2;
    }

    public int getWidth(GuiContainer gui) {
        return LayoutManager.getSideWidth(gui) - this.getMarginLeft(gui);
    }

    public int getHeight(GuiContainer gui) {
        return gui.field_146295_m - this.getMarginTop(gui) - 19;
    }

    public String getLabelText() {
        return "(" + this.getPage() + "/" + Math.max(1, this.getNumPages()) + ")";
    }

    public void resize(GuiContainer gui) {
        int marginLeft = this.getMarginLeft(gui);
        int marginTop = this.getMarginTop(gui);
        int width = this.getWidth(gui);
        int height = this.getHeight(gui);
        int buttonHeight = 16;
        int buttonWidth = 16;
        this.pageNext.w = 16;
        this.pagePrev.w = 16;
        this.pageNext.h = 16;
        this.pagePrev.h = 16;
        this.pagePrev.y = this.pageNext.y = marginTop;
        this.pagePrev.x = marginLeft;
        this.pageNext.x = marginLeft + width - 16;
        this.pageLabel.x = marginLeft + width / 2;
        this.pageLabel.y = marginTop + 5;
        this.pageLabel.text = this.getLabelText();
        this.y = marginTop + 16 + 2;
        this.x = marginLeft;
        this.w = width;
        this.h = height - 16 - 2;
        this.grid.setGridSize(this.x, this.y, this.w, this.h);
        this.grid.refresh(gui);
    }

    public void setVisible() {
        LayoutManager.addWidget(this.pagePrev);
        LayoutManager.addWidget(this.pageNext);
        LayoutManager.addWidget(this.pageLabel);
    }

    @Override
    public void draw(int mousex, int mousey) {
        this.grid.draw(mousex, mousey);
    }

    @Override
    public void postDraw(int mousex, int mousey) {
        if (this.draggedStack != null) {
            GuiContainerManager.drawItems.field_77023_b += 100.0f;
            GuiContainerManager.drawItem(mousex - 8, mousey - 8, this.draggedStack, true);
            GuiContainerManager.drawItems.field_77023_b -= 100.0f;
        }
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        ItemPanelSlot mouseOverSlot;
        if (this.mouseDownSlot >= 0 && this.draggedStack == null && NEIClientUtils.getHeldItem() == null && NEIClientConfig.hasSMPCounterPart() && !GuiInfo.hasCustomSlots(NEIClientUtils.getGuiContainer()) && ((mouseOverSlot = this.getSlotMouseOver(mousex, mousey)) == null || mouseOverSlot.slotIndex != this.mouseDownSlot || heldTime > 500L)) {
            this.draggedStack = this.getDraggedStackWithQuantity(this.mouseDownSlot);
            this.mouseDownSlot = -1;
        }
    }

    protected ItemStack getDraggedStackWithQuantity(int mouseDownSlot) {
        ItemStack stack = this.grid.getItem(mouseDownSlot);
        if (stack != null) {
            int amount = NEIClientConfig.getItemQuantity();
            if (amount == 0) {
                amount = stack.func_77976_d();
            }
            return NEIServerUtils.copyStack(stack, amount);
        }
        return null;
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (this.handleClickExt(mousex, mousey, button)) {
            return true;
        }
        if (NEIClientUtils.getHeldItem() != null) {
            if (!this.grid.contains(mousex, mousey)) {
                return false;
            }
            if (NEIClientConfig.canPerformAction("delete") && NEIClientConfig.canPerformAction("item")) {
                if (button == 1) {
                    NEIClientUtils.decreaseSlotStack(-999);
                } else {
                    NEIClientUtils.deleteHeldItem();
                }
            } else {
                NEIClientUtils.dropHeldItem();
            }
            return true;
        }
        ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null) {
            if (button == 2) {
                if (hoverSlot.item != null) {
                    this.draggedStack = this.getDraggedStackWithQuantity(hoverSlot.slotIndex);
                }
            } else {
                this.mouseDownSlot = hoverSlot.slotIndex;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleClickExt(int mouseX, int mouseY, int button) {
        if (ItemPanels.itemPanel.draggedStack != null) {
            return ItemPanels.itemPanel.handleDraggedClick(mouseX, mouseY, button);
        }
        if (ItemPanels.bookmarkPanel.draggedStack != null) {
            return ItemPanels.bookmarkPanel.handleDraggedClick(mouseX, mouseY, button);
        }
        return false;
    }

    protected boolean handleDraggedClick(int mouseX, int mouseY, int button) {
        if (this.draggedStack == null) {
            return false;
        }
        if (this.handleFillFluidContainerClick(mouseX, mouseY, button)) {
            return true;
        }
        if (this.handleSearchInputClick(mouseX, mouseY, button)) {
            return true;
        }
        if (this.handleGUIContainerClick(mouseX, mouseY, button)) {
            return true;
        }
        if (this.handleCheatItemClick(mouseX, mouseY, button)) {
            return true;
        }
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        if (mouseX < gui.field_147003_i || mouseY < gui.field_147009_r || mouseX >= gui.field_147003_i + gui.field_146999_f || mouseY >= gui.field_147009_r + gui.field_147000_g) {
            this.draggedStack = null;
        }
        return true;
    }

    protected boolean handleFillFluidContainerClick(int mouseX, int mouseY, int button) {
        if (button == 2) {
            return false;
        }
        ItemPanelSlot mouseOverSlot = ItemPanels.itemPanel.getSlotMouseOver(mouseX, mouseY);
        if (mouseOverSlot == null) {
            mouseOverSlot = ItemPanels.bookmarkPanel.getSlotMouseOver(mouseX, mouseY);
        }
        if (mouseOverSlot != null && this.draggedStack.func_77973_b() instanceof IFluidContainerItem) {
            FluidStack fluidStack = StackInfo.getFluid(mouseOverSlot.item);
            if (fluidStack != null) {
                int stackSize = this.draggedStack.field_77994_a;
                fluidStack = fluidStack.copy();
                if (fluidStack.amount == 0) {
                    fluidStack.amount = 1000;
                }
                if (mouseOverSlot.item.field_77994_a > 1) {
                    fluidStack.amount *= mouseOverSlot.item.field_77994_a;
                }
                this.draggedStack.field_77994_a = 1;
                ((IFluidContainerItem)this.draggedStack.func_77973_b()).fill(this.draggedStack, fluidStack, true);
                this.draggedStack.field_77994_a = stackSize;
                if (button == 1 && ((IFluidContainerItem)this.draggedStack.func_77973_b()).getFluid(this.draggedStack) != null) {
                    ItemPanels.bookmarkPanel.addOrRemoveItem(this.draggedStack.func_77946_l());
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleGUIContainerClick(int mouseX, int mouseY, int button) {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        boolean handled = false;
        try {
            GuiInfo.readLock.lock();
            for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
                if (!handler.handleDragNDrop(gui, mouseX, mouseY, this.draggedStack, button)) continue;
                handled = true;
                break;
            }
        }
        finally {
            GuiInfo.readLock.unlock();
        }
        if (this.draggedStack.field_77994_a == 0) {
            this.draggedStack = null;
        }
        return handled;
    }

    protected boolean handleCheatItemClick(int mouseX, int mouseY, int button) {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        Slot overSlot = gui.func_146975_c(mouseX, mouseY);
        if (overSlot != null && overSlot.func_75214_a(this.draggedStack)) {
            if (NEIClientConfig.canCheatItem(this.draggedStack)) {
                int total;
                int add;
                int contents = overSlot.func_75216_d() ? overSlot.func_75211_c().field_77994_a : 0;
                int n = add = button == 0 ? this.draggedStack.field_77994_a : 1;
                if (overSlot.func_75216_d() && !NEIServerUtils.areStacksSameType(this.draggedStack, overSlot.func_75211_c())) {
                    contents = 0;
                }
                if ((total = Math.min(contents + add, Math.min(overSlot.func_75219_a(), this.draggedStack.func_77976_d()))) > contents) {
                    NEIClientUtils.setSlotContents(overSlot.field_75222_d, NEIServerUtils.copyStack(this.draggedStack, total), true);
                    NEICPH.sendGiveItem(NEIServerUtils.copyStack(this.draggedStack, total), false, false);
                    this.draggedStack.field_77994_a -= total - contents;
                }
                if (this.draggedStack.field_77994_a == 0) {
                    this.draggedStack = null;
                }
            } else {
                this.draggedStack = null;
            }
            return true;
        }
        return false;
    }

    protected boolean handleSearchInputClick(int mouseX, int mouseY, int button) {
        if (LayoutManager.searchField.contains(mouseX, mouseY)) {
            FluidStack fluidStack = StackInfo.getFluid(this.draggedStack);
            if (fluidStack != null) {
                LayoutManager.searchField.setText(this.SPECIAL_REGEX_CHARS.matcher(EnumChatFormatting.func_110646_a((String)fluidStack.getLocalizedName())).replaceAll("\\\\$0"));
            } else {
                LayoutManager.searchField.setText(this.SPECIAL_REGEX_CHARS.matcher(EnumChatFormatting.func_110646_a((String)this.draggedStack.func_82833_r())).replaceAll("\\\\$0"));
            }
            return true;
        }
        return false;
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null && hoverSlot.slotIndex == this.mouseDownSlot && this.draggedStack == null) {
            ItemStack item = hoverSlot.item;
            if (NEIController.manager.window instanceof GuiRecipe || !NEIClientConfig.canCheatItem(item)) {
                if (button == 0) {
                    GuiCraftingRecipe.openRecipeGui("item", item);
                } else if (button == 1) {
                    GuiUsageRecipe.openRecipeGui("item", item);
                }
                this.mouseDownSlot = -1;
                return;
            }
            NEIClientUtils.cheatItem(this.getDraggedStackWithQuantity(hoverSlot.slotIndex), button, -1);
        }
        this.mouseDownSlot = -1;
    }

    @Override
    public boolean onMouseWheel(int i, int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        this.grid.shiftPage(-i);
        return true;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        if (keyID == NEIClientConfig.getKeyBinding("gui.next")) {
            this.grid.shiftPage(1);
            return true;
        }
        if (keyID == NEIClientConfig.getKeyBinding("gui.prev")) {
            this.grid.shiftPage(-1);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        ItemPanelSlot slot = this.getSlotMouseOver(mousex, mousey);
        return slot == null ? null : slot.item;
    }

    public ItemPanelSlot getSlotMouseOver(int mousex, int mousey) {
        return this.grid.getSlotMouseOver(mousex, mousey);
    }

    public int getPage() {
        return this.grid.page + 1;
    }

    public int getNumPages() {
        return this.grid.numPages;
    }

    @Override
    public boolean contains(int px, int py) {
        return this.grid.contains(px, py);
    }

    protected static class ItemPanelGrid
    extends ItemsGrid {
        public ArrayList<ItemStack> newItems;

        protected ItemPanelGrid() {
        }

        public void setItems(ArrayList<ItemStack> items) {
            this.newItems = items;
        }

        @Override
        public void refresh(GuiContainer gui) {
            if (this.newItems != null) {
                this.realItems = this.newItems;
                this.newItems = null;
            }
            super.refresh(gui);
        }

        @Override
        protected void drawItem(Rectangle4i rect, int idx, ItemPanelSlot focus) {
            if (PresetsWidget.inEditMode() && !PresetsWidget.isHidden(this.getItem(idx))) {
                GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
            }
            super.drawItem(rect, idx, PresetsWidget.inEditMode() ? null : focus);
        }
    }

    public static class ItemPanelSlot {
        public ItemStack item;
        public int slotIndex;

        public ItemPanelSlot(int idx, ItemStack stack) {
            this.slotIndex = idx;
            this.item = stack;
        }

        @Deprecated
        public ItemPanelSlot(int idx) {
            this(idx, ItemPanels.itemPanel.getGrid().getItem(idx));
        }
    }
}

