/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ClientUtils;
import codechicken.core.GuiModListScroll;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.DefaultHighlightHandler;
import codechicken.nei.HUDRenderer;
import codechicken.nei.KeyManager;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.WorldOverlayRenderer;
import codechicken.nei.api.API;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.shadow.org.apache.commons.csv.CSVFormat;
import codechicken.nei.shadow.org.apache.commons.csv.CSVParser;
import codechicken.nei.shadow.org.apache.commons.csv.CSVRecord;
import com.google.common.collect.Lists;
import cpw.mods.fml.client.CustomModLoadingErrorDisplayException;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.io.IOUtils;

public class ClientHandler {
    private static String[] defaultSerialHandlers = new String[]{"WayofTime.alchemicalWizardry.client.nei.NEIAlchemyRecipeHandler"};
    private static String[] defaultHeightHackHandlerRegex = new String[]{"buildcraft.compat.nei.*", "cofh.thermalexpansion.plugins.nei.handlers.*", "crazypants.enderio.nei.*", "forestry.factory.recipes.nei.*", "ic2.neiIntegration.core.recipehandler.*", "mariculture.plugins.nei.*", "redgear.brewcraft.plugins.nei.*", "tconstruct.plugins.nei.*", "WayofTime.alchemicalWizardry.client.nei.*"};
    private static String[] defaultHandlerOrdering = new String[]{"# Each line in this file should either be a comment (starts with '#') or an ordering.", "# Ordering lines are <handler ID>,<ordering number>.", "# Handlers will be sorted in order of number ascending, so smaller numbers first.", "# Any handlers that are missing from this file will be assigned to 0.", "# Negative numbers are fine.", "# If you delete this file, it will be regenerated with all registered handler IDs."};
    private static ClientHandler instance;
    private ArrayList<EntityItem> SMPmagneticItems = new ArrayList();
    private World lastworld;
    private GuiScreen lastGui;

    public void addSMPMagneticItem(int i, World world) {
        WorldClient cworld = (WorldClient)world;
        Entity e = cworld.func_73045_a(i);
        if (!(e instanceof EntityItem)) {
            return;
        }
        this.SMPmagneticItems.add((EntityItem)e);
    }

    private void updateMagnetMode(World world, EntityPlayerSP player) {
        if (!NEIClientConfig.getMagnetMode()) {
            return;
        }
        float distancexz = 16.0f;
        float distancey = 8.0f;
        double maxspeedxz = 0.5;
        double maxspeedy = 0.5;
        double speedxz = 0.05;
        double speedy = 0.07;
        List<Object> items = world.field_72995_K ? this.SMPmagneticItems : world.func_72872_a(EntityItem.class, player.field_70121_D.func_72314_b((double)distancexz, (double)distancey, (double)distancexz));
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            double rationspeedy;
            EntityItem item = (EntityItem)iterator.next();
            if (item.field_145804_b > 0) continue;
            if (item.field_70128_L && world.field_72995_K) {
                iterator.remove();
            }
            if (!NEIClientUtils.canItemFitInInventory((EntityPlayer)player, item.func_92059_d())) continue;
            double dx = player.field_70165_t - item.field_70165_t;
            double dy = player.field_70163_u + (double)player.func_70047_e() - item.field_70163_u;
            double dz = player.field_70161_v - item.field_70161_v;
            double absxz = Math.sqrt(dx * dx + dz * dz);
            double absy = Math.abs(dy);
            if (absxz > (double)distancexz) continue;
            if (absxz > 1.0) {
                dx /= absxz;
                dz /= absxz;
            }
            if (absy > 1.0) {
                dy /= absy;
            }
            double vx = item.field_70159_w + speedxz * dx;
            double vy = item.field_70181_x + speedy * dy;
            double vz = item.field_70179_y + speedxz * dz;
            double absvxz = Math.sqrt(vx * vx + vz * vz);
            double absvy = Math.abs(vy);
            double rationspeedxz = absvxz / maxspeedxz;
            if (rationspeedxz > 1.0) {
                vx /= rationspeedxz;
                vz /= rationspeedxz;
            }
            if ((rationspeedy = absvy / maxspeedy) > 1.0) {
                vy /= rationspeedy;
            }
            if (absvxz < 0.2 && absxz < 0.2 && world.field_72995_K) {
                item.func_70106_y();
            }
            item.func_70016_h(vx, vy, vz);
        }
    }

    public static void preInit() {
        ClientHandler.loadSerialHandlers();
        ClientHandler.loadHeightHackHandlers();
        ItemInfo.preInit();
        StackInfo.loadGuidFilters();
    }

    public static void loadSerialHandlers() {
        Throwable throwable;
        File file = NEIClientConfig.serialHandlersFile;
        if (!file.exists()) {
            try {
                throwable = null;
                try (FileWriter writer = new FileWriter(file);){
                    NEIClientConfig.logger.info("Creating default serial handlers list {}", new Object[]{file});
                    List<String> toSave = Loader.isModLoaded((String)"dreamcraft") ? Collections.singletonList("") : Arrays.asList(defaultSerialHandlers);
                    IOUtils.writeLines(toSave, (String)"\n", (Writer)writer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                NEIClientConfig.logger.error("Failed to save default serial handlers list to file {}", new Object[]{file, e});
            }
        }
        try {
            throwable = null;
            try (FileReader reader = new FileReader(file);){
                NEIClientConfig.logger.info("Loading serial handlers from file {}", new Object[]{file});
                NEIClientConfig.serialHandlers = new HashSet(IOUtils.readLines((Reader)reader));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Failed to load serial handlers from file {}", new Object[]{file, e});
        }
    }

    public static void loadHeightHackHandlers() {
        Throwable throwable;
        File file = NEIClientConfig.heightHackHandlersFile;
        if (!file.exists()) {
            try {
                throwable = null;
                try (FileWriter writer = new FileWriter(file);){
                    NEIClientConfig.logger.info("Creating default height hack handlers list {}", new Object[]{file});
                    List<String> toSave = Arrays.asList(defaultHeightHackHandlerRegex);
                    IOUtils.writeLines(toSave, (String)"\n", (Writer)writer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                NEIClientConfig.logger.error("Failed to save default height hack handlers list to file {}", new Object[]{file, e});
            }
        }
        try {
            throwable = null;
            try (FileReader reader = new FileReader(file);){
                NEIClientConfig.logger.info("Loading height hack handlers from file {}", new Object[]{file});
                NEIClientConfig.heightHackHandlerRegex = IOUtils.readLines((Reader)reader).stream().map(Pattern::compile).collect(Collectors.toCollection(HashSet::new));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Failed to load height hack handlers from file {}", new Object[]{file, e});
        }
    }

    public static void load() {
        instance = new ClientHandler();
        GuiModListScroll.register((Object)"NotEnoughItems");
        PacketCustom.assignHandler((Object)"NEI", (PacketCustom.ICustomPacketHandler)new NEICPH());
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        API.registerHighlightHandler(new DefaultHighlightHandler(), ItemInfo.Layout.HEADER);
        HUDRenderer.load();
        WorldOverlayRenderer.load();
    }

    public static void postInit() {
        ClientHandler.loadHandlerOrdering();
    }

    public static void loadHandlerOrdering() {
        URL url;
        File file = NEIClientConfig.handlerOrderingFile;
        if (!file.exists()) {
            try (FileWriter writer = new FileWriter(file);){
                NEIClientConfig.logger.info("Creating default handler ordering CSV {}", new Object[]{file});
                ArrayList toWrite = Lists.newArrayList((Object[])defaultHandlerOrdering);
                GuiRecipeTab.handlerMap.keySet().stream().sorted().forEach(handlerId -> toWrite.add(String.format("%s,0", handlerId)));
                IOUtils.writeLines((Collection)toWrite, (String)"\n", (Writer)writer);
            }
            catch (IOException e) {
                NEIClientConfig.logger.error("Failed to save default handler ordering to file {}", new Object[]{file, e});
            }
        }
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            NEIClientConfig.logger.info("Invalid URL for handler ordering CSV.");
            e.printStackTrace();
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            NEIClientConfig.logger.info("Loading handler ordering from file {}", new Object[]{file});
            CSVParser csvParser = CSVFormat.EXCEL.withCommentMarker('#').parse(reader);
            for (CSVRecord record : csvParser) {
                int ordering;
                String handlerId2 = record.get(0);
                try {
                    ordering = Integer.parseInt(record.get(1));
                }
                catch (NumberFormatException e) {
                    NEIClientConfig.logger.error("Error parsing CSV record {}: {}", new Object[]{record, e});
                    continue;
                }
                NEIClientConfig.handlerOrdering.put(handlerId2, ordering);
            }
        }
        catch (Exception e) {
            NEIClientConfig.logger.info("Error parsing CSV");
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.ClientTickEvent event) {
        GuiScreen gui;
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            this.loadWorld((World)mc.field_71441_e, false);
            if (!NEIClientConfig.isEnabled()) {
                return;
            }
            KeyManager.tickKeyStates();
            NEIController.updateUnlimitedItems(mc.field_71439_g.field_71071_by);
            if (mc.field_71462_r == null) {
                NEIController.processCreativeCycling(mc.field_71439_g.field_71071_by);
            }
            this.updateMagnetMode((World)mc.field_71441_e, (EntityPlayerSP)mc.field_71439_g);
        }
        if ((gui = mc.field_71462_r) != this.lastGui) {
            if (gui instanceof GuiMainMenu) {
                this.lastworld = null;
            } else if (gui instanceof GuiSelectWorld) {
                NEIClientConfig.reloadSaves();
            }
        }
        this.lastGui = gui;
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && NEIClientConfig.isEnabled()) {
            HUDRenderer.renderOverlay();
        }
    }

    @SubscribeEvent
    public void renderLastEvent(RenderWorldLastEvent event) {
        if (NEIClientConfig.isEnabled()) {
            WorldOverlayRenderer.render(event.partialTicks);
        }
    }

    public void loadWorld(World world, boolean fromServer) {
        if (world != this.lastworld) {
            this.SMPmagneticItems.clear();
            WorldOverlayRenderer.reset();
            if (!fromServer) {
                NEIClientConfig.setHasSMPCounterPart(false);
                NEIClientConfig.setInternalEnabled(false);
                if (!Minecraft.func_71410_x().func_71356_B()) {
                    NEIClientConfig.loadWorld("remote/" + ClientUtils.getServerIP().replace(':', '~'));
                }
            }
            this.lastworld = world;
        }
    }

    public static ClientHandler instance() {
        return instance;
    }

    public static RuntimeException throwCME(final String message) {
        GuiErrorScreen errorGui = new GuiErrorScreen(null, null){

            public void func_146274_d() {
            }

            public void func_146282_l() {
            }

            public void func_73863_a(int par1, int par2, float par3) {
                this.func_146276_q_();
                String[] s_msg = message.split("\n");
                for (int i = 0; i < s_msg.length; ++i) {
                    this.func_73732_a(this.field_146289_q, s_msg[i], this.field_146294_l / 2, this.field_146295_m / 3 + 12 * i, -1);
                }
            }
        };
        CustomModLoadingErrorDisplayException e = new CustomModLoadingErrorDisplayException((GuiScreen)errorGui){
            final /* synthetic */ GuiScreen val$errorGui;
            {
                this.val$errorGui = guiScreen;
            }

            public void initGui(GuiErrorScreen errorScreen, FontRenderer fontRenderer) {
                Minecraft.func_71410_x().func_147108_a(this.val$errorGui);
            }

            public void drawScreen(GuiErrorScreen errorScreen, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
            }
        };
        throw e;
    }
}

