/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemsGrid;
import codechicken.nei.Label;
import codechicken.nei.LayoutManager;
import codechicken.nei.LayoutStyleMinecraft;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.BookmarkRecipeId;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.NBTJson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;

public class BookmarkPanel
extends ItemPanel {
    protected File bookmarkFile;
    protected boolean bookmarksIsLoaded = false;
    public int sortedStackIndex = -1;
    public int sortedNamespaceIndex = -1;
    public Button namespacePrev;
    public Button namespaceNext;
    public Label namespaceLabel;
    protected ArrayList<BookmarkGrid> namespaces = new ArrayList();
    public int activeNamespaceIndex = 0;

    public BookmarkPanel() {
        this.grid = new BookmarkGrid();
    }

    @Override
    public void init() {
        super.init();
        this.namespaceLabel = new Label("1", true);
        this.namespacePrev = new Button("Prev"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                return BookmarkPanel.this.prevNamespace();
            }

            @Override
            public String getRenderLabel() {
                return "<";
            }
        };
        this.namespaceNext = new Button("Next"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                return BookmarkPanel.this.nextNamespace();
            }

            @Override
            public String getRenderLabel() {
                return ">";
            }
        };
        this.namespaces.add(new BookmarkGrid());
        this.grid = this.namespaces.get(this.activeNamespaceIndex);
    }

    @Override
    public String getLabelText() {
        return super.getLabelText() + " [" + this.grid.size() + "]";
    }

    public void addOrRemoveItem(ItemStack stackA) {
        this.addOrRemoveItem(stackA, "", null);
    }

    public void addOrRemoveItem(ItemStack stackover, String handlerName, List<PositionedStack> ingredients) {
        this.loadBookmarksIfNeeded();
        Point mousePos = GuiDraw.getMousePosition();
        ItemPanel.ItemPanelSlot slot = this.getSlotMouseOver(mousePos.x, mousePos.y);
        boolean addFullRecipe = NEIClientUtils.shiftKey();
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        if (slot != null && StackInfo.equalItemAndNBT(slot.item, stackover, true)) {
            BGrid.removeRecipe(slot.slotIndex, addFullRecipe);
        } else {
            int idx;
            boolean saveStackSize = NEIClientUtils.controlKey();
            NBTTagCompound nbTagA = StackInfo.itemStackToNBT(stackover, saveStackSize);
            ItemStack normalizedA = StackInfo.loadFromNBT(nbTagA);
            BookmarkRecipeId recipeId = null;
            if (NEIClientConfig.saveCurrentRecipeInBookmarksEnabled() && handlerName != "" && ingredients != null && ingredients.size() > 0) {
                recipeId = new BookmarkRecipeId(handlerName, ingredients);
            }
            if ((idx = BGrid.indexOf(normalizedA, recipeId)) != -1) {
                BGrid.removeRecipe(idx, addFullRecipe);
            } else {
                if (addFullRecipe && handlerName != "" && ingredients != null) {
                    HashMap<NBTTagCompound, Integer> unique = new HashMap<NBTTagCompound, Integer>();
                    ArrayList<NBTTagCompound> sorted = new ArrayList<NBTTagCompound>();
                    BGrid.removeRecipe(recipeId);
                    for (PositionedStack stack : ingredients) {
                        NBTTagCompound nbTag = StackInfo.itemStackToNBT(stack.item, saveStackSize);
                        if (unique.get(nbTag) == null) {
                            unique.put(nbTag, 1);
                            sorted.add(nbTag);
                            continue;
                        }
                        if (!saveStackSize) continue;
                        unique.put(nbTag, (Integer)unique.get(nbTag) + 1);
                    }
                    for (NBTTagCompound nbTag : sorted) {
                        nbTag.func_74768_a("Count", nbTag.func_74762_e("Count") * (Integer)unique.get(nbTag));
                        BGrid.addItem(StackInfo.loadFromNBT(nbTag), new BookmarkStackMeta(recipeId, nbTag.func_74762_e("Count"), true));
                    }
                }
                BGrid.addItem(normalizedA, new BookmarkStackMeta(recipeId, nbTagA.func_74762_e("Count"), false));
            }
        }
        this.fixCountOfNamespaces();
        this.saveBookmarks();
    }

    public BookmarkRecipeId getBookmarkRecipeId(ItemStack stackA) {
        Point mousePos = GuiDraw.getMousePosition();
        ItemPanel.ItemPanelSlot slot = this.getSlotMouseOver(mousePos.x, mousePos.y);
        if (slot != null && StackInfo.equalItemAndNBT(slot.item, stackA, true)) {
            return ((BookmarkGrid)this.grid).getRecipeId(slot.slotIndex);
        }
        BookmarkRecipeId recipeId = ((BookmarkGrid)this.grid).findRecipeId(stackA);
        if (recipeId == null) {
            for (int idx = 0; idx < this.namespaces.size() && recipeId == null; ++idx) {
                if (idx == this.activeNamespaceIndex) continue;
                recipeId = this.namespaces.get(idx).findRecipeId(stackA);
            }
        }
        return recipeId;
    }

    protected String getNamespaceLabelText(boolean shortFormat) {
        String activePage = String.valueOf(this.activeNamespaceIndex + 1);
        return shortFormat ? activePage : activePage + "/" + this.fixCountOfNamespaces();
    }

    protected int fixCountOfNamespaces() {
        if (this.namespaces.get(this.namespaces.size() - 1).size() > 0) {
            this.namespaces.add(new BookmarkGrid());
        } else if (this.activeNamespaceIndex == this.namespaces.size() - 2 && this.grid.size() == 0) {
            this.namespaces.remove(this.namespaces.size() - 1);
        }
        return this.namespaces.size();
    }

    protected boolean removeEmptyNamespaces() {
        if (this.activeNamespaceIndex != this.namespaces.size() - 1 && this.grid.size() == 0) {
            this.namespaces.remove(this.activeNamespaceIndex);
            this.grid = this.namespaces.get(this.activeNamespaceIndex);
            return true;
        }
        return false;
    }

    protected boolean prevNamespace() {
        if (!this.bookmarksIsLoaded) {
            return false;
        }
        this.fixCountOfNamespaces();
        this.removeEmptyNamespaces();
        this.activeNamespaceIndex = this.activeNamespaceIndex == 0 ? this.namespaces.size() - 1 : --this.activeNamespaceIndex;
        this.grid = this.namespaces.get(this.activeNamespaceIndex);
        return true;
    }

    protected boolean nextNamespace() {
        if (!this.bookmarksIsLoaded) {
            return false;
        }
        if (this.removeEmptyNamespaces()) {
            return true;
        }
        this.activeNamespaceIndex = this.activeNamespaceIndex == this.fixCountOfNamespaces() - 1 ? 0 : ++this.activeNamespaceIndex;
        this.grid = this.namespaces.get(this.activeNamespaceIndex);
        return true;
    }

    public void setBookmarkFile(String worldPath) {
        File dir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/" + worldPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.bookmarkFile = new File(dir, "bookmarks.ini");
        if (!this.bookmarkFile.exists()) {
            File defaultBookmarks;
            File globalBookmarks = new File(CommonUtils.getMinecraftDir(), "saves/NEI/global/bookmarks.ini");
            File configBookmarks = new File(NEIClientConfig.configDir, "bookmarks.ini");
            File file = defaultBookmarks = configBookmarks.exists() ? configBookmarks : globalBookmarks;
            if (defaultBookmarks.exists()) {
                try {
                    this.bookmarkFile.createNewFile();
                    FileInputStream src = new FileInputStream(defaultBookmarks);
                    FileOutputStream dst = new FileOutputStream(this.bookmarkFile);
                    IOUtils.copy((InputStream)src, (OutputStream)dst);
                    ((InputStream)src).close();
                    ((OutputStream)dst).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.bookmarksIsLoaded = false;
    }

    public void saveBookmarks() {
        if (this.bookmarkFile == null) {
            return;
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (int grpIdx = 0; grpIdx < this.namespaces.size() - 1; ++grpIdx) {
            BookmarkGrid grid = this.namespaces.get(grpIdx);
            if (grpIdx > 0) {
                strings.add("");
            }
            for (int idx = 0; idx < grid.size(); ++idx) {
                try {
                    NBTTagCompound nbTag = StackInfo.itemStackToNBT(grid.getItem(idx));
                    if (nbTag == null) continue;
                    JsonObject row = new JsonObject();
                    BookmarkStackMeta meta = grid.getMetadata(idx);
                    row.add("item", NBTJson.toJsonObject((NBTBase)nbTag));
                    row.add("factor", (JsonElement)new JsonPrimitive((Number)meta.factor));
                    row.add("ingredient", (JsonElement)new JsonPrimitive(Boolean.valueOf(meta.ingredient)));
                    if (meta.recipeId != null) {
                        row.add("recipeId", (JsonElement)meta.recipeId.toJsonObject());
                    }
                    strings.add(NBTJson.toJson((JsonElement)row));
                    continue;
                }
                catch (JsonSyntaxException e) {
                    NEIClientConfig.logger.error("Failed to stringify bookmarked ItemStack to json string");
                }
            }
        }
        try (FileOutputStream output = new FileOutputStream(this.bookmarkFile);){
            IOUtils.writeLines(strings, (String)"\n", (OutputStream)output, (String)"UTF-8");
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Filed to save bookmarks list to file {}", new Object[]{this.bookmarkFile, e});
        }
    }

    public void loadBookmarksIfNeeded() {
        List itemStrings;
        if (this.bookmarksIsLoaded) {
            return;
        }
        this.bookmarksIsLoaded = true;
        if (this.bookmarkFile == null || !this.bookmarkFile.exists()) {
            return;
        }
        try {
            FileReader reader = new FileReader(this.bookmarkFile);
            Object object = null;
            try {
                NEIClientConfig.logger.info("Loading bookmarks from file {}", new Object[]{this.bookmarkFile});
                itemStrings = IOUtils.readLines((Reader)reader);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Failed to load bookmarks from file {}", new Object[]{this.bookmarkFile, e});
            return;
        }
        this.namespaces.clear();
        this.namespaces.add(new BookmarkGrid());
        this.activeNamespaceIndex = 0;
        JsonParser parser = new JsonParser();
        for (String itemStr : itemStrings) {
            try {
                ItemStack itemStack;
                if (itemStr.isEmpty()) {
                    if (this.namespaces.get(this.activeNamespaceIndex).size() <= 0) continue;
                    this.namespaces.add(new BookmarkGrid());
                    ++this.activeNamespaceIndex;
                    continue;
                }
                JsonObject jsonObject = parser.parse(itemStr).getAsJsonObject();
                BookmarkRecipeId recipeId = null;
                NBTTagCompound itemStackNBT = jsonObject.get("item") != null ? (NBTTagCompound)NBTJson.toNbt(jsonObject.get("item")) : (NBTTagCompound)NBTJson.toNbt((JsonElement)jsonObject);
                if (jsonObject.get("recipeId") != null && jsonObject.get("recipeId") instanceof JsonObject) {
                    recipeId = new BookmarkRecipeId((JsonObject)jsonObject.get("recipeId"));
                }
                if ((itemStack = StackInfo.loadFromNBT(itemStackNBT)) != null) {
                    this.namespaces.get(this.activeNamespaceIndex).addItem(itemStack, new BookmarkStackMeta(recipeId, jsonObject.has("factor") ? jsonObject.get("factor").getAsInt() : 1, jsonObject.has("ingredient") ? jsonObject.get("ingredient").getAsBoolean() : false));
                    continue;
                }
                NEIClientConfig.logger.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", new Object[]{itemStr});
            }
            catch (JsonSyntaxException | IllegalArgumentException e) {
                NEIClientConfig.logger.error("Failed to load bookmarked ItemStack from json string:\n{}", new Object[]{itemStr});
            }
        }
        if (this.namespaces.get(this.activeNamespaceIndex).size() == 0) {
            this.activeNamespaceIndex = Math.max(this.activeNamespaceIndex - 1, 0);
        }
        this.grid = this.namespaces.get(this.activeNamespaceIndex);
    }

    @Override
    public void resize(GuiContainer gui) {
        this.loadBookmarksIfNeeded();
        super.resize(gui);
        int buttonHeight = 16;
        int buttonWidth = 16;
        int buttonTop = gui.field_146295_m - 16 - 2;
        int leftBorder = LayoutManager.bookmarksButton.x + LayoutManager.bookmarksButton.w + 2;
        int rightBorder = this.x + this.w;
        int center = leftBorder + (rightBorder - leftBorder) / 2;
        int labelWidth = 2;
        this.namespaceNext.h = 16;
        this.namespacePrev.h = 16;
        this.namespaceNext.w = 16;
        this.namespacePrev.w = 16;
        this.namespacePrev.y = this.namespaceNext.y = buttonTop;
        if (rightBorder - leftBorder >= 70) {
            labelWidth = 36;
            this.namespaceLabel.text = this.getNamespaceLabelText(false);
        } else {
            labelWidth = 18;
            this.namespaceLabel.text = this.getNamespaceLabelText(true);
        }
        this.namespaceLabel.y = buttonTop + 5;
        this.namespaceLabel.x = center;
        this.namespacePrev.x = center - labelWidth / 2 - 2 - this.namespacePrev.w;
        this.namespaceNext.x = center + labelWidth / 2 + 2;
    }

    @Override
    public void setVisible() {
        super.setVisible();
        LayoutManager.addWidget(this.namespacePrev);
        LayoutManager.addWidget(this.namespaceNext);
        LayoutManager.addWidget(this.namespaceLabel);
    }

    @Override
    public int getMarginLeft(GuiContainer gui) {
        return 5;
    }

    @Override
    public int getMarginTop(GuiContainer gui) {
        LayoutStyleMinecraft layout = (LayoutStyleMinecraft)LayoutManager.getLayoutStyle();
        return 2 + (int)Math.ceil((double)layout.buttonCount / (double)layout.numButtons) * 18;
    }

    @Override
    public int getWidth(GuiContainer gui) {
        return LayoutManager.getLeftSize(gui) - ((gui.field_146999_f + gui.field_146294_l) / 2 + 3) - 16;
    }

    @Override
    public int getHeight(GuiContainer gui) {
        return gui.field_146295_m - this.getMarginTop(gui) - 23;
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        if (button == 0 && NEIClientUtils.shiftKey() && this.mouseDownSlot >= 0) {
            ItemPanel.ItemPanelSlot mouseOverSlot = this.getSlotMouseOver(mousex, mousey);
            if (this.sortedStackIndex == -1) {
                ItemStack stack = this.grid.getItem(this.mouseDownSlot);
                if (stack != null && (mouseOverSlot == null || mouseOverSlot.slotIndex != this.mouseDownSlot || heldTime > 250L)) {
                    this.sortedNamespaceIndex = this.activeNamespaceIndex;
                    this.sortedStackIndex = this.mouseDownSlot;
                }
            } else {
                if (mouseOverSlot == null && this.sortedNamespaceIndex != this.activeNamespaceIndex) {
                    mouseOverSlot = this.getNextSlot(mousex, mousey);
                }
                if (mouseOverSlot != null) {
                    if (this.sortedNamespaceIndex != this.activeNamespaceIndex) {
                        BookmarkGrid BGrid = this.namespaces.get(this.sortedNamespaceIndex);
                        BookmarkStackMeta meta = BGrid.getMetadata(this.sortedStackIndex);
                        ItemStack stack = BGrid.getItem(this.sortedStackIndex);
                        BGrid.removeItem(this.sortedStackIndex);
                        ((BookmarkGrid)this.grid).addItem(stack, meta);
                        this.sortedNamespaceIndex = this.activeNamespaceIndex;
                        this.sortedStackIndex = this.grid.size() - 1;
                    }
                    if (mouseOverSlot.slotIndex != this.sortedStackIndex) {
                        ((BookmarkGrid)this.grid).moveItem(this.sortedStackIndex, mouseOverSlot.slotIndex);
                        this.sortedStackIndex = mouseOverSlot.slotIndex;
                    }
                }
            }
            return;
        }
        super.mouseDragged(mousex, mousey, button, heldTime);
    }

    private ItemPanel.ItemPanelSlot getNextSlot(int mousex, int mousey) {
        int idx = this.grid.getPage() * this.grid.getPerPage() - this.grid.getPerPage();
        int gSize = this.grid.size();
        for (int i = 0; i < this.grid.getRows() * this.grid.getColumns() && idx <= gSize; ++i) {
            if (this.grid.isInvalidSlot(i)) continue;
            if (idx == gSize && this.grid.getSlotRect(i).contains(mousex, mousey)) {
                return new ItemPanel.ItemPanelSlot(idx, null);
            }
            ++idx;
        }
        return null;
    }

    @Override
    public void postDraw(int mousex, int mousey) {
        if (this.sortedStackIndex != -1) {
            GuiContainerManager.drawItems.field_77023_b += 100.0f;
            GuiContainerManager.drawItem(mousex - 8, mousey - 8, this.namespaces.get(this.sortedNamespaceIndex).getItem(this.sortedStackIndex).func_77946_l(), true);
            GuiContainerManager.drawItems.field_77023_b -= 100.0f;
        }
        super.postDraw(mousex, mousey);
    }

    @Override
    protected ItemStack getDraggedStackWithQuantity(int mouseDownSlot) {
        ItemStack stack = this.grid.getItem(mouseDownSlot);
        return stack != null ? stack.func_77946_l() : null;
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        if (this.sortedStackIndex != -1) {
            this.draggedStack = null;
            this.sortedNamespaceIndex = -1;
            this.sortedStackIndex = -1;
            this.mouseDownSlot = -1;
            this.saveBookmarks();
        } else {
            super.mouseUp(mousex, mousey, button);
        }
    }

    @Override
    public boolean onMouseWheel(int shift, int mousex, int mousey) {
        ItemPanel.ItemPanelSlot slot;
        if (new Rectangle4i(this.namespacePrev.x, this.namespacePrev.y, this.namespaceNext.x + this.namespaceNext.w - this.namespacePrev.x, this.namespacePrev.h).contains(mousex, mousey)) {
            if (shift > 0) {
                this.prevNamespace();
            } else {
                this.nextNamespace();
            }
            return true;
        }
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        if (NEIClientUtils.controlKey() && (slot = this.getSlotMouseOver(mousex, mousey)) != null) {
            BookmarkGrid BGrid = (BookmarkGrid)this.grid;
            BookmarkRecipeId recipeId = BGrid.getRecipeId(slot.slotIndex);
            BookmarkStackMeta meta = BGrid.getMetadata(slot.slotIndex);
            boolean addFullRecipe = NEIClientUtils.shiftKey();
            if (addFullRecipe) {
                for (int slotIndex = this.grid.size() - 1; slotIndex >= 0; --slotIndex) {
                    BookmarkStackMeta iMeta = BGrid.getMetadata(slotIndex);
                    if (iMeta.recipeId == null || !iMeta.recipeId.equals(recipeId)) continue;
                    NBTTagCompound nbTag = StackInfo.itemStackToNBT(BGrid.getItem(slotIndex), true);
                    nbTag.func_74768_a("Count", Math.max(nbTag.func_74762_e("Count") + iMeta.factor * shift, iMeta.factor));
                    BGrid.replaceItem(slotIndex, StackInfo.loadFromNBT(nbTag));
                }
            }
            NBTTagCompound nbTag = StackInfo.itemStackToNBT(slot.item, true);
            nbTag.func_74768_a("Count", Math.max(nbTag.func_74762_e("Count") + meta.factor * shift, meta.factor));
            BGrid.replaceItem(slot.slotIndex, StackInfo.loadFromNBT(nbTag));
            this.saveBookmarks();
            return true;
        }
        return super.onMouseWheel(shift, mousex, mousey);
    }

    protected static class BookmarkGrid
    extends ItemsGrid {
        protected List<BookmarkStackMeta> metadata = new ArrayList<BookmarkStackMeta>();

        protected BookmarkGrid() {
        }

        public int indexOf(ItemStack stackA, BookmarkRecipeId recipeId) {
            boolean useNBT = NEIClientConfig.useNBTInBookmarks();
            for (int idx = 0; idx < this.realItems.size(); ++idx) {
                BookmarkStackMeta meta = this.getMetadata(idx);
                if ((recipeId != null || meta.recipeId != null) && (recipeId == null || meta.recipeId == null || !recipeId.equals(meta.recipeId)) || !StackInfo.equalItemAndNBT(stackA, (ItemStack)this.realItems.get(idx), useNBT)) continue;
                return idx;
            }
            return -1;
        }

        public BookmarkStackMeta getMetadata(int idx) {
            return this.metadata.get(idx);
        }

        public void addItem(ItemStack stackA, BookmarkStackMeta meta) {
            this.realItems.add(stackA);
            this.metadata.add(meta);
        }

        public void replaceItem(int idx, ItemStack stack) {
            this.realItems.set(idx, stack);
        }

        public void removeRecipe(int idx, boolean removeFullRecipe) {
            BookmarkStackMeta meta = this.getMetadata(idx);
            if (removeFullRecipe && meta.recipeId != null) {
                this.removeRecipe(meta.recipeId);
            } else {
                this.removeItem(idx);
            }
        }

        public void removeRecipe(BookmarkRecipeId recipeIdA) {
            for (int slotIndex = this.metadata.size() - 1; slotIndex >= 0; --slotIndex) {
                BookmarkRecipeId recipeIdB = this.getRecipeId(slotIndex);
                if (recipeIdB == null || !recipeIdA.equals(recipeIdB)) continue;
                this.removeItem(slotIndex);
            }
        }

        protected boolean removeItem(int idx) {
            this.realItems.remove(idx);
            this.metadata.remove(idx);
            return true;
        }

        public BookmarkRecipeId getRecipeId(int idx) {
            return this.getMetadata((int)idx).recipeId;
        }

        public BookmarkRecipeId findRecipeId(ItemStack stackA) {
            boolean useNBT = NEIClientConfig.useNBTInBookmarks();
            for (int idx = 0; idx < this.realItems.size(); ++idx) {
                if (!StackInfo.equalItemAndNBT(stackA, this.getItem(idx), useNBT)) continue;
                return this.getRecipeId(idx);
            }
            return null;
        }

        public void moveItem(int src, int dst) {
            this.realItems.add(dst, this.realItems.remove(src));
            this.metadata.add(dst, this.metadata.remove(src));
        }

        @Override
        protected void drawItem(Rectangle4i rect, int idx, ItemPanel.ItemPanelSlot focus) {
            if (LayoutManager.bookmarkPanel.sortedNamespaceIndex == LayoutManager.bookmarkPanel.activeNamespaceIndex && LayoutManager.bookmarkPanel.sortedStackIndex == idx) {
                GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
            } else {
                if (focus != null) {
                    if (focus.slotIndex == idx) {
                        GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
                    } else if (LayoutManager.bookmarkPanel.sortedStackIndex == -1 && NEIClientUtils.shiftKey() && this.getRecipeId(focus.slotIndex) != null && this.getRecipeId(idx) != null && this.getRecipeId(focus.slotIndex).equals(this.getRecipeId(idx))) {
                        GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)(this.getMetadata((int)idx).ingredient ? -2001489152 : -2013226701));
                    }
                }
                GuiContainerManager.drawItem(rect.x + 1, rect.y + 1, this.getItem(idx), true);
            }
        }
    }

    protected static class BookmarkStackMeta {
        public int factor;
        public BookmarkRecipeId recipeId;
        public boolean ingredient = false;

        public BookmarkStackMeta(BookmarkRecipeId recipeId, int count, boolean ingredient) {
            this.recipeId = recipeId;
            this.factor = count;
            this.ingredient = ingredient;
        }
    }
}

