/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;

public class HandlerInfo {
    public static int DEFAULT_HEIGHT = 65;
    public static int DEFAULT_WIDTH = 166;
    public static int DEFAULT_MAX_PER_PAGE = 2;
    private String handler;
    private String modName;
    private String modId;
    private boolean requiresMod = true;
    private String excludedModId;
    private String itemId;
    private String nbtString;
    private int yShift = 0;
    private int height = DEFAULT_HEIGHT;
    private int width = DEFAULT_WIDTH;
    private int maxRecipesPerPage = DEFAULT_MAX_PER_PAGE;
    private ItemStack itemStack = null;
    private DrawableResource image = null;

    public HandlerInfo(String handler, String modName, String modId, boolean requiresMod, String excludedModId) {
        this.handler = handler;
        this.modName = modName;
        this.modId = modId;
        this.requiresMod = requiresMod;
        this.excludedModId = excludedModId;
    }

    public void setHandlerDimensions(int height, int width, int maxRecipesPerPage) {
        this.height = height;
        this.width = width;
        this.maxRecipesPerPage = maxRecipesPerPage;
    }

    public boolean setItem(String itemId, String nbtString) {
        if (this.hasImageOrItem()) {
            return false;
        }
        int meta = -1;
        if (!itemId.contains(":")) {
            NEIClientConfig.logger.info("Item ID missing colon for handler " + this.handler + " - " + this.modName);
            return false;
        }
        String[] split = itemId.split(":");
        String itemLookupId = split[0] + ":" + split[1];
        if (split.length >= 3) {
            int mIdx = -1;
            if (split[2].matches("\\d+")) {
                mIdx = 2;
            } else {
                itemLookupId = itemLookupId + ":" + split[2];
                if (split.length >= 4) {
                    mIdx = 3;
                }
            }
            if (mIdx != -1) {
                meta = Integer.parseInt(split[mIdx]);
            }
        }
        if (meta != -1) {
            this.itemStack = GameRegistry.makeItemStack((String)itemLookupId, (int)meta, (int)1, (String)(nbtString == null ? "" : nbtString));
        } else {
            this.itemStack = GameRegistry.findItemStack((String)split[0], (String)split[1], (int)1);
            if (nbtString != null && !nbtString.equals("")) {
                try {
                    NBTBase nbttag = JsonToNBT.func_150315_a((String)nbtString);
                    if (!(nbttag instanceof NBTTagCompound)) {
                        NEIClientConfig.logger.info("Unexpected NBT string - multiple values {}", new Object[]{nbtString});
                        return false;
                    }
                    this.itemStack.func_77982_d((NBTTagCompound)nbttag);
                }
                catch (NBTException e) {
                    FMLLog.getLogger().log(Level.WARN, "Encountered an exception parsing ItemStack NBT string {}", new Object[]{nbtString, e});
                    return false;
                }
            }
        }
        if (this.itemStack == null) {
            NEIClientConfig.logger.info("Couldn't find " + this.modName + " - " + itemLookupId);
        } else {
            this.itemId = itemId;
            this.nbtString = nbtString;
        }
        return this.itemStack != null;
    }

    public boolean setImage(String resourceLocation, int imageX, int imageY, int imageWidth, int imageHeight) {
        if (this.hasImageOrItem()) {
            return false;
        }
        this.image = new DrawableBuilder(resourceLocation, imageX, imageY, imageWidth, imageHeight).build();
        return true;
    }

    public DrawableResource getImage() {
        return this.image;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public String getModName() {
        return this.modName;
    }

    public String getModId() {
        return this.modId;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getMaxRecipesPerPage() {
        return Math.max(this.maxRecipesPerPage, 1);
    }

    public int getYShift() {
        return this.yShift;
    }

    public boolean hasImageOrItem() {
        if (this.image != null) {
            return true;
        }
        return this.itemStack != null;
    }

    public void setYShift(int yShift) {
        this.yShift = yShift;
    }
}

