/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.TaskProfiler;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.FuelRecipeHandler;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.ProfilerRecipeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class GuiCraftingRecipe
extends GuiRecipe {
    public ArrayList<ICraftingHandler> currenthandlers;
    public static ArrayList<ICraftingHandler> craftinghandlers = new ArrayList();
    public static ArrayList<ICraftingHandler> serialCraftingHandlers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean openRecipeGui(String outputId, Object ... results) {
        ArrayList handlers;
        Minecraft mc = NEIClientUtils.mc();
        GuiScreen prevscreen = mc.field_71462_r;
        TaskProfiler profiler = ProfilerRecipeHandler.getProfiler();
        profiler.start("recipe.concurrent.crafting");
        FuelRecipeHandler.findFuelsOnceParallel();
        try {
            handlers = serialCraftingHandlers.stream().map(h -> h.getRecipeHandler(outputId, results)).filter(h -> h.numRecipes() > 0).collect(Collectors.toCollection(ArrayList::new));
            handlers.addAll((Collection)((ForkJoinTask)ItemList.forkJoinPool.submit(() -> craftinghandlers.parallelStream().map(h -> h.getRecipeHandler(outputId, results)).filter(h -> h.numRecipes() > 0).collect(Collectors.toCollection(ArrayList::new)))).get());
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            profiler.end();
        }
        if (handlers.isEmpty()) {
            return false;
        }
        mc.func_147108_a((GuiScreen)new GuiCraftingRecipe(prevscreen, handlers));
        return true;
    }

    private GuiCraftingRecipe(GuiScreen prevgui, ArrayList<ICraftingHandler> handlers) {
        super(prevgui);
        this.currenthandlers = handlers;
    }

    public static void registerRecipeHandler(ICraftingHandler handler) {
        Class<?> handlerClass = handler.getClass();
        if (craftinghandlers.stream().anyMatch(h -> h.getClass() == handlerClass) || serialCraftingHandlers.stream().anyMatch(h -> h.getClass() == handlerClass)) {
            return;
        }
        String handlerClassStr = handlerClass.getName();
        if (NEIClientConfig.serialHandlers.contains(handlerClassStr)) {
            serialCraftingHandlers.add(handler);
        } else {
            craftinghandlers.add(handler);
        }
    }

    @Override
    public ArrayList<? extends IRecipeHandler> getCurrentRecipeHandlers() {
        return this.currenthandlers;
    }
}

