/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class FuelRecipeHandler
extends FurnaceRecipeHandler {
    private final ArrayList<FurnaceRecipeHandler.SmeltingPair> mfurnace = new ArrayList();

    public FuelRecipeHandler() {
        this.loadAllSmelting();
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.fuel", new Object[0]);
    }

    private void loadAllSmelting() {
        Map smeltingRecipes = FurnaceRecipes.func_77602_a().func_77599_b();
        smeltingRecipes.entrySet().stream().map(recipe -> new FurnaceRecipeHandler.SmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue())).collect(Collectors.toCollection(() -> this.mfurnace));
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("fuel") && this.getClass() == FuelRecipeHandler.class) {
            afuels.stream().map(x$0 -> new CachedFuelRecipe((FurnaceRecipeHandler.FuelPair)x$0)).collect(Collectors.toCollection(() -> this.arecipes));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        afuels.stream().filter(fuel -> fuel != null && fuel.stack != null && fuel.stack.contains(ingredient)).map(x$0 -> new CachedFuelRecipe((FurnaceRecipeHandler.FuelPair)x$0)).collect(Collectors.toCollection(() -> this.arecipes));
    }

    @Override
    public String getOverlayIdentifier() {
        return "fuel";
    }

    @Override
    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        CachedFuelRecipe crecipe = (CachedFuelRecipe)this.arecipes.get(recipe);
        FurnaceRecipeHandler.FuelPair fuel = crecipe.fuel;
        float burnTime = (float)fuel.burnTime / 200.0f;
        if (gui.isMouseOver(fuel.stack, recipe) && burnTime < 1.0f) {
            burnTime = 1.0f / burnTime;
            String s_time = Float.toString(burnTime);
            if (burnTime == (float)Math.round(burnTime)) {
                s_time = Integer.toString((int)burnTime);
            }
            currenttip.add(NEIClientUtils.translate("recipe.fuel.required", s_time));
        } else if ((gui.isMouseOver(crecipe.getResult(), recipe) || gui.isMouseOver(crecipe.getIngredient(), recipe)) && burnTime > 1.0f) {
            String s_time = Float.toString(burnTime);
            if (burnTime == (float)Math.round(burnTime)) {
                s_time = Integer.toString((int)burnTime);
            }
            currenttip.add(NEIClientUtils.translate("recipe.fuel." + (gui.isMouseOver(crecipe.getResult(), recipe) ? "produced" : "processed"), s_time));
        }
        return currenttip;
    }

    public class CachedFuelRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final FurnaceRecipeHandler.FuelPair fuel;

        public CachedFuelRecipe(FurnaceRecipeHandler.FuelPair fuel) {
            this.fuel = fuel;
        }

        @Override
        public PositionedStack getIngredient() {
            return ((FurnaceRecipeHandler.SmeltingPair)((FuelRecipeHandler)FuelRecipeHandler.this).mfurnace.get((int)(FuelRecipeHandler.this.cycleticks / 48 % ((FuelRecipeHandler)FuelRecipeHandler.this).mfurnace.size()))).ingred;
        }

        @Override
        public PositionedStack getResult() {
            return ((FurnaceRecipeHandler.SmeltingPair)((FuelRecipeHandler)FuelRecipeHandler.this).mfurnace.get((int)(FuelRecipeHandler.this.cycleticks / 48 % ((FuelRecipeHandler)FuelRecipeHandler.this).mfurnace.size()))).result;
        }

        @Override
        public PositionedStack getOtherStack() {
            return this.fuel.stack;
        }
    }
}

