/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.config.DataDumper;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import codechicken.nei.util.NBTJson;
import com.google.common.base.Objects;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import org.apache.commons.io.IOUtils;

public class HandlerDumper
extends DataDumper {
    public HandlerDumper(String name) {
        super(name);
    }

    @Override
    public String[] header() {
        return new String[]{"Handler Recipe Name", "Handler Class", "Overlay Identifier", "Mod DisplayName", "ItemStack"};
    }

    @Override
    public Iterable<String[]> dump(int mode) {
        LinkedList<String[]> list = new LinkedList<String[]>();
        for (IRecipeHandler iRecipeHandler : GuiUsageRecipe.usagehandlers) {
            String handlerName = iRecipeHandler.toString().split("@")[0];
            String handlerId = (String)Objects.firstNonNull((Object)(iRecipeHandler instanceof TemplateRecipeHandler ? ((TemplateRecipeHandler)iRecipeHandler).getOverlayIdentifier() : null), (Object)"null");
            HandlerInfo info = GuiRecipeTab.getHandlerInfo(handlerName, handlerId);
            list.add(new String[]{iRecipeHandler.getRecipeName(), handlerName, handlerId, info != null ? info.getModName() : "Unknown", info != null && info.getItemStack() != null ? info.getItemStack().toString() : "Unknown"});
        }
        return list;
    }

    @Override
    public String renderName() {
        return this.translateN(this.name, new Object[0]);
    }

    @Override
    public String getFileExtension() {
        switch (this.getMode()) {
            case 0: {
                return ".csv";
            }
            case 1: {
                return ".json";
            }
        }
        return null;
    }

    public ChatComponentTranslation dumpMessage(File file) {
        return new ChatComponentTranslation(this.namespaced(this.name + ".dumped"), new Object[]{"dumps/" + file.getName()});
    }

    @Override
    public String modeButtonText() {
        return this.translateN(this.name + ".mode." + this.getMode(), new Object[0]);
    }

    @Override
    public void dumpTo(File file) throws IOException {
        if (this.getMode() == 0) {
            super.dumpTo(file);
        } else {
            this.dumpJson(file);
        }
    }

    public void dumpJson(File file) throws IOException {
        String[] header = this.header();
        try {
            FileWriter writer = new FileWriter(file);
            for (String[] list : this.dump(this.getMode())) {
                NBTTagCompound tag = new NBTTagCompound();
                for (int i = 0; i < header.length; ++i) {
                    tag.func_74778_a(header[i], list[i]);
                }
                IOUtils.write((String)(NBTJson.toJson(tag) + "\n"), (Writer)writer);
            }
            writer.close();
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Filed to save dump handler list to file {}", new Object[]{file, e});
        }
    }

    @Override
    public int modeCount() {
        return 2;
    }
}

